/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sem.h
* @brief       Declaration of Semaphore interafces
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_SEM_H
#define FC_SXM_SEM_H
#include <sys/types.h>
#include <pthread.h>


class fc_sxm_tclSem {
 public:
    fc_sxm_tclSem(tVoid);
    ~fc_sxm_tclSem(tVoid);

    tVoid vOpen(tU32 u32InitVal= 1);
    tVoid vClose(tVoid);
    tVoid vGet();
    tBool bGet(tU32 u32TimeoutMs);
    tVoid vPost();

    tBool bIsLocked() {
        return _u32Count ? TRUE : FALSE;
    }
    
 private:
    OSAL_tSemHandle _hSem;
    string _oSemName;
    //    pid_t _u32Tid;
    pthread_t    _u32Tid;
    tU32 _u32Count;
    
};


// example:
#if 0
fc_sxm_tclSem oMySem;
oMySem.vInit();

tVoid myFn() {
    // constructor will lock the semaphoer
    fc_sxm_tclScopedLock(oMySem);
    doSomething();
    return;
    // on exit of the function destructor will unlock the sem
}
#endif

class fc_sxm_tclScopedLock {
 public:
    fc_sxm_tclScopedLock(fc_sxm_tclSem &oSem) {
        poSem=&oSem;
        poSem->vGet();
    }
    ~fc_sxm_tclScopedLock() {
        if (OSAL_NULL != poSem) {
            poSem->vPost();
            poSem = NULL;
        }
    }
 private:
    fc_sxm_tclSem *poSem;
};

#endif
