/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_pers_data.cpp
* @brief       Implementation of persistance related & datapool apis
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_tcl_pers_data.h"
#include "fc_sxm_tcl_config.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_sxm_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_CONFIG
#include "trcGenProj/Header/fc_sxm_tcl_pers_data.cpp.trc.h"
#endif


trUserConfig::trUserConfig()
{
    trSportsUserData::instance();
    trAppUserData::instance();
}

trUserConfig::~trUserConfig() {
}

tVoid trUserConfig::vGetData(tVoid) {
    trSportsUserData::instance()->vGetData();
    trAppUserData::instance()->vGetData();
}

tVoid trUserConfig::vSetData(tVoid) {
    trSportsUserData::instance()->vSetData();
    trAppUserData::instance()->vSetData();
}


fc_sxm_tclPersData::fc_sxm_tclPersData()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData CTOR"));
    /* Read KDS parameter */
    _bIsMixedPreset = fc_sxm_tclConfig::instance()->bGetPresetType();
    _u8NumberOfPresets = 18;
    if(_bIsMixedPreset) { 
        _u8NumberOfPresets = fc_sxm_tclConfig::instance()->u8GetNumberOfPresets();
    }
}

tVoid fc_sxm_tclPersData::vClearDPAppsFavoriteList()
{
    vClearDPMoviesFavoriteList();
    vClearDPFuelFavoriteList();
    vClearDPCanFuelFavoriteList();
    vClearDPStocksFavoriteList();
}

tVoid fc_sxm_tclPersData::vSetDefaultSettings(tBool bResetAllUsers) {
    // delete current data
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDefaultSettings bResetAllUsers=%d START",
            bResetAllUsers));

    /* Call Persistant data  Methods  to Clear Fav Data */
    trSportsUserData::instance()->vClearFavoriteList();
    trAppUserData::instance()->vClearInternalFavoriteList();
    //clear dp
    vClearDPAppsFavoriteList();


    //CHECK FOR WITHOUT VLOAD
    vLoadData();
    // todo: send trigger to all apps to check new config-data. by now we don't intend to stopp the apps
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDefaultSettings END"));

}

tVoid fc_sxm_tclPersData::vLoadData() {
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vLoadData START"));

    /*retrieving dp config apps flags*/
    vGetDBErrorConfig();

    _rUserConfig.vGetData();

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vLoadData END"));
}

tVoid  fc_sxm_tclPersData::vSaveData()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSaveData START"));

    _rUserConfig.vSetData();

    /*restoring dp config apps flags*/
    vSetDBErrorConfig();

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSaveData END"));
}


tVoid fc_sxm_tclPersData::vSetPersistentDbError(tBool bSet, fc_sxm_tenServiceID enServiceId) {

    tU8 u8Index=(tU8)(enServiceId>>8u);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetPersistentDbError(%d) bSet=%d u8Index=%u flag=0x%02x",
            ETG_CENUM(fc_sxm_tenServiceID, enServiceId), bSet, u8Index, _rDPConfig.au8AppFlags[u8Index]));
    if (u8Index<FC_SXM_PERS_DATA_NUM_DATA_APP_MAX) {
        SXM_SET_BIT(bSet, _rDPConfig.au8AppFlags[u8Index], (tU8)FC_SXM_PERS_DATA_APP_FLAG_SXM_DB_ERR_DETECTED);
    }
}

tBool fc_sxm_tclPersData::bGetPersistentDbError(fc_sxm_tenServiceID enServiceId) {
    tU8 u8Index=(tU8)(enServiceId>>8);
    tBool bRes=FALSE;
    if (u8Index<FC_SXM_PERS_DATA_NUM_DATA_APP_MAX) {
        bRes = ((_rDPConfig.au8AppFlags[u8Index] & FC_SXM_PERS_DATA_APP_FLAG_SXM_DB_ERR_DETECTED)!=0);
        ETG_TRACE_USR4(("fc_sxm_tclPersData::bGetPersistentDbError(%d) bRes=%d index=0x%02x flag=0x%08x",
                ETG_CENUM(fc_sxm_tenServiceID, enServiceId), bRes, u8Index, _rDPConfig.au8AppFlags[u8Index]));
    }
    else {
        ETG_TRACE_ERR(("fc_sxm_tclPersData::bGetPersistentDbError(%d) index=0x%02x out of bound",
                ETG_CENUM(fc_sxm_tenServiceID, enServiceId), u8Index));

    }

    return bRes;
}

/*          Datapool specific Apis       */

tVoid fc_sxm_tclPersData::vGetDBErrorConfig()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPConfig"));
    dp_tclFcSxmDPDBErrorConfig dpConfigElem;
    tU8 configSize = FC_SXM_PERS_DATA_NUM_DATA_APP_MAX;

    dpConfigElem.s32GetData(_rDPConfig.au8AppFlags, configSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPConfig() _rDPConfig.au8AppFlags=%s",_rDPConfig.au8AppFlags));
}

tVoid fc_sxm_tclPersData::vSetDBErrorConfig()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPConfig"));
    dp_tclFcSxmDPDBErrorConfig dpConfigElem;

    tU8 configSize = FC_SXM_PERS_DATA_NUM_DATA_APP_MAX;
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPConfig() _rDPConfig.au8AppFlags=%s",_rDPConfig.au8AppFlags));

    dpConfigElem.s32SetData(_rDPConfig.au8AppFlags, configSize);
}


tVoid fc_sxm_tclPersData::vGetDPSportsList(tSXMAudio_ProtectedSportList& trSportsData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPSportsList"));
    tU32 u32DpSportListSize = 0;
    vGetDPSportsListSize(u32DpSportListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPSportsList() u32DpSportListSize=%d",u32DpSportListSize));

    if(u32DpSportListSize > 0) {
        dpSportListElement paBbufferListElement[u32DpSportListSize];

        dp_tclFcSxmDPSportsList sSportsListElement;
        sSportsListElement.s32GetData (paBbufferListElement, u32DpSportListSize);

        for(tU32 u32Count=0; u32Count<u32DpSportListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPSportsList() paBbufferListElement[%d](u8SportID, sSportName) = (%d, %s)",
                    u32Count,
                    paBbufferListElement[u32Count].u8SportID,
                    paBbufferListElement[u32Count].sSportName));

            trSportListElement tElementData; /* Create sport list element */
            tElementData.u8SportID = paBbufferListElement[u32Count].u8SportID; /* Get element sport ID */
            tElementData.sSportName.assign(paBbufferListElement[u32Count].sSportName, strlen(paBbufferListElement[u32Count].sSportName) + 1);
            trSportsData.vSportList.push_back(tElementData); /* Insert element into sport list */
        }
    }
}

tVoid fc_sxm_tclPersData::vSetDPSportsList(tSXMAudio_ProtectedSportList& trSportsData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPSportsList"));
    tU32 u32DpSportListSize = (tU32)(trSportsData.vSportList.size());
    vSetDPSportsListSize(u32DpSportListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPSportsList() u32DpSportListSize=%d",u32DpSportListSize));

    if(u32DpSportListSize > 0) {
        dpSportListElement paBbufferListElement[u32DpSportListSize];

        for(tU32 u32Count=0; u32Count<u32DpSportListSize; u32Count++){
            paBbufferListElement[u32Count].u8SportID = trSportsData.vSportList[u32Count].u8SportID;
            strncpy(paBbufferListElement[u32Count].sSportName, trSportsData.vSportList[u32Count].sSportName.c_str()
                    ,strlen(trSportsData.vSportList[u32Count].sSportName.c_str()) + 1);

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPSportsList() paBbufferListElement[%d](u8SportID, sSportName) = (%d, %s)",
                    u32Count,
                    paBbufferListElement[u32Count].u8SportID,
                    paBbufferListElement[u32Count].sSportName));
        }
        dp_tclFcSxmDPSportsList sSportsListElement;
        tU32 u32Status = sSportsListElement.s32SetData (paBbufferListElement, u32DpSportListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPSportsList() Status: %d",u32Status));
        }
    }

}

tVoid fc_sxm_tclPersData::vGetDPRootList(tSXMAudio_ProtectedRootList& trRootData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPRootList"));
    tU32 u32DpRootListSize = 0;
    vGetDPRootListSize(u32DpRootListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPRootList() u32DpRootListSize=%d",u32DpRootListSize));
    //SIZE CHECK
    if(u32DpRootListSize > 0) {
        dpRootListElement paBbufferRootListElement[u32DpRootListSize];

        dp_tclFcSxmDPSportsRootList sRootListElement;
        sRootListElement.s32GetData (paBbufferRootListElement, u32DpRootListSize);

        for(tU32 u32Count=0; u32Count<u32DpRootListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPRootList() paBbufferRootListElement[%d](u8SportID, u32AffiliateID, u8Season, sAffiliateName) = (%d, %d, %d, %s)",
                    u32Count,
                    paBbufferRootListElement[u32Count].u8SportID,
                    paBbufferRootListElement[u32Count].u32AffiliateID,
                    paBbufferRootListElement[u32Count].u8Season,
                    paBbufferRootListElement[u32Count].sAffiliateName));

            trRootListElement tElementData;   /* Create root list element */
            tElementData.u8SportID = paBbufferRootListElement[u32Count].u8SportID;  /* Get Sport ID */
            tElementData.u32AffiliateID = paBbufferRootListElement[u32Count].u32AffiliateID;  /* Get element affiliate ID */
            tElementData.sAffiliateName.assign(paBbufferRootListElement[u32Count].sAffiliateName
                    , strlen(paBbufferRootListElement[u32Count].sAffiliateName) + 1);
            tElementData.u8Season = paBbufferRootListElement[u32Count].u8Season; /* Get element affiliate season */
            trRootData.vRootList.push_back(tElementData);
        }
    }
}

tVoid fc_sxm_tclPersData::vSetDPRootList(tSXMAudio_ProtectedRootList& trRootData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPRootList"));
    tU32 u32DpRootListSize = (tU32)(trRootData.vRootList.size());
    vSetDPRootListSize(u32DpRootListSize);

    if(u32DpRootListSize > 0) {
        dpRootListElement paBbufferRootListElement[u32DpRootListSize];

        for(tU32 u32Count=0; u32Count<u32DpRootListSize; u32Count++){
            paBbufferRootListElement[u32Count].u8SportID = trRootData.vRootList[u32Count].u8SportID;
            paBbufferRootListElement[u32Count].u32AffiliateID = trRootData.vRootList[u32Count].u32AffiliateID;
            strncpy(paBbufferRootListElement[u32Count].sAffiliateName, trRootData.vRootList[u32Count].sAffiliateName.c_str()
                    ,strlen(trRootData.vRootList[u32Count].sAffiliateName.c_str()) + 1);
            paBbufferRootListElement[u32Count].u8Season = trRootData.vRootList[u32Count].u8Season;

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPRootList() paBbufferRootListElement[%d](u8SportID, u32AffiliateID, u8Season, sAffiliateName) = (%d, %d, %d, %s)",
                    u32Count,
                    paBbufferRootListElement[u32Count].u8SportID,
                    paBbufferRootListElement[u32Count].u32AffiliateID,
                    paBbufferRootListElement[u32Count].u8Season,
                    paBbufferRootListElement[u32Count].sAffiliateName));
        }
        dp_tclFcSxmDPSportsRootList sRootListElement;
        tU32 u32Status = sRootListElement.s32SetData (paBbufferRootListElement, u32DpRootListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPRootList() Status: %d",u32Status));
        }
    }
}

tVoid fc_sxm_tclPersData::vGetDPFavoriteList(tSXMAudio_ProtectedFavoriteList& trFavData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFavoriteList"));
    tU32 u32DpFavoriteListSize = 0;
    vGetDPFavoriteListSize(u32DpFavoriteListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFavoriteList() u32DpFavoriteListSize=%d",u32DpFavoriteListSize));

    if(u32DpFavoriteListSize > 0) {
        dpFavoriteListElement paBbufferFavoriteListElement[u32DpFavoriteListSize];

        dp_tclFcSxmDPSportsFavoriteList sFavoriteListElement;
        sFavoriteListElement.s32GetData (paBbufferFavoriteListElement, u32DpFavoriteListSize);

        for(tU32 u32Count=0; u32Count<u32DpFavoriteListSize; u32Count++) {
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFavoriteList() paBbufferFavoriteListElement[%d](u8SportID, u32TeamID, u32LeagueID, u32GDRef, sTeamName) = (%d, %d, %d, %d, %s)",
                    u32Count,
                    paBbufferFavoriteListElement[u32Count].u8SportID,
                    paBbufferFavoriteListElement[u32Count].u32TeamID,
                    paBbufferFavoriteListElement[u32Count].u32LeagueID,
                    paBbufferFavoriteListElement[u32Count].u32GDRef,
                    paBbufferFavoriteListElement[u32Count].sTeamName));

            trFavoriteListElement tElementData; /* Create favorite list element */
            tElementData.u8SportID = paBbufferFavoriteListElement[u32Count].u8SportID;     /* Get element sport ID */
            tElementData.u32TeamID = paBbufferFavoriteListElement[u32Count].u32TeamID;     /* Get element team ID */
            tElementData.u32LeagueID = paBbufferFavoriteListElement[u32Count].u32LeagueID;   /* Get element league ID */
            tElementData.u32GDRef = paBbufferFavoriteListElement[u32Count].u32GDRef;     /* Get element Global Reference ID */
            tElementData.sTeamName.assign(paBbufferFavoriteListElement[u32Count].sTeamName
                    , strlen(paBbufferFavoriteListElement[u32Count].sTeamName) + 1);
            tElementData.sTeamAbrName.assign(paBbufferFavoriteListElement[u32Count].sTeamAbrName
                    , strlen(paBbufferFavoriteListElement[u32Count].sTeamAbrName) + 1);
            tElementData.sTeamKnownName.assign(paBbufferFavoriteListElement[u32Count].sTeamKnownName
                    , strlen(paBbufferFavoriteListElement[u32Count].sTeamKnownName) + 1);
            tElementData.sTeamNickName.assign(paBbufferFavoriteListElement[u32Count].sTeamNickName
                    , strlen(paBbufferFavoriteListElement[u32Count].sTeamNickName) + 1);
            tElementData.sSportName.assign(paBbufferFavoriteListElement[u32Count].sSportName
                    , strlen(paBbufferFavoriteListElement[u32Count].sSportName) + 1);
            trFavData.vFavoriteList.push_back(tElementData); /* Insert element into favorite list */
        }
    }

}

tVoid fc_sxm_tclPersData::vSetDPFavoriteList(tSXMAudio_ProtectedFavoriteList& trFavData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFavoriteList"));
    tU32 u32DpFavoriteListSize = (tU32)(trFavData.vFavoriteList.size());
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFavoriteList() u32DpFavoriteListSize=%d",u32DpFavoriteListSize));

    vSetDPFavoriteListSize(u32DpFavoriteListSize);

    if(u32DpFavoriteListSize > 0) {
        dpFavoriteListElement paBbufferFavoriteListElement[u32DpFavoriteListSize];

        for(tU32 u32Count=0; u32Count<u32DpFavoriteListSize; u32Count++){
            paBbufferFavoriteListElement[u32Count].u8SportID = trFavData.vFavoriteList[u32Count].u8SportID;
            paBbufferFavoriteListElement[u32Count].u32TeamID = trFavData.vFavoriteList[u32Count].u32TeamID;
            paBbufferFavoriteListElement[u32Count].u32LeagueID = trFavData.vFavoriteList[u32Count].u32LeagueID;
            paBbufferFavoriteListElement[u32Count].u32GDRef = trFavData.vFavoriteList[u32Count].u32GDRef;
            strncpy(paBbufferFavoriteListElement[u32Count].sTeamName, trFavData.vFavoriteList[u32Count].sTeamName.c_str()
                    ,strlen(trFavData.vFavoriteList[u32Count].sTeamName.c_str()) + 1);
            strncpy(paBbufferFavoriteListElement[u32Count].sTeamAbrName, trFavData.vFavoriteList[u32Count].sTeamAbrName.c_str()
                    ,strlen(trFavData.vFavoriteList[u32Count].sTeamAbrName.c_str()) + 1);
            strncpy(paBbufferFavoriteListElement[u32Count].sTeamKnownName, trFavData.vFavoriteList[u32Count].sTeamKnownName.c_str()
                    ,strlen(trFavData.vFavoriteList[u32Count].sTeamKnownName.c_str()) + 1);
            strncpy(paBbufferFavoriteListElement[u32Count].sTeamNickName, trFavData.vFavoriteList[u32Count].sTeamNickName.c_str()
                    ,strlen(trFavData.vFavoriteList[u32Count].sTeamNickName.c_str()) + 1);
            strncpy(paBbufferFavoriteListElement[u32Count].sSportName, trFavData.vFavoriteList[u32Count].sSportName.c_str()
                    ,strlen(trFavData.vFavoriteList[u32Count].sSportName.c_str()) + 1);
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFavoriteList() paBbufferFavoriteListElement[%d](u8SportID, u32TeamID, u32LeagueID, u32GDRef, sTeamName) = (%d, %d, %d, %d, %s)",
                    u32Count,
                    paBbufferFavoriteListElement[u32Count].u8SportID,
                    paBbufferFavoriteListElement[u32Count].u32TeamID,
                    paBbufferFavoriteListElement[u32Count].u32LeagueID,
                    paBbufferFavoriteListElement[u32Count].u32GDRef,
                    paBbufferFavoriteListElement[u32Count].sTeamName));
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFavoriteList() paBbufferFavoriteListElement[u32Count].sSportName=%s",paBbufferFavoriteListElement[u32Count].sSportName));
        }
        dp_tclFcSxmDPSportsFavoriteList sFavoriteListElement;
        tU32 u32Status = sFavoriteListElement.s32SetData (paBbufferFavoriteListElement, u32DpFavoriteListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPFavoriteList() Status: %d",u32Status));
        }
    }

}

tVoid fc_sxm_tclPersData::vGetDPSportsListSize(tU32& u32DpSportsListSize) const
{
    dp_tclFcSxmDPSportsListSize dpSportslistElemSize;
    dpSportslistElemSize.s32GetData(u32DpSportsListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPSportsListSize() u32DpSportsListSize=%d",u32DpSportsListSize));
}

tVoid fc_sxm_tclPersData::vSetDPSportsListSize(tU32 u32DpSportsListSize) const
{
    dp_tclFcSxmDPSportsListSize dpSportslistElemSize;
    dpSportslistElemSize.s32SetData(u32DpSportsListSize);

}

tVoid fc_sxm_tclPersData::vGetDPRootListSize(tU32& u32DpRootListSize) const
{
    dp_tclFcSxmDPSportsRootListSize dpRootlistElemSize;
    dpRootlistElemSize.s32GetData(u32DpRootListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPRootListSize() u32DpSportRootListSize=%d",u32DpRootListSize));
}

tVoid fc_sxm_tclPersData::vSetDPRootListSize(tU32 u32DpRootListSize) const
{
    dp_tclFcSxmDPSportsRootListSize dpRootlistElemSize;
    dpRootlistElemSize.s32SetData(u32DpRootListSize);

}

tVoid fc_sxm_tclPersData::vGetDPFavoriteListSize(tU32& u32DpFavoriteListSize) const
{
    dp_tclFcSxmDPSportsFavoriteListSize dpFavoritelistElemSize;
    dpFavoritelistElemSize.s32GetData(u32DpFavoriteListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFavoriteListSize() u32DpFavoriteListSize=%d",u32DpFavoriteListSize));

}

tVoid fc_sxm_tclPersData::vSetDPFavoriteListSize(tU32 u32DpFavoriteListSize) const
{
    dp_tclFcSxmDPSportsFavoriteListSize dpFavoritelistElemSize;
    dpFavoritelistElemSize.s32SetData(u32DpFavoriteListSize);

}

tVoid fc_sxm_tclPersData::vClearDPMoviesFavoriteList()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vClearDPMoviesFavoriteList"));
    tU32 u32DpMoviesFavoriteListSize = 0;
    vGetDPMoviesFavoriteListSize(u32DpMoviesFavoriteListSize);
    if(u32DpMoviesFavoriteListSize > 0) {
        dp_tclFcSxmDPMoviesFavoriteList sMoviesFavoriteListElement;
        dpAppListElement paBbufferListElement[u32DpMoviesFavoriteListSize];
        memset(paBbufferListElement,0,u32DpMoviesFavoriteListSize);
        sMoviesFavoriteListElement.s32SetData (paBbufferListElement, u32DpMoviesFavoriteListSize);

        dp_tclFcSxmDPMoviesFavoriteListSize dpMoviesFavoriteListElemSize;
        tU32 u32DpMoviesFavoriteListSize = 0;
        dpMoviesFavoriteListElemSize.s32SetData(u32DpMoviesFavoriteListSize);
    }
}


//Read method for Movies favorite list from datapool
tVoid fc_sxm_tclPersData::vGetDPMoviesFavoriteList(tSXMDataService_ProtectedMoviesFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPMoviesFavoriteList"));

    tU32 u32DpMoviesFavoriteListSize = 0;
    vGetDPMoviesFavoriteListSize(u32DpMoviesFavoriteListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPMoviesFavoriteList() u32DpMoviesFavoriteListSize=%d",u32DpMoviesFavoriteListSize));

    if(u32DpMoviesFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpMoviesFavoriteListSize];

        dp_tclFcSxmDPMoviesFavoriteList sMoviesFavoriteListElement;
        sMoviesFavoriteListElement.s32GetData (paBbufferListElement, u32DpMoviesFavoriteListSize);

        for(tU32 u32Count=0; u32Count<u32DpMoviesFavoriteListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPMoviesFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
            tU32 tElementData = paBbufferListElement[u32Count].u32LocID; /* Get element loc ID */
            trAppData.vMoviesFavoriteList.push_back(tElementData); /* Insert element into App list */
        }
    }
}

//Write method for Movies favorite list from datapool
tVoid fc_sxm_tclPersData::vSetDPMoviesFavoriteList(tSXMDataService_ProtectedMoviesFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPMoviesFavoriteList"));

    tU32 u32DpMoviesFavoriteListSize = (tU32)(trAppData.vMoviesFavoriteList.size());
    vSetDPMoviesFavoriteListSize(u32DpMoviesFavoriteListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPMoviesFavoriteList() u32DpMoviesFavoriteListSize=%d",u32DpMoviesFavoriteListSize));

    if(u32DpMoviesFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpMoviesFavoriteListSize];

        for(tU32 u32Count=0; u32Count<u32DpMoviesFavoriteListSize; u32Count++){
            paBbufferListElement[u32Count].u32LocID = trAppData.vMoviesFavoriteList[u32Count];
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPMoviesFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
        }
        dp_tclFcSxmDPMoviesFavoriteList sMoviesFavoriteListElement;
        tU32 u32Status = sMoviesFavoriteListElement.s32SetData (paBbufferListElement, u32DpMoviesFavoriteListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPMoviesFavoriteList() Status: %d",u32Status));
        }
    }
}

tVoid fc_sxm_tclPersData::vGetDPMoviesFavoriteListSize(tU32& u32DpMoviesFavoriteListSize) const
{
    dp_tclFcSxmDPMoviesFavoriteListSize dpMoviesFavoriteListElemSize;
    dpMoviesFavoriteListElemSize.s32GetData(u32DpMoviesFavoriteListSize);
}

tVoid fc_sxm_tclPersData::vSetDPMoviesFavoriteListSize(tU32 u32DpMoviesFavoriteListSize) const
{
    dp_tclFcSxmDPMoviesFavoriteListSize dpMoviesFavoriteListElemSize;
    dpMoviesFavoriteListElemSize.s32SetData(u32DpMoviesFavoriteListSize);
}


tVoid fc_sxm_tclPersData::vClearDPFuelFavoriteList()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vClearDPFuelFavoriteList"));
    tU32 u32DpFuelFavoriteListSize = 0;
    vGetDPFuelFavoriteListSize(u32DpFuelFavoriteListSize);
    if(u32DpFuelFavoriteListSize > 0) {
        dp_tclFcSxmDPFuelFavoriteList sFuelFavoriteListElement;
        dpAppListElement paBbufferListElement[u32DpFuelFavoriteListSize];
        memset(paBbufferListElement,0,u32DpFuelFavoriteListSize);
        sFuelFavoriteListElement.s32SetData (paBbufferListElement, u32DpFuelFavoriteListSize);

        dp_tclFcSxmDPFuelFavoriteListSize dpFuelFavoriteListElemSize;
        tU32 u32DpFuelFavoriteListSize = 0;
        dpFuelFavoriteListElemSize.s32SetData(u32DpFuelFavoriteListSize);
    }
}

//Read method for Fuel favorite list from datapool
tVoid fc_sxm_tclPersData::vGetDPFuelFavoriteList(tSXMDataService_ProtectedFuelFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFuelFavoriteList"));

    tU32 u32DpFuelFavoriteListSize = 0;
    vGetDPFuelFavoriteListSize(u32DpFuelFavoriteListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFuelFavoriteList() u32DpFuelFavoriteListSize=%d",u32DpFuelFavoriteListSize));

    if(u32DpFuelFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpFuelFavoriteListSize];

        dp_tclFcSxmDPFuelFavoriteList sFuelFavoriteListElement;
        sFuelFavoriteListElement.s32GetData (paBbufferListElement, u32DpFuelFavoriteListSize);

        for(tU32 u32Count=0; u32Count<u32DpFuelFavoriteListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPFuelFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
            tU32 tElementData;
            tElementData = paBbufferListElement[u32Count].u32LocID; /* Get element loc ID */
            trAppData.vFuelFavoriteList.push_back(tElementData); /* Insert element into App list */
        }
    }
}

//Write method for Fuel favorite list from datapool
tVoid fc_sxm_tclPersData::vSetDPFuelFavoriteList(tSXMDataService_ProtectedFuelFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFuelFavoriteList"));

    tU32 u32DpFuelFavoriteListSize = (tU32)(trAppData.vFuelFavoriteList.size());
    vSetDPFuelFavoriteListSize(u32DpFuelFavoriteListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFuelFavoriteList() u32DpFuelFavoriteListSize=%d",u32DpFuelFavoriteListSize));

    if(u32DpFuelFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpFuelFavoriteListSize];

        for(tU32 u32Count=0; u32Count<u32DpFuelFavoriteListSize; u32Count++){
            paBbufferListElement[u32Count].u32LocID = trAppData.vFuelFavoriteList[u32Count];
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPFuelFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
        }
        dp_tclFcSxmDPFuelFavoriteList sFuelFavoriteListElement;
        tU32 u32Status = sFuelFavoriteListElement.s32SetData (paBbufferListElement, u32DpFuelFavoriteListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPFuelFavoriteList() Status: %d",u32Status));
        }
    }
}

tVoid fc_sxm_tclPersData::vGetDPFuelFavoriteListSize(tU32& u32DpFuelFavoriteListSize) const
{
    dp_tclFcSxmDPFuelFavoriteListSize dpFuelFavoriteListElemSize;
    dpFuelFavoriteListElemSize.s32GetData(u32DpFuelFavoriteListSize);
}

tVoid fc_sxm_tclPersData::vSetDPFuelFavoriteListSize(tU32 u32DpFuelFavoriteListSize) const
{
    dp_tclFcSxmDPFuelFavoriteListSize dpFuelFavoriteListElemSize;
    dpFuelFavoriteListElemSize.s32SetData(u32DpFuelFavoriteListSize);

}


tVoid fc_sxm_tclPersData::vClearDPCanFuelFavoriteList()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vClearDPCanFuelFavoriteList"));
    tU32 u32DpCanFuelFavoriteListSize = 0;
    vGetDPCanFuelFavoriteListSize(u32DpCanFuelFavoriteListSize);
    if(u32DpCanFuelFavoriteListSize > 0) {
        dp_tclFcSxmDPCanadianFuelFavoriteList sCanFuelFavoriteListElement;
        dpAppListElement paBbufferListElement[u32DpCanFuelFavoriteListSize];
        memset(paBbufferListElement,0,u32DpCanFuelFavoriteListSize);
        sCanFuelFavoriteListElement.s32SetData (paBbufferListElement, u32DpCanFuelFavoriteListSize);

        dp_tclFcSxmDPCanadianFuelFavoriteListSize dpCanFuelFavoriteListElemSize;
        tU32 u32DpCanFuelFavoriteListSize = 0;
        dpCanFuelFavoriteListElemSize.s32SetData(u32DpCanFuelFavoriteListSize);
    }
}
//Read method for Canadian Fuel favorite list from datapool
tVoid fc_sxm_tclPersData::vGetDPCanFuelFavoriteList(tSXMDataService_ProtectedCanFuelFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPCanFuelFavoriteList"));

    tU32 u32DpCanFuelFavoriteListSize = 0;
    vGetDPCanFuelFavoriteListSize(u32DpCanFuelFavoriteListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPCanFuelFavoriteList() u32DpCanFuelFavoriteListSize=%d",u32DpCanFuelFavoriteListSize));

    if(u32DpCanFuelFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpCanFuelFavoriteListSize];

        dp_tclFcSxmDPCanadianFuelFavoriteList sCanFuelFavoriteListElement;
        sCanFuelFavoriteListElement.s32GetData (paBbufferListElement, u32DpCanFuelFavoriteListSize);

        for(tU32 u32Count=0; u32Count<u32DpCanFuelFavoriteListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPCanFuelFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
            tU32 tElementData;
            tElementData = paBbufferListElement[u32Count].u32LocID; /* Get element loc ID */
            trAppData.vCanFuelFavoriteList.push_back(tElementData); /* Insert element into App list */
        }
    }
}

//Write method for Canadian Fuel favorite list from datapool
tVoid fc_sxm_tclPersData::vSetDPCanFuelFavoriteList(tSXMDataService_ProtectedCanFuelFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPCanFuelFavoriteList"));

    tU32 u32DpCanFuelFavoriteListSize = (tU32)(trAppData.vCanFuelFavoriteList.size());
    vSetDPCanFuelFavoriteListSize(u32DpCanFuelFavoriteListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPCanFuelFavoriteList() u32DpCanFuelFavoriteListSize=%d",u32DpCanFuelFavoriteListSize));

    if(u32DpCanFuelFavoriteListSize > 0) {
        dpAppListElement paBbufferListElement[u32DpCanFuelFavoriteListSize];

        for(tU32 u32Count=0; u32Count<u32DpCanFuelFavoriteListSize; u32Count++){

            paBbufferListElement[u32Count].u32LocID = trAppData.vCanFuelFavoriteList[u32Count];
            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPCanFuelFavoriteList() paBbufferListElement[%d](u32LocID) = (%d)",
                    u32Count,
                    paBbufferListElement[u32Count].u32LocID));
        }
        dp_tclFcSxmDPCanadianFuelFavoriteList sCanFuelFavoriteListElement;
        tU32 u32Status = sCanFuelFavoriteListElement.s32SetData (paBbufferListElement, u32DpCanFuelFavoriteListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPCanFuelFavoriteList() Status: %d",u32Status));
        }
    }
}

tVoid fc_sxm_tclPersData::vGetDPCanFuelFavoriteListSize(tU32& u32DpCanFuelFavoriteListSize) const
{
    dp_tclFcSxmDPCanadianFuelFavoriteListSize dpCanFuelFavoriteListElemSize;
    dpCanFuelFavoriteListElemSize.s32GetData(u32DpCanFuelFavoriteListSize);

}

tVoid fc_sxm_tclPersData::vSetDPCanFuelFavoriteListSize(tU32 u32DpCanFuelFavoriteListSize) const
{
    dp_tclFcSxmDPCanadianFuelFavoriteListSize dpCanFuelFavoriteListElemSize;
    dpCanFuelFavoriteListElemSize.s32SetData(u32DpCanFuelFavoriteListSize);

}


tVoid fc_sxm_tclPersData::vClearDPStocksFavoriteList()
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vClearDPStocksFavoriteList"));
    tU32 u32DpStocksFavoriteListSize = 0;
    vGetDPStocksFavoriteListSize(u32DpStocksFavoriteListSize);
    if(u32DpStocksFavoriteListSize > 0) {
        dp_tclFcSxmDPStocksFavoriteList sStocksFavoriteListElement;
        dpStockListElement paBbufferListElement[u32DpStocksFavoriteListSize];
        memset(paBbufferListElement,0,u32DpStocksFavoriteListSize);
        sStocksFavoriteListElement.s32SetData (paBbufferListElement, u32DpStocksFavoriteListSize);

        dp_tclFcSxmDPStocksFavoriteListSize dpStocksFavoriteListElemSize;
        tU32 u32DpStocksFavoriteListSize = 0;
        dpStocksFavoriteListElemSize.s32SetData(u32DpStocksFavoriteListSize);
    }
}
//Read method for Stocks favorite list from datapool
tVoid fc_sxm_tclPersData::vGetDPStocksFavoriteList(tSXMDataService_ProtectedStocksFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPStocksFavoriteList"));

    tU32 u32DpStocksFavoriteListSize = 0;
    vGetDPStocksFavoriteListSize(u32DpStocksFavoriteListSize);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPStocksFavoriteList() u32DpStocksFavoriteListSize=%d",u32DpStocksFavoriteListSize));

    if(u32DpStocksFavoriteListSize > 0) {
        dpStockListElement paBbufferListElement[u32DpStocksFavoriteListSize];

        dp_tclFcSxmDPStocksFavoriteList sStocksFavoriteListElement;
        sStocksFavoriteListElement.s32GetData (paBbufferListElement, u32DpStocksFavoriteListSize);

        for(tU32 u32Count=0; u32Count<u32DpStocksFavoriteListSize; u32Count++) {

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vGetDPStocksFavoriteList() paBbufferListElement[%d](sName) = (%s)",
                    u32Count,
                    paBbufferListElement[u32Count].sName));

            string sElementData;
            sElementData.assign(paBbufferListElement[u32Count].sName);
            trAppData.vStocksFavoriteList.push_back(sElementData); /* Insert element into App list */
        }
    }
}

//Write method for Stocks favorite list from datapool
tVoid fc_sxm_tclPersData::vSetDPStocksFavoriteList(tSXMDataService_ProtectedStocksFavoriteList& trAppData)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPStocksFavoriteList"));

    tU32 u32DpStocksFavoriteListSize = (tU32)(trAppData.vStocksFavoriteList.size());
    vSetDPStocksFavoriteListSize(u32DpStocksFavoriteListSize);

    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPStocksFavoriteList() u32DpStocksFavoriteListSize=%d",u32DpStocksFavoriteListSize));

    if(u32DpStocksFavoriteListSize > 0) {
        dpStockListElement paBbufferListElement[u32DpStocksFavoriteListSize];

        for(tU32 u32Count=0; u32Count<u32DpStocksFavoriteListSize; u32Count++){

            strncpy(paBbufferListElement[u32Count].sName, trAppData.vStocksFavoriteList[u32Count].c_str()
                    ,strlen(trAppData.vStocksFavoriteList[u32Count].c_str()) + 1);

            ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPStocksFavoriteList() paBbufferListElement[%d](sName) = (%s)",
                    u32Count,
                    paBbufferListElement[u32Count].sName));
        }
        dp_tclFcSxmDPStocksFavoriteList sStocksFavoriteListElement;
        tU32 u32Status = sStocksFavoriteListElement.s32SetData (paBbufferListElement, u32DpStocksFavoriteListSize);

        if(u32Status != 0){
            ETG_TRACE_ERR(("fc_sxm_tclPersData::vSetDPStocksFavoriteList() Status: %d",u32Status));
        }
    }
}

tVoid fc_sxm_tclPersData::vGetDPStocksFavoriteListSize(tU32& u32DpStocksFavoriteListSize) const
{
    dp_tclFcSxmDPStocksFavoriteListSize dpStocksFavoriteListElemSize;
    dpStocksFavoriteListElemSize.s32GetData(u32DpStocksFavoriteListSize);

}

tVoid fc_sxm_tclPersData::vSetDPStocksFavoriteListSize(tU32 u32DpStocksFavoriteListSize) const
{
    dp_tclFcSxmDPStocksFavoriteListSize dpStocksFavoriteListElemSize;
    dpStocksFavoriteListElemSize.s32SetData(u32DpStocksFavoriteListSize);

}

//DB Version Implementation
tU32 fc_sxm_tclPersData::u32GetSmsCfgVersion() const
{
    tU32 u32DpSmsCfgVersion = 0xFFFF;
    dp_tclFcSxmDPSmsCfgVersion dpSmsCfgVersion;
    dpSmsCfgVersion.s32GetData(u32DpSmsCfgVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u32GetSmsCfgVersion() : %d", u32DpSmsCfgVersion));
    return u32DpSmsCfgVersion;
}
tU32 fc_sxm_tclPersData::u32GetFuelVersion() const
{
    tU32 u32DpFuelVersion = 0xFFFF;
    dp_tclFcSxmDPFuelVersion dpFuelVersion;
    dpFuelVersion.s32GetData(u32DpFuelVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetFuelVersion() : %d", u32DpFuelVersion));
    return u32DpFuelVersion;
}
tU32 fc_sxm_tclPersData::u32GetCanadianFuelVersion() const
{
    tU32 u32DpCanadianFuelVersion = 0xFFFF;
    dp_tclFcSxmDPCanadianFuelVersion dpCanadianFuelVersion;
    dpCanadianFuelVersion.s32GetData(u32DpCanadianFuelVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetCanadianFuelVersion() : %d", u32DpCanadianFuelVersion));
    return u32DpCanadianFuelVersion;
}

tU32 fc_sxm_tclPersData::u32GetTrafficVersion() const
{
    tU32 u32DpTrafficVersion = 0xFFFF;
    dp_tclFcSxmDPTrafficVersion dpTrafficVersion;
    dpTrafficVersion.s32GetData(u32DpTrafficVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetTrafficVersion() : %d", u32DpTrafficVersion));
    return u32DpTrafficVersion;
}

tU32 fc_sxm_tclPersData::u32GetMoviesVersion() const
{
    tU32 u32DpMoviesVersion = 0xFFFF;
    dp_tclFcSxmDPMoviesVersion dpMoviesVersion;
    dpMoviesVersion.s32GetData(u32DpMoviesVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetMoviesVersion() : %d", u32DpMoviesVersion));
    return u32DpMoviesVersion;
}

tU32 fc_sxm_tclPersData::u32GetAgwVersion() const
{
    tU32 u32DpAgwVersion = 0xFFFF;
    dp_tclFcSxmDPAgwVersion dpAgwVersion;
    dpAgwVersion.s32GetData(u32DpAgwVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetAgwVersion() : %d", u32DpAgwVersion));
    return u32DpAgwVersion;
}

tU32 fc_sxm_tclPersData::u32GetTabWeatherVersion() const
{
    tU32 u32DpTabWeatherVersion = 0xFFFF;
    dp_tclFcSxmDPTabWeatherVersion dpTabWeatherVersion;
    dpTabWeatherVersion.s32GetData(u32DpTabWeatherVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetTabWeatherVersion() : %d", u32DpTabWeatherVersion));
    return u32DpTabWeatherVersion;
}

tU32 fc_sxm_tclPersData::u32GetStocksVersion() const
{
    tU32 u32DpStocksVersion = 0xFFFF;
    dp_tclFcSxmDPStocksVersion dpStocksVersion;
    dpStocksVersion.s32GetData(u32DpStocksVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetStocksVersion() : %d", u32DpStocksVersion));
    return u32DpStocksVersion;
}

tU32 fc_sxm_tclPersData::u32GetSportsVersion() const
{
    tU32 u32DpSportsVersion = 0xFFFF;
    dp_tclFcSxmDPSportsVersion dpSportsVersion;
    dpSportsVersion.s32GetData(u32DpSportsVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetSportsVersion() : %d", u32DpSportsVersion));
    return u32DpSportsVersion;
}

tU32 fc_sxm_tclPersData::u32GetWsAlertsVersion() const
{
    tU32 u32DpWsAlertsVersion = 0xFFFF;
    dp_tclFcSxmDPWsAlertsVersion dpWsAlertsVersion;
    dpWsAlertsVersion.s32GetData(u32DpWsAlertsVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetWsAlertsVersion() : %d", u32DpWsAlertsVersion));
    return u32DpWsAlertsVersion;
}

tU32 fc_sxm_tclPersData::u32GetParkingVersion() const
{
    tU32 u32DpParkingVersion = 0xFFFF;
    dp_tclFcSxmDPParkingVersion dpParkingVersion;
    dpParkingVersion.s32GetData(u32DpParkingVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetParkingVersion() : %d", u32DpParkingVersion));
    return u32DpParkingVersion;
}
tU32 fc_sxm_tclPersData::u32GetPhoneticsVersion() const
{
    tU32 u32DpPhoneticsVersion = 0xFFFF;
    dp_tclFcSxmDPPhoneticsVersion dpPhoneticsVersion;
    dpPhoneticsVersion.s32GetData(u32DpPhoneticsVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetPhoneticsVersion() : %d", u32DpPhoneticsVersion));
    return u32DpPhoneticsVersion;
}

tU32 fc_sxm_tclPersData::u32GetStatesVersion() const
{
    tU32 u32DpStatesVersion = 0xFFFF;
    dp_tclFcSxmDPStatesVersion dpStatesVersion;
    dpStatesVersion.s32GetData(u32DpStatesVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetPhoneticsVersion() : %d", u32DpStatesVersion));
    return u32DpStatesVersion;
}

tU32 fc_sxm_tclPersData::u32GetChannelArtVersion() const
{
    tU32 u32DpChannelArtVersion = 0xFFFF;
    dp_tclFcSxmDPChannelArtVersion dpChannelArtVersion;
    dpChannelArtVersion.s32GetData(u32DpChannelArtVersion);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::u8GetChannelArtVersion() : %d", u32DpChannelArtVersion));
    return u32DpChannelArtVersion;
}


tVoid fc_sxm_tclPersData::vSetSmsCfgVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPSmsCfgVersion dpSmsCfgVersion;
    dpSmsCfgVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetFuelVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPFuelVersion dpFuelVersion;
    dpFuelVersion.s32SetData(u32DpAppDbVersion);
}

tVoid fc_sxm_tclPersData::vSetCanadianFuelVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPCanadianFuelVersion dpCanadianFuelVersion;
    dpCanadianFuelVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetTrafficVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPTrafficVersion dpTrafficVersion;
    dpTrafficVersion.s32SetData(u32DpAppDbVersion);
}

tVoid fc_sxm_tclPersData::vSetMoviesVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPMoviesVersion dpMoviesVersion;
    dpMoviesVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetAgwVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPAgwVersion dpAgwVersion;
    dpAgwVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetTabWeatherVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPTabWeatherVersion dpTabWeatherVersion;
    dpTabWeatherVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetStocksVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPStocksVersion dpStocksVersion;
    dpStocksVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetSportsVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPSportsVersion dpSportsVersion;
    dpSportsVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetWsAlertsVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPWsAlertsVersion dpWsAlertsVersion;
    dpWsAlertsVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetParkingVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPParkingVersion dpParkingVersion;
    dpParkingVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetPhoneticsVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPPhoneticsVersion dpPhoneticsVersion;
    dpPhoneticsVersion.s32SetData(u32DpAppDbVersion);
}
tVoid fc_sxm_tclPersData::vSetStatesVersion(tU32 u32DpAppStatesVersion)
{
    dp_tclFcSxmDPStatesVersion dpStatesVersion;
    dpStatesVersion.s32SetData(u32DpAppStatesVersion);
}
tVoid fc_sxm_tclPersData::vSetChannelArtVersion(tU32 u32DpAppDbVersion)
{
    dp_tclFcSxmDPChannelArtVersion dpChannelArtVersion;
    dpChannelArtVersion.s32SetData(u32DpAppDbVersion);
}

//Profile Manager
tVoid fc_sxm_tclPersData::vGetPresetData(SERVICE_ID *u16DpArrSIDs)
{
    dp_tclFcSxmDPUserDpEndUserData dpEndUserData;
    if(u16DpArrSIDs)
    {
        dpEndUserData.s32GetData(u16DpArrSIDs, _u8NumberOfPresets);
    }
}

tVoid fc_sxm_tclPersData::vSetPresetData(SERVICE_ID *u16DpArrSIDs)
{
    dp_tclFcSxmDPUserDpEndUserData dpEndUserData;
    if(u16DpArrSIDs)
    {
        dpEndUserData.s32SetData(u16DpArrSIDs, _u8NumberOfPresets);
    }
}

tVoid fc_sxm_tclPersData::vGetDPProfileId(tU8& u8ProfileId)
{
    dp_tclFcSxmDPDpEndUserCurrent dpCurrentEndUser;
    dpCurrentEndUser.s32GetData(u8ProfileId);
}
tVoid fc_sxm_tclPersData::vSetDPProfileId(tU8 u8ProfileId)
{
    dp_tclFcSxmDPDpEndUserCurrent dpCurrentEndUser;
    dpCurrentEndUser.s32SetData(u8ProfileId);
}

tBool fc_sxm_tclPersData::bGetDPPresetType() const
{
    tBool presetType = false;
    dp_tclFcSxmDPPresetType dpPresetType;
    dpPresetType.s32GetData(presetType);
    ETG_TRACE_USR4(("fc_sxm_tclPersData::bGetDPPresetType() : %d", presetType));

    return presetType;
}

tVoid fc_sxm_tclPersData::vSetDPPresetType(tBool presetType)
{
    ETG_TRACE_USR4(("fc_sxm_tclPersData::vSetDPPresetType() : %d", presetType));
    dp_tclFcSxmDPPresetType dpPresetType;
    dpPresetType.s32SetData(presetType);
}

