/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_pers_app_data.h
* @brief       
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_TCL_PERS_APP_DATA_H
#define FC_SXM_TCL_PERS_APP_DATA_H

#include "fc_sxm_tcl_singleton.h"

/* Forward declaration of trUserConfig struct */
struct trUserConfig;
/* *************************** App List *************************** */

struct tSXMDataService_ProtectedMoviesFavoriteList {
	vector<tU32> vMoviesFavoriteList;  /* App list             */
};

struct tSXMDataService_ProtectedFuelFavoriteList {
    vector<tU32> vFuelFavoriteList;  /* Fuel list             */
};

struct tSXMDataService_ProtectedCanFuelFavoriteList {
    vector<tU32> vCanFuelFavoriteList;  /* Canadian Fuel list             */
};

struct tSXMDataService_ProtectedStocksFavoriteList {
    vector<string> vStocksFavoriteList;  /* Stocks list             */
};

/* ****************************************************************** */

/* App user data class */
class trAppUserData
	: public fc_sxm_tclSingleton<trAppUserData>
{
	public:
		/* Class destructor */
		~trAppUserData();

		/* **************************** Sport list access functions **************************** */
		tVoid vClearInternalFavoriteList(tVoid);
		/* Show sport list data */
		tVoid vPrintAppList(tVoid);
		/* Clear movies list */
		tVoid vClearMoviesFavoriteList(tVoid);
        /* Clear fuel list */
        tVoid vClearFuelFavoriteList(tVoid);
        /* Clear Canadaian fuel list */
        tVoid vClearCanFuelFavoriteList(tVoid);
        /* Clear stocks list */
        tVoid vClearStocksFavoriteList(tVoid);
		/* Update or add new element into App list */
		tVoid vSetFavoriteList(fc_sxm_tenServiceID u32ServiceID, const vector<tU32>& vecLocId);
		tVoid vSetFavoriteList(const vector<string>& vecStringId);
		/* Get App list element for the given index */
		tVoid vGetFavoriteList(fc_sxm_tenServiceID u32ServiceID, vector<tU32>& vecLocID);
		tVoid vGetFavoriteList(vector<string>& vecStringId);

        /* Get data */
        tVoid vGetData(tVoid);

        /* Set data */
        tVoid vSetData(tVoid);

	private:
		/* Class constructor */
        trAppUserData();
		/* Clear all list data */
	//	tVoid vClearListData();

		/* Declaring singleton class as friend of sports user data class */
		friend class fc_sxm_tclSingleton<trAppUserData>;
		/* Declare struct trUserConfig as friend of sports user data class */
		friend struct trUserConfig;


	protected:
		/* **************************** App list *********************************** */
        fc_sxm_tclProtectedData<tSXMDataService_ProtectedMoviesFavoriteList> _mProtectedMoviesFavoriteList;

        fc_sxm_tclProtectedData<tSXMDataService_ProtectedFuelFavoriteList> _mProtectedFuelFavoriteList;

        fc_sxm_tclProtectedData<tSXMDataService_ProtectedCanFuelFavoriteList> _mProtectedCanFuelFavoriteList;

        fc_sxm_tclProtectedData<tSXMDataService_ProtectedStocksFavoriteList> _mProtectedStocksFavoriteList;


		/* Get data from persistence memory and store it in movies list               */
		tVoid vGetMoviesFavoriteListData(tVoid);
        /* Get data from persistence memory and store it in fuel list               */
        tVoid vGetFuelFavoriteListData(tVoid);
        /* Get data from persistence memory and store it in canadian fuel list               */
        tVoid vGetCanFuelFavoriteListData(tVoid);
        /* Get data from persistence memory and store it in stocks list               */
        tVoid vGetStocksFavoriteListData(tVoid);
		/* Set movies list data into binary data to persist across power cycle    */
		tVoid vSetMoviesFavoriteListData(tVoid);
        /* Set fuel list data into binary data to persist across power cycle    */
        tVoid vSetFuelFavoriteListData(tVoid);
        /* Set canadian fuel list data into binary data to persist across power cycle    */
        tVoid vSetCanFuelFavoriteListData(tVoid);
        /* Set stocks list data into binary data to persist across power cycle    */
        tVoid vSetStocksFavoriteListData(tVoid);
};

#endif
