/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_data_lists.cpp
* @brief       Implementation of data lists handling
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*
  implementation of base-class for all data-apps
*/
#include "fc_sxm_common.h"
#include "fc_sxm_tcl_data_list.hpp"
#include "fc_sxm_tcl_data_lists.h"

// just take any data-fi
#include "fc_sxm_fuel_fi.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_BASE_APP
#include "trcGenProj/Header/fc_sxm_tcl_data_lists.cpp.trc.h"
#endif

// DataLists
tVoid fc_sxm_tclDataLists::vAdd(fc_sxm_tclDataListBase *poDataList, fc_sxm_listStatusInfo const &rListInfo) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:vAdd=%08x", poDataList));
    // todo: check if already exists
    if (OSAL_NULL != poDataList) {
        _u16TraceClass=poDataList->u16GetTraceClass();
        mapLists[poDataList]=rListInfo;
    }
}

tVoid fc_sxm_tclDataLists::vRemove(fc_sxm_tclDataListBase *poDataList) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:vRemove=%08x", poDataList));
    // todo: check if already exists
    SXM_IF_FIND_MAP(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists, poDataList) {
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:vRemove=%08x FOUND", poDataList));
        mapLists.erase(iter);
    };
}

fc_sxm_tclDataListBase *fc_sxm_tclDataLists::poGetById(tU32 u32Id) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetById=%d", u32Id));
    
    SXM_FOREACH_MAP(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists) {
        if (iter->first->u32GetId()==u32Id) {
            return iter->first;
        }
    }
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetById NOT FOUND"));
    
    return OSAL_NULL;
}

fc_sxm_tclDataListBase *fc_sxm_tclDataLists::poGetListByDsrl(fc_sxm_tclBaseDSRL const *poBaseDsrl) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetListByDsrl=%08x", poBaseDsrl));
    SXM_FOREACH_MAP(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists) {
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetListByDsrl checking %08x", iter->first->poGetDsrl()));
        if (iter->first->poGetDsrl()==poBaseDsrl) {
            ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetListByDsrl=%08x FOUND", poBaseDsrl));
            return iter->first;
        }
    }
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:poGetListByDsrl=%08x NOT FOUND", poBaseDsrl));
    return OSAL_NULL;
}

tBool fc_sxm_tclDataLists::bUpdate(fc_sxm_tclDataListBase *poList) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:bUpdate %10s poList=0x%08x START", 
                        poList->szGetAppName(), poList));
    
    SXM_IF_FIND_MAP(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists, poList) {
        fc_sxm_listStatusInfo &rOldInfo=iter->second;
            ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:bUpdate OLD: %10s u32Id=%d enListType=%d enListState:%d bActivated=%d",
                                poList->szGetAppName(),
                                rOldInfo.u32Id,
                                ETG_CENUM(fc_sxm_tenListType,  rOldInfo.enListType),
                                ETG_CENUM(fc_sxm_tenListState,  rOldInfo.enListState),
                                rOldInfo.bActivated
                                ));

        fc_sxm_listStatusInfo rNewInfo=poList->rGetStatusInfo();

        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:bUpdate NEW poList=0x%08x %10s su32Id=%d enListType=%d enListState:%d-->%d bActivated=%d",
                            poList,
                            poList->szGetAppName(),
                            rNewInfo.u32Id,
                            ETG_CENUM(fc_sxm_tenListType,  rNewInfo.enListType),
                            ETG_CENUM(fc_sxm_tenListState,  rOldInfo.enListState),
                            ETG_CENUM(fc_sxm_tenListState,  rNewInfo.enListState),
                            rNewInfo.bActivated
                            ));
         iter->second=rNewInfo;

         return TRUE;
    }
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists:bUpdate UNCHANGED"));
    return FALSE;
};


tVoid fc_sxm_tclDataLists::vCopyListInfosToFi(midw_ext_fi_tcl_SxmListInfos &rFiOut) const  {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataListBase:vCopyListInfosToFi"));
    midw_ext_fi_tcl_SxmListInfos &rFiRes=rFiOut;
    // leave generic config as it is
    rFiRes.GenericConfig=rFiOut.GenericConfig;
    // clear the fi-list
    rFiOut.ListInfo.clear();
    // add elements to fi-list according to mapLists 
    SXM_FOREACH_MAP_CONST(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists) {
        fc_sxm_listStatusInfo const &rInfo=iter->second;
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataLists::vCopyListInfosToFi: poList=0x%08x u32Id=%d listSize=%d enListType=%d enListState:%d bActivated=%d bFrozen=%d",
                            iter->first,
                            rInfo.u32Id,
                            rInfo.u32Size,
                            ETG_CENUM(fc_sxm_tenListType,  rInfo.enListType),
                            ETG_CENUM(fc_sxm_tenListState,  rInfo.enListState),
                            rInfo.bActivated,
                            rInfo.bFrozen
                            ));
        rFiRes.ListInfo.push_back(iter->second);
    }
}

tVoid fc_sxm_tclDataLists::vPrintReport() const  {
    SXM_FOREACH_MAP_CONST(fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo, iter, mapLists) {
        iter->first->vPrintReport();
    }
}

