/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_base_service.cpp
* @brief       Provides implementation to send method result and error over CCA
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_main.h"
#include "fc_sxm_tcl_base_service.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_BASE_APP
#include "trcGenProj/Header/fc_sxm_tcl_base_service.cpp.trc.h"
#endif

/* Constructor: call constructor of base-class with given parameters */
fc_sxm_tclBaseService::fc_sxm_tclBaseService(tU16 u16ServiceId,
                                             tU16 u16FiMajorVersion,
                                             tU16 u16FiMinorVersion,
                                             tU16 u16FiPatchVersion): 
    ahl_tclBaseOneThreadService(fc_sxm_tclApp::instance(),
                                /* ID of offered Service            */ u16ServiceId,
                                /* MajorVersion of offered Service  */ u16FiMajorVersion,
                                /* MinoreVersion of offered Service */ u16FiMinorVersion,
                                /* PatchVersion of offered Service  */ u16FiPatchVersion),
    _u16FiMajorVersion(u16FiMajorVersion)
{
    ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(FALSE);
};

/* send fi-answer "roSendFiObj" according to "rAdressing" 
   rAdressing is expected to be copied from the clients request.
*/
ail_tenCommunicationError fc_sxm_tclBaseService::enSendFiMessage( fc_sxm_trAdressing const &rAdressing, const fi_tclMessageBase& roSendFiObj )
{ 
    if (!rAdressing.bIsValid()) {
        ETG_TRACE_ERR(("fc_sxm_tclBaseService::enSendFiMessage: invalid adressing"));
        return AIL_EN_N_INVALID_PARAMETER;
    }
   fi_tclVisitorMessage oOutVisitorMsg(roSendFiObj.corfoGetTypeBase(), _u16FiMajorVersion);
   /* Set the CCA message information */
   oOutVisitorMsg.vInitServiceData
        (
         fc_sxm_u16GetAppId(),                  /* Source app-ID   */
         rAdressing.u16AppId,     /* Dest. app-ID    */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type     */ 
         0,                    /* stream counter  */
         rAdressing.u16RegId,                  /* Register ID     */
         rAdressing.u16CmdCounter,                  /* Command counter */
         roSendFiObj.u16GetServiceID(),                  /* Service-ID      */
         roSendFiObj.u16GetFunctionID(),                  /* Function-ID     */
         roSendFiObj.u8GetOpCode() ,             /* Opcode          */
         rAdressing.u8ACT,                    /* ACT             */
         rAdressing.u16SourceSub,                    /* Source sub-ID   */
         rAdressing.u16TargetSub                     /* Dest. sub-ID    */
         );


   // send the message
   return fc_sxm_tclApp::instance()->enPostMsg(&oOutVisitorMsg);
}

tVoid fc_sxm_tclBaseService::vSendError(fc_sxm_trAdressing const &rAdressing, tU16 u16ErrorCode) {
    ETG_TRACE_USR1(("fc_sxm_tclBaseService::vSendError srvId=%d fnId=%d errCode=%d to appId=%d",
                    rAdressing.u16ServiceId,
                    rAdressing.u16FunctionId,
                    u16ErrorCode,
                    rAdressing.u16AppId)); 

    gm_tclU16Message oOutMessage = gm_tclU16Message(
                                                    fc_sxm_u16GetAppId(),//AppID of this application
                                                    rAdressing.u16AppId,//app id of the target component
                                                    rAdressing.u16RegId,//RegId assigned to the client 
                                                    rAdressing.u16CmdCounter,//command counter(count of the request)
                                                    rAdressing.u16ServiceId,//the id of this service (SID)
                                                    rAdressing.u16FunctionId,// function id 
                                                    AMT_C_U8_CCAMSG_OPCODE_ERROR
                                                    );
    oOutMessage.vSetTargetSubID(rAdressing.u16SourceSub);
    //fill data of the message
    oOutMessage.vSetWord(u16ErrorCode); 
    //send message to the client
    if(TRUE == oOutMessage.bIsValid())
    {
        fc_sxm_tclApp::instance()->enPostMsg(&oOutMessage);
    }
}


tVoid fc_sxm_tclBaseService::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage) {
    (tVoid)u16ServiceID;
    vMyDispatchMessage(poMessage);
}

/*
  wrapper for clients, because vSetPrivateServiceAvailableAllowed is not public
*/
tVoid fc_sxm_tclBaseService::bAllowService(tBool bAllow) {
    vSetPrivateServiceAvailableAllowed(bAllow);
}
