/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_base_client.cpp
* @brief       Base client implementation
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_main.h"
#include "fc_sxm_tcl_base_client.h"
#include "fc_sxm_trace_macros.h"

fc_sxm_tclBaseClient::fc_sxm_tclBaseClient(tU16 u16ServiceId,
                                           tU16 u16FiMajorVersion,
                                           tU16 u16FiMinorVersion,
                                           tU16 u16SrvAppId):
        ahl_tclBaseOneThreadClientHandler(fc_sxm_tclApp::instance(),
                                          u16ServiceId,
                                          u16FiMajorVersion,
                                          u16FiMinorVersion,
                                          u16SrvAppId)
    {};


ail_tenCommunicationError fc_sxm_tclBaseClient::enSendFiMessage( const fi_tclMessageBase& roSendFiObj ) const
{ 
   fi_tclVisitorMessage oOutVisitorMsg( roSendFiObj.corfoGetTypeBase() );
   /* Set the CCA message information */

   oOutVisitorMsg.vInitServiceData
        (
         fc_sxm_u16GetAppId(),                  /* Source app-ID   */
         u16GetServerAppID(),     /* Dest. app-ID    */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type     */ 
         0,                    /* stream counter  */
         u16GetRegID(),                  /* Register ID     */
         0,                  /* Command counter */
         roSendFiObj.u16GetServiceID(),                  /* Service-ID      */
         roSendFiObj.u16GetFunctionID(),                  /* Function-ID     */
         roSendFiObj.u8GetOpCode() ,             /* Opcode          */
         0,                    /* ACT             */
         0,                    /* Source sub-ID   */
         0                     /* Dest. sub-ID    */
         );



   return fc_sxm_tclApp::instance()->enPostMsg(&oOutVisitorMsg);
}

tVoid fc_sxm_tclBaseClient::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage) {
    (tVoid)u16ServiceID;
    vMyDispatchMessage(poMessage);
}
