/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_sms_util.h
* @brief       Declaration of utility functions
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_SMS_UTIL_H_
#define _FC_SXM_SMS_UTIL_H_

#include "fc_sxm_common.h"
#include "fc_sxm_sms.h"


// just take any data-fi
#include "fc_sxm_fuel_fi.h"

tVoid fc_sxm_vCopySmsString2Fi(STRING_OBJECT hSmsStringObj, midw_ext_fi_tclString &rFiString);
tVoid fc_sxm_vCopySmsString2Stl(STRING_OBJECT hSmsStringObj, string &rStlString);
tVoid fc_sxm_vCopySmsString2CStr(STRING_OBJECT hSmsStringObj, tPS8 ps8DstPath,tU32 u32MaxLen);
float fc_sxm_fFixed2Float(OSAL_FIXED_OBJECT hFixed);

float fc_sxm_fKm2Miles(float fMiles);

tVoid fc_sxm_vToLower(string &oName);
tVoid fc_sxm_vString2Fi(tCString sSrcString,  midw_ext_fi_tclString& rffiObj);

tS32 fc_sxm_vConvertSmsString2Int_base16(STRING_OBJECT hSmsStringObj);
tDouble fc_sxm_vConvertSmsString2Double(STRING_OBJECT hSmsStringObj);
tS32 fc_sxm_vConvertSmsString2int(STRING_OBJECT hSmsStringObj);
tVoid fc_sxm_vCopyInt2FiString(tU32 u32Int, midw_ext_fi_tclString &rFiString,const tU32 u32MaxLen);

midw_ext_fi_tcl_e8_SxmDataServiceStatus fc_sxm_oSmsDataServiceState2Fi(DATASERVICE_STATE_ENUM enState);
char const *fc_sxm_szSmsDataServiceStateFiToString(midw_ext_fi_tcl_e8_SxmDataServiceStatus enFiState);

tVoid vConvertTTFisString2FIString( tCString chInString, midw_ext_fi_tclString& rffiObj);
tVoid vReplaceChars(string& sInput, tChar chFind, tChar chReplace);

tBool fc_sxm_pValidateString(const char* lStringToCheck);
tBool fc_sxm_bFileExists(string const &oName);



#endif
