/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_generic_utils.h
* @brief       Declration of Generic utility class
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_GENERIC_UTILS_H_
#define FC_SXM_GENERIC_UTILS_H_

#include "fc_sxm_types.h"
#include "fc_sxm_audio_types.h"

class fc_sxm_tclGenericUtils {
public:
	static tVoid fc_sxm_vString2Fi(tCString sSrcString,  midw_ext_fi_tclString& rffiObj);
	static tVoid vConvertTTFisString2FIString( tCString chInString, midw_ext_fi_tclString& rffiObj);
	static tVoid vReplaceChars(string& sInput, tChar chFind, tChar chReplace);
	static tU32 u32ComputeHashCode(const string& strInput);

	static tVoid vClearBit(tU32& u32Value, const tU32 u32BitPosition);
	static tVoid vSetBit(tU32& u32Value, const tU32 u32BitPosition);
	static tVoid vToggleBit(tU32& u32Value, const tU32 u32BitPosition);
	static tBool bCheckBit(const tU32 u32Value, const tU32 u32BitPosition);
	
	static tS32 s32SmsDegreeFloatToNav(tFloat fFloatSmsCoordinate);
	static tF32 f32DegreeNavToFloat(tS32 s32NavCoordinate);
	static tS32 s32DegreeSmsToNav(tS32 s32SmsCoordinate);

	//helper functions to Convert from lower case to type to Upper case character
   static tVoid toUpper(tU32& rfu32Val);
   static tU32 vGetUnicode(tU8* copU8Char, tU32 & rfu32Unicode);
   static tVoid vUnicodeToString(tU32 u32Unicode, std::string& outputString);
   static tCString strUnicode2UTF8(tU32 u32Unicode, tChar* utf8Char);
};



#endif /* FC_SXM_GENERIC_UTILS_H_ */
