/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_service_sxm_movies.cpp
* @brief       Implementation of CCA service for sxm_movies.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_movies_app.h"

#include "fc_sxm_service_sxm_movies.h"





#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_SERVICE_SXM_MOVIES
#include "trcGenProj/Header/fc_sxm_service_sxm_movies.cpp.trc.h"
#endif



/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_SXM_SERVICE_SXM_MOVIES_FI_MAJOR_VERSION  1
#define FC_SXM_SERVICE_SXM_MOVIES_FI_MINOR_VERSION  1
#define FC_SXM_SERVICE_SXM_MOVIES_FI_PATCH_VERSION  7

/*
  constructor: call contructor of base-class fc_sxm_tclBaseService
*/
fc_sxm_tclMoviesService::
  fc_sxm_tclMoviesService()
    :fc_sxm_tclBaseService(
      /* ID of offered Service            */ CCA_C_U16_SRV_SXM_MOVIES,
      /* MajorVersion of offered Service  */ FC_SXM_SERVICE_SXM_MOVIES_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_SXM_SERVICE_SXM_MOVIES_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */ FC_SXM_SERVICE_SXM_MOVIES_FI_PATCH_VERSION)
{
   ETG_TRACE_USR4(("fc_sxm_tclMoviesService() entered."));
}

/*
  Destructor
*/
fc_sxm_tclMoviesService::~fc_sxm_tclMoviesService(tVoid)
{
   ETG_TRACE_USR4(("~fc_sxm_tclMoviesService() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclMoviesService::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_sxm_tclMoviesService::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclMoviesService::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_sxm_tclMoviesService::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclMoviesService
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object and to copy it to the
*              referenced service data object 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = For the requested property the FI data object was
*                     successfully created and copied to the referenced service
*                     data object 'roOutMsg'. The CCA framework sends a 'STATUS'
*                     message of the updated property to each registered
*                     clients.
*              FALSE = Failed to create the FI data object for the requested
*                      property and to update the referenced service data object
*                      'roOutMsg' with the new property content. The CCA
*                      framework sends an error message to the requesting
*                      client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_sxm_tclMoviesService
      ::bStatusMessageFactory(tU16 u16FunctionId,
                              amt_tclServiceData& roOutMsg,
                              amt_tclServiceData* poInMsg)
{
   (tVoid) poInMsg;  // These lines are added to avoid LINT warnings. Please
   (tVoid) roOutMsg; // remove as soon as the variables are used.

   tBool bResult = FALSE;

   ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.", 
               u16FunctionId));

   switch(u16FunctionId)
   {
   /*
     handle request for fi-status-messages.
     For each funtion-id use macro "SXM_PGET_ENTRY" to read the corresponding property 
     and write it to  "roOutMsg"
   */
      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_MOVIESFI_C_U16_THEATRELISTSSTATUS, // the cca-function-id
                  midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus, //the fi-type of the response (status)
                  fc_sxm_tclMoviesProperties::instance()->oListsStatus)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_MOVIESFI_C_U16_SXMDATASERVICESTATUS, // the cca-function-id
                        midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus, //the fi-type of the response (status)
                        fc_sxm_tclMoviesProperties::instance()->oSxmServiceStatus)  // the property holding the needed values
      
	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_MOVIESFI_C_U16_SXMLISTMODE,// the cca-function-id
						midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus,//the fi-type of the response (status)
						fc_sxm_tclMoviesProperties::instance()->oSxmListMode)// the property holding the needed values

   // Handle creation of the FI data object for this function ID and the
   // handover to the referenced service data object 'roOutMsg' here ...

   // Set local variable 'bResult' to TRUE if the creation of the FI data 
   // object and the handover to 'roOutMsg' was successfull.

   //peha: for each property use MACRO SXM_PGET_ENTRY
      default:
         break;
   }

   if (FALSE == bResult)
   {
   ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.",
                u16FunctionId));

   //    NORMAL_M_ASSERT_ALWAYS();
   }

   return bResult;
}

/*
  handle method-start message poMessage for function-id u16FunctionId
*/
tVoid fc_sxm_tclMoviesService::vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage) {

   ETG_TRACE_USR4(("fc_sxm_tclMoviesService::vOnMethodStart entered."));


   switch (u16FunctionId) {
      /*
       use macro SXM_MSTART_ENTRY for each suported function-id:
       fill according thread-message for fiObject and adressing 
       according to "poMessage" and send message accoring to u32Action of thread-message
      */
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_SETLISTSCONFIG, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMStartSetListsConfig );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_GETTHEATRELIST, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMStartGetTheatreList );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_GETTHEATREINFO, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMStartGetTheaterInfo );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_GETMOVIESLIST, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMStartGetMoviesList );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_GETMOVIEINFO, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMStartGetMovieInfo );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_ADDFAVORITE, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMAddFavorite );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_REMOVEFAVORITE, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMRemoveFavorite );  // the message that shall be sent to app
      SXM_MSTART_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_SEARCHMOVIE, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart, // the corresponding fi-type
                fc_sxm_trMsgMoviesMSearchMovie );  // the message that shall be sent to app

      default:
         vOnUnknownMessage(poMessage);
      break;   

   }
}


/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclMoviesService
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has 
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Property successfully set to the passed value. The CCA
*                     framework sends a 'STATUS' message to the requesting
*                     client if the opcode was 'SET'. Othwerwise if opcode
*                     was 'PURESET' there is no 'STATUS' message sent to the
*                     requesting client. The CCA framework will send a 'STATUS'
*                     message to other registered clients as well if the [OUT]
*                     parameter 'bPropertyChanged' is set to TRUE.
*             FALSE = Failed to set the property to the passed value. The CCA
*                     framework sends an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
/*
  not used, please try to avoid opcode "Set"
*/
tBool fc_sxm_tclMoviesService
      ::bProcessSet(amt_tclServiceData* poMessage,
                    tBool& bPropertyChanged,
                    tU16& u16ErrorCode)
{
   (tVoid) bPropertyChanged; // This line is added to avoid LINT warnings.
                         // Please remove as soon as the variable is used.

   tBool bResult = FALSE;  // This line is removed to avoid LINT warnings.

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

   switch(u16FunctionId)
   {

      SXM_PSET_ENTRY(MIDW_EXT_SXM_MOVIESFI_C_U16_SXMLISTMODE, // the cca function-id
                midw_ext_sxm_moviesfi_tclMsgSxmListModeSet, // the corresponding fi-type
                fc_sxm_trPropertyMoviesPSetListMode );  // the message that shall be sent to app
   default:
       break;
   }

   if (FALSE == bResult)
   {
      u16ErrorCode = CCA_C_U16_ERROR_UNKNOWN_FCT_ID;

      ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.",
                   u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bResult;
}



/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclMoviesService::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the vOnTimer() function of this
*              CCA application on the expiration of a previously via function
*              bStartTimer() started timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
*******************************************************************************/
/*
  not used: timers should only be used in worker-context
*/
tVoid fc_sxm_tclMoviesService::vProcessTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

   gm_tclU32Message oExampleMsg(_poMainAppl->u16GetAppId(),  // Source AppID 
                               _poMainAppl->u16GetAppId(),  // Target AppID 
                               0,                           // RegisterID   
                               0,                           // CmdCounter  
                               _u16ServiceID,               // ServiceID   
                               SXM_MOVIES_C_U16_IFID_EXAMPLE_1,  // Function ID
                               AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                              );

   oExampleMsg.vSetDWord(SXM_MOVIES_C_U32_MSGID_EXAMPLE_1);  

   if ( oExampleMsg.bIsValid() )
   {
      if (_poMainAppl->enPostMessage(&oExampleMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {  
         NORMAL_M_ASSERT_ALWAYS();
      }
   }
   else
   {  
      NORMAL_M_ASSERT_ALWAYS();
   }
}


