/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_main.h
* @brief       CCA Application.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_MAIN_H_
#define _FC_SXM_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../common/fc_sxm_types.h"
#include "../common/fc_sxm_tcl_base_service.h"
#include "../common/fc_sxm_tcl_base_client.h"

#include "../common/fc_sxm_tcl_ahl_object_list.h"
#ifdef SMS_64_BIT_SUPPORT
#include <map>
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class fc_sxm_arl_tclISource;
class fc_sxm_tclAppManager;



// Messages from apps
struct fc_sxm_trMsgCmdMainAllowService: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Main, 1);
    tBool bAllow;
    tU16 u16CcaServiceId;
};

// Messages from apps
struct fc_sxm_trMsgCmdTtfisCmd: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Main, 2);
    fc_sxm_tenServiceID enServiceId;
    tU8 u8MsgCode;
    tU8 u8DataLen;
    tU8 au8Data[0xFF];
};

struct fc_sxm_trMsgCcaThreadMsg: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Main, 3);
    fc_sxm_tclMsgCallerBase *poCaller;
};

struct fc_sxm_trMsgOffReached: public fc_sxm_tclMessage {
   //constructor
    fc_sxm_trMsgOffReached(){} ;
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Main, 4);
};


typedef enum  {
    fc_sxm_enOffWaitAckState_Idle,
    fc_sxm_enOffWaitAckState_BlockNext,
    fc_sxm_enOffWaitAckState_WaitApp
} fc_sxm_tenOffWaitAckState;

#ifndef FC_SXM_DISABLE_SMS
#define FC_SXM_VARIANT_TYPE_NOT_CONFIGURED 0x00
#define FC_SXM_VARIANT_TYPE_NAVI 0x01
#define FC_SXM_VARIANT_TYPE_DA 0x02
#endif

class fc_sxm_tclApp : 
public ahl_tclBaseOneThreadApp,
    public fc_sxm_tclSingleton<fc_sxm_tclApp>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclApp>;
    friend class fc_sxm_tclAppManager;

 private:
    fc_sxm_tclApp(tVoid);
  public:


    virtual ~fc_sxm_tclApp(tVoid);

    //!  FUNCTION: * theServer
    static fc_sxm_tclApp* theServer();

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
    * 'fc_sxm_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_sxm_tclApp& operator= (const fc_sxm_tclApp &ofc_sxm);

    /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
    * 'fc_sxm_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_sxm_tclApp(const fc_sxm_tclApp &ofc_sxm); 

    /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
    virtual tBool bOnInit();
    virtual tVoid vOnApplicationClose();
    virtual tVoid vOnTimer(tU16 nTimerId);
    virtual tVoid vOnLoadSettings();
    virtual tVoid vOnSaveSettings();
    virtual tVoid vOnNewAppStateNotify(tU32 /*u32OldAppState*/, tU32 /*u32AppState*/);

    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclBaseMessage* poMessage) {
    	(tVoid)u16ServiceID;
    	(tVoid)poMessage;
    };
    //    using ahl_tclBaseOneThreadApp::vOnLoopback;
    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

    virtual tVoid vAppStateChanged (tU32 u32AppState, OSAL_tMSecond tApproximatedChangeTime = 0);

#if(FC_SXM_ENABLE_LCM_WATCHDOG_TIMER)
    virtual tBool bOnWatchdog();
#endif

    //Trace Commnad Manager
    static tVoid vTraceCmdManager(const tUChar* puchData);

    fc_sxm_tclBaseService *poGetServiceHandler(tU16 u16ServiceId);
    fc_sxm_tclBaseClient *poGetClientHandler(tU16 u16ServiceId);

    tVoid vNotifyPropertyChanged(tU16 enServiceId, tU16 u16FunktionId);
    ail_tenCommunicationError enPostMsg(amt_tclServiceData* poMessage);

    tVoid vProcess(fc_sxm_trMsgOffReached const *prMsg);

#ifndef FC_SXM_DISABLE_SMS
    tU8 u8GetVariantType() const;
    tVoid vEnableDataService();
#endif
    
    /*
      Allocate Message of type "M" (action-id = rMsg.u32Action).
      Valid receipents are "fc_sxm_enServiceID_Main" and "fc_sxm_enServiceID_AppManager"
    */
    template<class M>
        tVoid vPostMsgNew(M const &rMsg) {
        if (fc_sxm_enGetServiceId(M::u32Action)!= fc_sxm_enServiceID_Main) {
            return;
        }
        M *pMsg=OSAL_NEW M(rMsg);
        vPostMsg(pMsg);
    }


#ifdef SMS_64_BIT_SUPPORT
    tVoid vPostMsg(fc_sxm_tclMessage *prMsg);
#else
    tVoid vPostMsg(fc_sxm_tclMessage *prMsg) const;
#endif

    tVoid vResetWDTCount()
    {
    	_u16WDTCount = 0;
    }

  private:
    tVoid vGetConfig();

    // interface only for app-manager
    tBool vStartTimer(tU16 u16TimerID, tU32 u32Ms) {
    	return((bStartTimer(u16TimerID, u32Ms, 0)));
    }
    tVoid vStopTimer(tU16 u16TimerID) {
        bStopTimer(u16TimerID); 
    }
    // app-manager end
    tVoid vDispatchMsg(fc_sxm_tclMessage *poThreadMsg);
    tVoid vProcess(fc_sxm_trMsgCmdMainAllowService const *prMsg);
    tVoid vProcess(fc_sxm_trMsgCcaThreadMsg const *prMsg) const;
    tBool bIsModuleMounted() const;
    tVoid vSendSourceAvailability();

    fc_sxm_tclAhlObjectList<fc_sxm_tclBaseService> _oServiceList;
    fc_sxm_tclAhlObjectList<fc_sxm_tclBaseClient> _oClientList;
    set<tVoid *>_oMemberList;

    fc_sxm_tenOffWaitAckState _enOffWaitAckState;
    tBool _bIsModuleMounted;

    tU16 _u16WDTCount;
#ifdef SMS_64_BIT_SUPPORT
    static tU32 u32MessageID;
    map<tU32, fc_sxm_tclMessage *> _mapLoopbackMessages;
#endif
}; 
tVoid fc_sxm_vNotifyPropertyChanged(tU16 enServiceId, tU16 u16FunktionId);
tU16 fc_sxm_u16GetAppId(void);
tVoid fc_sxm_vSendSelfMessage(const fi_tclMessageBase& roSendFiObj);
tVoid fc_sxm_vSendError(fc_sxm_trAdressing const &rAdressing, tU16 u16ErrorCode=0);


    /* send message via loopback to service- or client-handler */
template<class T, class M>
    tVoid fc_sxm_vPostMsgToCcaObj(T *poTarget, M const &rMsg) {
    (tVoid)poTarget;
    fc_sxm_trMsgCcaThreadMsg rCcaThreadMsg;
    fc_sxm_tclMsgCaller<T,M> *poCaller=OSAL_NEW fc_sxm_tclMsgCaller<T,M>;
    if(poCaller != NULL)
    {
    	poCaller->vSetMsg(rMsg);
    }
    rCcaThreadMsg.poCaller=poCaller;
        fc_sxm_tclApp::instance()->vPostMsgNew(rCcaThreadMsg);
    }

#endif //_FC_SXM_MAIN_H_

