/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglib_sysset_listener.h
* @brief       Declaration of diagnosis system set default listener
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef SXM_DIAGLIBSYSSETLISTENER_H
#define SXM_DIAGLIBSYSSETLISTENER_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"


#define SYSSETID_FC_SXM SYSSETID_TUNE_XM

// forward definition of own application class
//lint -esym(763, fc_sxm_tclApp)  Redundant declaration for symbol
class fc_sxm_tclApp;


// class definition
class fc_sxm_diagLibSysSetListener : public diaglib::tclSystemSetListenerIF ,public fc_sxm_tclSingleton <fc_sxm_diagLibSysSetListener>
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
    fc_sxm_diagLibSysSetListener();

    // default destructor
    virtual ~fc_sxm_diagLibSysSetListener();

    //method to initialise the system set listener
    tVoid vInit(diaglib::tclSystemSetIF* m_poSystemSetIF);

    // handler method for system setting
    virtual tU32 vOnSystemSet (
        tU32 u32SystemSetID, 
        diaglib::tenSystemSetType u32SystemSetType,
        diaglib::tContext MsgContext
        );

    // handler method for finaling of system setting
    virtual tU32 vOnSystemSetFinished (
        tU32 u32SystemSetID, 
        diaglib::tenSystemSetType u32SystemSetType,
        diaglib::tContext MsgContext
        );

    // handler method for preparing of system setting
    virtual tU32 vOnSystemSetPrepare (
        tU32 u32SystemSetID, 
        diaglib::tenSystemSetType u32SystemSetType,
        diaglib::tContext MsgContext
        );

    //tVoid vOnSysSetResult(trMsgSrvRspDefSet const *poSrvRspDefSet);
    tVoid vProcess(fc_sxm_trMsgDiagDefSetResult const *prMsg);

private:
    // Singleton class must be friend 
    friend class fc_sxm_tclSingleton<fc_sxm_diagLibSysSetListener>;

    // copy constructor
    fc_sxm_diagLibSysSetListener(const fc_sxm_diagLibSysSetListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // assignment operator
    fc_sxm_diagLibSysSetListener& operator=(const fc_sxm_diagLibSysSetListener& rhs);

    // attribute: reference to system set interface
    diaglib::tclSystemSetIF* m_poSystemSetIF;

    // attribute: reference of own application object
    tVoid vSendResult(fc_sxm_tenDiagResult enResult);
    diaglib::tContext m_MsgContext;

    //tBool m_bSysSetRunning;

};

#endif

