/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglib_routine_control.h
* @brief       Declaration of diagnosis routine control handler
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef SXM_DIAGLIBROUTINECONTROL_H
#define SXM_DIAGLIBROUTINECONTROL_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

//Remove once the release is done from FC_Diagnosis
#ifndef ROUTINEID_SET_SYSTEM_TO_DELIVERY_STATE_ADV_WARNINGS
#define ROUTINEID_SET_SYSTEM_TO_DELIVERY_STATE_ADV_WARNINGS 222
#endif

#define ROUTINECONTROLID_SXM_DEFSET ROUTINEID_SET_SYSTEM_TO_DELIVERY_STATE_ADV_WARNINGS

// class definition
class fc_sxm_diagLibRoutineControl : public diaglib::tclRoutineControlListenerIF, public fc_sxm_tclSingleton <fc_sxm_diagLibRoutineControl>
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
    fc_sxm_diagLibRoutineControl();

    //method to initialise the Routine control listener
    tVoid vInit(diaglib::tclRoutineControlIF* poRoutineCtrlIF);

    // default destructor
    virtual ~fc_sxm_diagLibRoutineControl();


     //do nothing
	virtual tU32 vOnGetRoutineResult ( 
                                      tU32 u32RoutineId,
                                      diaglib::tContext MsgContext
                                    );

    //do nothing
	virtual tU32 vOnRoutineControlAbort ( 
                                         tU32 u32RoutineId, 
                                         diaglib::tContext MsgContext
                                         );

    //start the test
	virtual tU32 vOnRoutineControlStart ( 
                                         tU32 u32RoutineId, 
                                         tU32 u32Bitmask, 
                                         const diaglib::tclParameterVector& oParamVector,
                                         diaglib::tContext MsgContext
                                       ); 

private:
    // Singleton class must be friend 
    friend class fc_sxm_tclSingleton<fc_sxm_diagLibRoutineControl>;
    // copy constructor
    fc_sxm_diagLibRoutineControl(const fc_sxm_diagLibRoutineControl& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // assignment operator
    fc_sxm_diagLibRoutineControl& operator=(const fc_sxm_diagLibRoutineControl& rhs);

    // attribute: reference to routine control interface
    diaglib::tclRoutineControlIF* m_poRoutineCtrlIF;
};

#endif

