/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglib_routine_control.cpp
* @brief       Implementation of diagnosis routine control handler.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_sxm_tcl_diag_defset.h"
#include "fc_sxm_diaglibhandler.h"
#include "fc_sxm_diaglib_routine_control.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER 
#include "trcGenProj/Header/fc_sxm_diaglib_routine_control.cpp.trc.h"
#endif


/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members and setup connection with diaglib
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*************************************************************************/
fc_sxm_diagLibRoutineControl::fc_sxm_diagLibRoutineControl() :
m_poRoutineCtrlIF(OSAL_NULL)
{
    ETG_TRACE_USR4(("fc_sxm_diagLibRoutineControl:fc_sxm_diagLibRoutineControl"));
}


/*************************************************************************
*
* FUNCTION:tVoid Destructor
* 
* DESCRIPTION: make sure we are unregistered
*
* PARAMETER:  void
*
* RETURNVALUE: void
*
*************************************************************************/
fc_sxm_diagLibRoutineControl::~fc_sxm_diagLibRoutineControl
()
{
    ETG_TRACE_USR4(("fc_sxm_diagLibRoutineControl:~fc_sxm_diagLibRoutineControl"));
    m_poRoutineCtrlIF = OSAL_NULL;
}

/*************************************************************************
*
* FUNCTION:tVoid fc_sxm_diagLibRoutineControl::vInit
*(
* diaglib::tclIoControlIF* pIoControlIF,
* )
* 
* DESCRIPTION: //method to initialise the IO control listener
*
* PARAMETER:  diaglib::tclIoControlIF* pIoControlIF,
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid fc_sxm_diagLibRoutineControl::vInit
(
 diaglib::tclRoutineControlIF* poRoutineCtrlIF
 )
{
    ETG_TRACE_USR4(("fc_sxm_diagLibRoutineControl:vInit"));

    m_poRoutineCtrlIF = poRoutineCtrlIF;
}


/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibRoutineControl::vOnGetRoutineResult
*(
*    tU32 u32RoutineId,
*     diaglib::tContext MsgContext
*    
*)
* 
* DESCRIPTION: Trigger for Routine control result
*
* PARAMETER: tU32 u32RoutineId //the diag lib identifier for this routine control
*            diaglib::tContext MsgContext
*            
*
* RETURNVALUE: tU32
*
*************************************************************************/
tU32 fc_sxm_diagLibRoutineControl::vOnGetRoutineResult
(
     tU32 u32RoutineId,
     diaglib::tContext MsgContext
     
 )
{
    (tVoid)u32RoutineId;
    (tVoid)MsgContext;

    ETG_TRACE_USR1(("fc_sxm_diagLibRoutineControl:vOnGetRoutineResult : Nothing to be done"));
   
    return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibRoutineControl::vOnRoutineControlAbort
*(
*    tU32 u32IoControlId,
*    diaglib::tContext MsgContext
*    
*)
* 
* DESCRIPTION: Trigger for IO control unfreeze
*
* PARAMETER: tU32 u32IoControlId //the diag lib identifier for this IO control
*            diaglib::tContext MsgContext
*            
*
* RETURNVALUE: tU32
*
*************************************************************************/
tU32 fc_sxm_diagLibRoutineControl::vOnRoutineControlAbort
(
    tU32 u32RoutineId, 
    diaglib::tContext MsgContext
)
{
    (tVoid)u32RoutineId;
    (tVoid)MsgContext;
    ETG_TRACE_USR1(("fc_sxm_diagLibRoutineControl:vOnRoutineControlAbort : Nothing to be done"));
    return diaglib::U32_DIAGLIB_RETURN_OK;
}


/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibRoutineControl::vOnRoutineControlStart
*(
*   tU32 u32RoutineId, 
*   tU32 u32Bitmask, 
*   const diaglib::tclParameterVector& oParamVector,
*   diaglib::tContext MsgContext
*)
*
* DESCRIPTION: Trigger for IO control activity
*
* PARAMETER: tU32 u32IoControlId,   //the diag lib identifier for this IO control
*            diaglib::tenIoControlAction enActionId, 
*            const diaglib::tclParameterVector& oParameterVector,
*            diaglib::tContext MsgContext
*
*
* RETURNVALUE: tU32
*
*************************************************************************/
tU32 fc_sxm_diagLibRoutineControl::vOnRoutineControlStart
(
 tU32 u32RoutineId, 
 tU32 u32Bitmask, 
 const diaglib::tclParameterVector& oParamVector,
 diaglib::tContext MsgContext
)
{
    ETG_TRACE_ERR(("fc_sxm_diagLibRoutineControl:vOnRoutineControlStart: entered"));
    (tVoid)oParamVector;
    (tVoid)u32Bitmask;
    tU32 u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;

    fc_sxm_tenDiagDefsetType enDefsetType=fc_sxm_enDiagDefsetType_Invalid;
    fc_sxm_tenDefsetState enState = fc_sxm_en_Defset_Idle;

    diaglib::tenRoutineCtrlResult enRoutineCtrlStatus = diaglib::EN_ROUTINE_CONTROL_NOT_OK;
    diaglib::tclParameterVector oResultVector;
    
    switch (u32RoutineId)
    {
        case ROUTINECONTROLID_SXM_DEFSET:
        {
            ETG_TRACE_ERR(("fc_sxm_diagLibRoutineControl:vOnRoutineControlStart: Pre defset entered"));
            enDefsetType = fc_sxm_enDiagDefsetType_Factory;
            enState = fc_sxm_en_PreDefset_Active;
            fc_sxm_trMsgDiagDefset rMsg(enDefsetType,enState);
            fc_sxm_tclAudioApp::instance()->vPostMsgNew(rMsg);
            enRoutineCtrlStatus = diaglib::EN_ROUTINE_CONTROL_OK;
        }
        break;

        default:
        {
           diaglib::trParameter rParameter;
           rParameter.enType=diaglib::EN_PARAMETER_TYPE_U8ERROR;
           rParameter.u8ErrorValue=diaglib::EN_ERROR_ID_NOT_SUPPORTED;
           oResultVector.push_back(rParameter);
           ETG_TRACE_ERR(("fc_sxm_diagLibRoutineControl:vOnRoutineControlStart: u32RoutineId=%u ",u32RoutineId));
           u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
    } // switch (u32RoutineId)

 
     if(OSAL_NULL != m_poRoutineCtrlIF)
      {
         m_poRoutineCtrlIF->bSendRoutineCtrlMethodResult( enRoutineCtrlStatus,
                                                         oResultVector,
                                                         MsgContext
                                                        );
      }

    return u32RetValue;
}




