/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_clienthandler_tts.h
* @brief       CCA client-handler for the TTS.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_CLIENT_TTS_H_
#define _FC_SXM_CLIENT_TTS_H_

#ifndef FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#endif


#ifndef AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#endif


#include "fc_sxm_tcl_base_client.h"
#include "fc_sxm_tcl_tts_context.h"
#include "fc_sxm_clienthandler_tts_fi.h"
#include "fc_sxm_wsalerts_messages.h"


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class fc_sxm_tclTTSClient :
   public fc_sxm_tclBaseClient,
   public fc_sxm_tclSingleton<fc_sxm_tclTTSClient>
{
public:
   virtual ~fc_sxm_tclTTSClient(tVoid);

   // Overriding ahl_tclBaseOneThreadClientHandler methods
   virtual tVoid vOnServiceAvailable(tVoid);
   virtual tVoid vOnServiceUnavailable(tVoid);

   // Handler function declarations used by message map
   virtual tVoid vOnStatus(tU16, amt_tclServiceData*);
   virtual tVoid vOnMethodResult(tU16, amt_tclServiceData*);
   virtual tVoid vOnMethodResultFirst(tU16, amt_tclServiceData*);
   virtual tVoid vOnMethodResultMiddle(tU16, amt_tclServiceData*);
   virtual tVoid vOnMethodResultLast(tU16, amt_tclServiceData*);
   virtual tVoid vOnError(tU16, amt_tclServiceData*);

   tVoid vHandleAudioSourceOn() const;
   tVoid vHandleAudioSourceOff() const;
   tVoid vHandleAudioSourcePause() const;

   // Operation on audio channel
   tBool bRequestAudioChannel(tVoid) const;
   tBool bReleaseAudioChannel(tVoid) const;

   // Operations on announcement
   tBool bStartAnnouncement(const string&);
   tBool bAbortAnnouncement(tVoid);
   tBool bStopAnnouncement(tVoid);
   tBool bPauseAnnouncement(tVoid) const;
   tBool bResumeAnnouncement(tVoid) const;
   tVoid vHandleAbortPromptResult(fc_sxm_trMsgTTSClientMResultAbortPrompt const *);

   // Handle method result
   tVoid vHandlePrepareVoiceOutputResult(fc_sxm_trMsgTTSClientMResultPrepareVoiceOutput const *) const;
   tVoid vHandleMethodResultFirstSynthesizeSpeak(fc_sxm_trMsgTTSClientMResultFirstSynthesizeSpeak const *) const;
   tVoid vHandleMethodResultMiddleSynthesizeSpeak(fc_sxm_trMsgTTSClientMResultMiddleSynthesizeSpeak const *) const;
   tVoid vHandleMethodResultLastSynthesizeSpeak(fc_sxm_trMsgTTSClientMResultLastSynthesizeSpeak const *) const;
   tVoid vHandlePausePromptResult(fc_sxm_trMsgTTSClientMResultPausePrompt const *) const;
   tVoid vHandleContinuePromptResult(fc_sxm_trMsgTTSClientMResultContinuePrompt const *) const;

   tVoid vHandleError() const;

   tBool bSendPrepareVoiceOutput(tVoid) const;
   tBool bSendSynthesizeSpeakToTTS(tVoid) const;
   tBool bClearSynthesizeText(tVoid);

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclTTSClient> ;
   fc_sxm_tclTTSClient(tVoid);

   tBool bSendAbortPrompt(tVoid) const;
   tBool bSendPausePrompt() const;
   tBool bSendContinuePrompt() const;

   string _sSynthesizeText;
   tBool _bIsAbort;
   tBool _bIsStop;
};

#endif // _FC_SXM_CLIENT_TTS_H_
