/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_client_download.cpp
* @brief       Client handler implementation for download service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_main.h"
#include "fc_sxm_client_download.h"
#include "fc_sxm_client_download_fi.h"
#include "fc_sxm_tcl_sxmapp_manager.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_APPLICATION
#include "trcGenProj/Header/fc_sxm_client_download.cpp.trc.h"
#endif

fc_sxm_tclDownloadClient::
fc_sxm_tclDownloadClient()
    : fc_sxm_tclBaseClient(
                           /* ID of used Service           */ CCA_C_U16_SRV_DOWNLOAD,
                           /* MajorVersion of used Service */ CFC_DOWNLOADFI_C_U16_SERVICE_MAJORVERSION ,
                           /* MinorVersion of used Service */ CFC_DOWNLOADFI_C_U16_SERVICE_MINORVERSION )
{
    ETG_TRACE_USR4(("fc_sxm_tclDownloadClient() entered."));

    // upregs:
    //   vAddAutoRegisterForProperty(CFC_SPMFI_C_U16_CVMEVENT); 
}

fc_sxm_tclDownloadClient::
~fc_sxm_tclDownloadClient(tVoid)
{
    ETG_TRACE_USR4(("~fc_sxm_tclDownloadClient() entered."));
}

