/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_client_diaglog.h
* @brief       File provides Client handler of diagnosis error memory handling.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_CLIENT_DIAGLOG_H_
#define _FC_SXM_CLIENT_DIAGLOG_H_

#include "fc_sxm_tcl_base_client.h"



class fc_sxm_tclDiagLogClient : 
public fc_sxm_tclBaseClient,
    public fc_sxm_tclSingleton<fc_sxm_tclDiagLogClient>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagLogClient>;
 private:
    fc_sxm_tclDiagLogClient(tVoid); 

  public:

    virtual ~fc_sxm_tclDiagLogClient();

    
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/

    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    virtual tVoid vOnStatus(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
    virtual tVoid vOnMethodResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

};



#endif //_FC_SXM_CLIENT_DIAGLOG_H_
