/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_client_diaglog.cpp
* @brief       Client handler of diagnosis error memory handling implementation.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_main.h"
#include "fc_sxm_tcl_diag_log.h"
#include "fc_sxm_client_diaglog.h"
#include "fc_sxm_client_diaglog_fi.h"
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_audio_app.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER
#include "trcGenProj/Header/fc_sxm_client_diaglog.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members and setup connection with diaglog
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*************************************************************************/
fc_sxm_tclDiagLogClient::
fc_sxm_tclDiagLogClient()
    : fc_sxm_tclBaseClient(
                           /* ID of used Service           */ CCA_C_U16_SRV_DIAGLOG,
                           /* MajorVersion of used Service */ MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION ,
                           /* MinorVersion of used Service */ MIDW_DIAGLOGFI_C_U16_SERVICE_MINORVERSION )
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagLogClient() entered."));

    // upregs:
    // property SendNextTestResult
  vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
 
}

/*************************************************************************
*
* FUNCTION:tVoid Destructor
* 
* DESCRIPTION: Destructor for the diaglog client
*
* PARAMETER:  void
*
* RETURNVALUE: void
*
*************************************************************************/
fc_sxm_tclDiagLogClient::
~fc_sxm_tclDiagLogClient(tVoid)
{
    ETG_TRACE_USR4(("~fc_sxm_tclDiagLogClient() entered."));
}


/*******************************************************************************
 *
 * FUNCTION: tVoid fc_sxm_tclDiagLogClient::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_sxm_tclDiagLogClient::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                    u16GetServerAppID()));

    // Send the current antenna status to set the DTC
    fc_sxm_trMsgAudioDiagSetSXMAntennaDTC rMsg;
    fc_sxm_tclAudioApp::instance()->vPostMsgNew(rMsg);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_sxm_tclDiagLogClient::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
 *******************************************************************************/
tVoid fc_sxm_tclDiagLogClient::vOnServiceUnavailable()
{
    ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                    u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_sxm_tclDiagLogClient::vOnServiceAvailable()
 *
 * DESCRIPTION: Handle all received status-fi-messages.
 *              For each function-id of interest use the macro SXM_PSTATUS_ENTRY 
  *             to create the corresponding thread-message and send its app
 *
 * PARAMETER: tU16 u16FID - Function ID.
 *            amt_tclServiceData* pServiceDataMessage -meassage
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnStatus
 *                       (tU16 u16FID, amt_tclServiceData* pServiceDataMessage).
 *******************************************************************************/
tVoid fc_sxm_tclDiagLogClient::vOnStatus
(
 tU16 u16FID,
 amt_tclServiceData* pServiceDataMessage
 )
{
    switch (u16FID) {
        SXM_PSTATUS_ENTRY(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, 
                          midw_diaglogfi_tclMsgSendNextTestResultStatus, 
                          fc_sxm_trMsgFiDiaglogNextTestStatus);
        default:
            vOnUnknownMessage(pServiceDataMessage);
            break;
    }
}

/*
  Handle all received method-result fi-messages.
  For each function-id of interest use the macro SXM_MRESULT_ENTRY 
  to create the corresponding thread-message and send its app
*/

tVoid fc_sxm_tclDiagLogClient::vOnMethodResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage) {
   switch (u16FID) {
        SXM_MRESULT_ENTRY(MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, midw_diaglogfi_tclMsgSaveTestResultMethodResult, fc_sxm_trMsgFiDiaglogMethodResultSaveTest);
        default:
            vOnUnknownMessage(pServiceDataMessage);
            break;
    }
}
