/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_audiorouting_lib.h
* @brief       CCA client-handler for the service audio routing library.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_AUDIOROUTING_LIB_H_
#define _FC_SXM_AUDIOROUTING_LIB_H_

#include "fc_sxm_common.h"
#define FC_SXM_S_IMPORT_INTERFACE_GENERIC
#include "fc_sxm_if.h"


struct fc_sxm_trMsgWsAlertsAudioSource;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/



// Messages from apps
struct fc_sxm_trMsgCmdArlTestLoopBack :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Cca, 1);
   tU8 u8TestVal;
};

class fc_sxm_arl_tclISource :
   public arl_tclISource,
   public fc_sxm_tclSingleton<fc_sxm_arl_tclISource>
{
   friend class fc_sxm_tclSingleton<fc_sxm_arl_tclISource> ;
   tBool _bMuteState;
#if((FC_SXM_ENABLE_WATCHDOG_TIMER) || (FC_SXM_ENABLE_LCM_WATCHDOG_TIMER))
   arl_tenActivity _enSourceState;
#endif
public:
   fc_sxm_arl_tclISource(tVoid);
   virtual ~fc_sxm_arl_tclISource();
#if((FC_SXM_ENABLE_WATCHDOG_TIMER) || (FC_SXM_ENABLE_LCM_WATCHDOG_TIMER))
    arl_tenActivity enGetSXMSourceState(tVoid) { return (_enSourceState); }
#endif
   /***************************************************************************
    * Overriding arl_tclISource methods. (AR_TRIGGER Interfaces)
    ***************************************************************************/
   virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
   virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
   virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
   virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);

   /***************************************************************************
    * Overriding arl_tclISource methods. (AR_API Interfaces)
    ***************************************************************************/

   //virtual tBool bSetMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);
   //virtual tVoid vSourceActivityResult(arl_tenSource enSrcNum, arl_tenActivity enMuteState);
   virtual tVoid vSetMute(tBool bMuteFlag); /* Mute Interface for fc_sxm Component */
   virtual tVoid vDispatchMsg(fc_sxm_tclMessage const *poThreadMsg);

   tVoid vProcess(fc_sxm_trMsgCmdArlTestLoopBack const *prMsg) const;

   tBool bRequestAudioRoute(arl_tenSource enAudioSource, arl_tenActivity enActivity);
   tBool bGetMuteState() const { return _bMuteState; }
   tVoid vSendSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason);
private:
   tBool bPostSourceActivityToAudio(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
   tBool bPostSourceActivityToTTSClient(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
};

#endif // _FC_SXM_AUDIOROUTING_LIB_H_

