/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_presets_if.h
* @brief       Interface for Presets class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PRESETS_IF_H_
#define FC_SXM_TCL_PRESETS_IF_H_

struct fc_sxm_trChannel;

class Ifc_sxm_tclPresets {
public:
	virtual ~Ifc_sxm_tclPresets() {  }
	virtual tU8 u8GetPresetIndex(SERVICE_ID) const = 0;
	virtual tVoid vNotifyTunedChannelPresetIndex(SERVICE_ID) = 0;
	virtual tVoid vPresetBandUpdate(fc_sxm_trChannel const &, CHANNEL_EVENT_MASK) const = 0;
	virtual tVoid vUpdateIRMode(tBool bValidate=TRUE, tBool bSetMode=FALSE) = 0;
	virtual tVoid vNotifyIRMode(tBool, tBool) = 0;
	virtual tVoid vSetTuneScanStatus(tBool) = 0;
	virtual tBool bGetTuneScanStatus() const = 0;
	virtual tVoid vTuneScanConfigure() = 0;
	virtual tVoid vTuneScanStop(midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult &ofiTxObj) = 0;
	virtual tVoid vGetPresetIndices(map<SERVICE_ID, tU8>& ) const = 0;
	virtual CHANNEL_ID u16GetSavedChannelId() const = 0;
	virtual tBool bHandleChangeProfilePresetList() = 0;
};


#endif /* FC_SXM_TCL_PRESETS_IF_H_ */
