/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_content_alert_proxy_if.h
* @brief       Interface for content alert proxy service which provides abstract method 
*              for sms seek api.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_CONTENT_ALERT_PROXY_IF_H
#define FC_SXM_TCL_CONTENT_ALERT_PROXY_IF_H

#include "fc_sxm_types.h"
#include "fc_sxm_audio_types.h"


struct fc_sxm_trMsgAudioATAlertList
{
   AT_SEEK_ENUM enFavoriteType;
   vector<midw_ext_fi_tcl_AlertInfo> vecAlertList;
};

struct fc_sxm_trMsgAudioATAlerts : public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_CONTENT_ALERT + 5);

   fc_sxm_trMsgAudioATAlerts()
   {
      oArtistAlerts.enFavoriteType = AT_SEEK_ARTIST;
      oSongAlerts.enFavoriteType = AT_SEEK_TITLE;
   }

   fc_sxm_trAdressing rAdressing;
   fc_sxm_trMsgAudioATAlertList oArtistAlerts;
   fc_sxm_trMsgAudioATAlertList oSongAlerts;
};

struct fc_sxm_trMsgAudioSeekCategoryUpdate : public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_CONTENT_ALERT + 6);
};

class Ifc_sxm_tclContentAlertProxy
{
public:
   virtual ~Ifc_sxm_tclContentAlertProxy() { /* Default DTOR */ }

   virtual SMSAPI_RETURN_CODE_ENUM enStart(DECODER_OBJECT) const = 0;
   virtual tVoid vStop(DECODER_OBJECT) const = 0;

   virtual tVoid vIterateFavorites(DECODER_OBJECT,
      SEEK_CONTENT_ITERATOR_CALLBACK ,
      void *) const = 0;

   virtual tVoid vIterateAlertChannels(DECODER_OBJECT ,
      CATEGORY_ID ,
      CATEGORY_ITERATION_HANDLER ,
      void *) const = 0;

   virtual CHANNEL_ID hGetTunedChannel(DECODER_OBJECT) const = 0;
   virtual CHANNEL_OBJECT hGetChannel(SEEK_EVENT_OBJECT) const = 0;
   virtual SEEK_CONTENT_OBJECT hGetSeekContent(SEEK_EVENT_OBJECT) const = 0;
   virtual CATEGORY_ID hGetSeekCategoryId(DECODER_OBJECT) const = 0;
   virtual tU32 u32GetSeekChannelSize(DECODER_OBJECT, CATEGORY_ID) const = 0;
   virtual SERVICE_ID hGetServiceId(CHANNEL_OBJECT) const = 0;
   virtual CHANNEL_ID hGetChannelId(CHANNEL_OBJECT) const = 0;
   virtual string sGetSmsStringAsStl(STRING_OBJECT) const = 0;
   virtual midw_ext_fi_tclString hGetSmsStringAsFi(STRING_OBJECT) const = 0;
   virtual STRING_OBJECT hGetChannelName(CHANNEL_OBJECT) const = 0;
   virtual STRING_OBJECT hGetArtistName(SEEK_CONTENT_OBJECT) const = 0;
   virtual STRING_OBJECT hGetSongName(SEEK_CONTENT_OBJECT) const = 0;
   virtual STRING_OBJECT hGetArtistName(CHANNEL_OBJECT) const = 0;
   virtual STRING_OBJECT hGetSongName(CHANNEL_OBJECT) const = 0;
   virtual AT_SEEK_ENUM enGetFavoriteType(SEEK_CONTENT_OBJECT) const = 0;
   virtual SEEK_EVENT_OBJECT hGetNextAlertEvent(DECODER_OBJECT) const = 0;
   virtual SMSAPI_RETURN_CODE_ENUM enGetNextEndedEventAttributes(DECODER_OBJECT,
      CHANNEL_ID* ,
      STRING_OBJECT* ,
      STRING_OBJECT* ) const = 0;
   virtual tBool bGetFavoriteStatus(SEEK_CONTENT_OBJECT) const = 0;
   virtual tBool bGetAlertsFinishedStatus(DECODER_OBJECT hDecoder) const = 0;

   virtual SMSAPI_RETURN_CODE_ENUM enRegisterFavorite(DECODER_OBJECT,
      AT_SEEK_ENUM,
      CHANNEL_ID,
      SEEK_CONTENT_OBJECT*) const = 0;
   virtual tVoid vIsAvailableToRegister(DECODER_OBJECT,
      CHANNEL_ID,
      SEEK_AVAILABILTY_ENUM*,
      SEEK_AVAILABILTY_ENUM*) const = 0;

   virtual SMSAPI_RETURN_CODE_ENUM enEnableFavorite(SEEK_CONTENT_OBJECT) const = 0;
   virtual SMSAPI_RETURN_CODE_ENUM enDisableFavorite(SEEK_CONTENT_OBJECT) const = 0;
   virtual SMSAPI_RETURN_CODE_ENUM enDeleteFavorite(SEEK_CONTENT_OBJECT) const = 0;
   virtual SMSAPI_RETURN_CODE_ENUM enEnableAlertsTuned(DECODER_OBJECT,
      BOOLEAN) const = 0;
   virtual SMSAPI_RETURN_CODE_ENUM enEnableAlertsFinished(DECODER_OBJECT,
      BOOLEAN) const = 0;

   virtual midw_ext_fi_tcl_AlertInfo oFillAlertInfo(SEEK_EVENT_OBJECT) const = 0;
};

#endif // FC_SXM_TCL_CONTENT_ALERT_PROXY_IF_H
