/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_audio_utils.h
* @brief       Declaration for all utility methods used by fc_sxm audio service. 
*              File controls all advisory notifications being triggered from audio service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_AUDIO_UTILS_H_
#define FC_SXM_TCL_AUDIO_UTILS_H_

#include "fc_sxm_types.h"
#include "fc_sxm_audio_types.h"

/*This enum type is used when a preset channel is stored. Since by default all preset channels need to be Smart Favorites,
 * this enum helps in evaluating the decision to be made for Smart favorites list (whether to delete, add, replace or take no action)
 * when a preset channel is added*/
typedef enum {
	enAction_Invalid = 0,
	enAction_NoAction = 1,
	enAction_AddChn = 2,
	enAction_ReplaceChn = 3,
	enAction_DeleteChn = 4
} enPresetChange_Action;

/* This enum type is used when SMS reports a new channel to be added to the channel list. The values declared in this
 * enum is used for deciding whether the newly reported channel has to be locked, unlocked or no action has to be taken.
 */
typedef enum {
	enChannelAction_Ignore = 0,
	enChannelAction_Lock = 1,
	enChannelAction_UnLock = 2
} enChannelLockAction ;

/*
 * Utility methods for audio are added in fc_sxm_tclAudioUtils.
 * Ground Rules: No external dependency to be introduced in this file.
 */
class fc_sxm_tclAudioUtils {
public:
	static enAdvisoryMsgType enGetAdvisoryType(const tU32 u32Value);
	static tBool bIsChannelAdvisory(const tU32 u32Value);
	static tBool bIsHighPriorityAdvisory(const tU32 u32Value);
	static tVoid vSetChannelAdvisoryMsgType(const tU32 u32Value,
			midw_ext_fi_tcl_e8_SystemMessage::tenType& enCurrentSystemMsg,
			enAdvisoryMsgType &enCheckAdvisory);
	static tVoid vSetHighPrioAdvisoryMsgType(const tU32 u32Value,
			midw_ext_fi_tcl_e8_SystemMessage::tenType& enCurrentSystemMsg,
			enAdvisoryMsgType &enCheckAdvisory);
	static tBool bRestoreToPreviewChannel(const tU32 u32Value);
	static tVoid vClearAllChannelAdvisories(tU32& u32Value);
	static tBool bSendPresetBandNotifications(const tU32 u32Mask);

	static enPresetChange_Action enGetPresetChangeAction(tU8 u8Presets_RemoveCount,
			tU8 u8SF_AddCount, tU8 u8SF_RemoveCount);
	static enPresetChange_Action enGetDuplicatePresetAction(tU8 u8SF_AddCount, tU8 u8SF_RemoveCount);
	static enPresetChange_Action enGetSingularPresetAction(tU8 u8SF_AddCount, tU8 u8SF_RemoveCount);
	static enPresetChange_Action enGetNonPresetAction(tU8 u8SF_AddCount, tU8 u8SF_RemoveCount);

	static CHANNEL_EVENT_MASK u16ConvertChannelEventBitSet(const midw_ext_fi_tcl_b16_CHANNEL_EVENT& event);
	static tBool bCompareChannelEventMask(const CHANNEL_EVENT_MASK tCompareMask, const CHANNEL_EVENT_MASK tSavedMask);

	static tBool bIsChannelTuneError(const midw_ext_fi_tcl_e8_SystemMessage::tenType& enErrorType);
	static enChannelLockAction enGetChannelLockAction (tBool bIsChnLocked, tBool bIsChnMature, tBool bMatureLockOn);
};


#endif /* FC_SXM_TCL_AUDIO_UTILS_H_ */
