/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_audio_app_if.h
* @brief       Application handler interface declaration for Audio service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_AUDIO_APP_IF_H_
#define FC_SXM_TCL_AUDIO_APP_IF_H_

class Ifc_sxm_tclChannelList;
class Ifc_sxm_tclCategoryList;
class Ifc_sxm_tclPresets;
class Ifc_sxm_tclPlayback;
struct fc_sxm_trMsgAudioATAlerts;
struct fc_sxm_trMsgAudioSeekCategoryUpdate;
struct decoder_object;

struct fc_sxm_trAdressing;
class midw_ext_sxm_audiofi_tclMsgBaseMessage;
struct fc_sxm_tcl_trFavoriteContentAlertInfo;
struct fc_sxm_tcl_trAlertNoticeListUpdate;
struct fc_sxm_tcl_trAudioPropertyTWNowServiceStatus;
struct fc_sxm_tcl_trAudioPropertyTWNowBulletinStatus;
struct fc_sxm_tcl_trAudioPropertySportsFlash_ServiceStatus;
struct fc_sxm_tcl_trAudioPropertySportsFlash_GameEventNotification;
struct fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification;
struct fc_sxm_trMsgSFGameAlert;
struct fc_sxm_trMsgSFFlashEventAlert;
struct fc_sxm_trMsgTWNowEventAlert;
struct fc_sxm_trChannel;
struct fc_sxm_tcl_trAudioPropertyTWNowPlaybackStatus;
struct fc_sxm_tcl_trAudioPropertySportsFlash_PlaybackStatus;
#ifdef VARIANT_S_FTR_ENABLE_PERSONALIZATION
struct fc_sxm_trMsgPresetsProfileChange;
#endif
class Ifc_sxm_tclProfileManager;

class Ifc_sxm_tclDecoder {
public:
	virtual ~Ifc_sxm_tclDecoder() { };
	virtual decoder_object* oGetDecoderObject() const = 0;
};

class Ifc_sxm_tclAudioApp : public Ifc_sxm_tclDecoder {
public:
	virtual Ifc_sxm_tclChannelList* poGetChannelListInstance() const = 0;
	virtual Ifc_sxm_tclCategoryList* poGetCategoryListInstance() const = 0;
	virtual Ifc_sxm_tclPresets* poGetPresetsInstance() const = 0;
	virtual Ifc_sxm_tclPlayback* poGetPlaybackInstance() const = 0;
	virtual decoder_object* oGetDecoderObject() const = 0;
	virtual void vMuteSXMAudio(unsigned char ) const = 0;
	virtual unsigned char bGetSXMAudioMuteState() const = 0;
	virtual void vSendAudioErrorMsg(fc_sxm_trAdressing const  &, int) = 0;
	virtual void vSendAudioFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_audiofi_tclMsgBaseMessage &) = 0;
    virtual void vFavoriteContentAlertInfo(const fc_sxm_tcl_trFavoriteContentAlertInfo& ) = 0;
	virtual void vAlertListUpdateStatus(const fc_sxm_tcl_trAlertNoticeListUpdate& ) = 0;
	// Notify TWNow Service's updated status
	virtual void vTWNowServiceStatus(const fc_sxm_tcl_trAudioPropertyTWNowServiceStatus & ) = 0;
	virtual void vTWNowBulletinStatus(const fc_sxm_tcl_trAudioPropertyTWNowBulletinStatus & ) = 0;
	virtual void vPostATAlertMsg(const fc_sxm_trMsgAudioATAlerts & ) = 0;
	virtual void vPostSeekCategoryUpdate(const fc_sxm_trMsgAudioSeekCategoryUpdate &) = 0;
	virtual void vSFlashServiceStatus(const fc_sxm_tcl_trAudioPropertySportsFlash_ServiceStatus& ) = 0;
	virtual void vSFlashGameEventNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_GameEventNotification& ) = 0;
	virtual void vSFlashFlashEventNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification& ) = 0;

	virtual void vSFGameAlertMsg (fc_sxm_trMsgSFGameAlert const & ) = 0;
	virtual void vSFFlashEventAlertMsg (fc_sxm_trMsgSFFlashEventAlert const & ) = 0;
	virtual void vTWNowEventAlertMsg(fc_sxm_trMsgTWNowEventAlert const &) = 0;
	virtual void vTWNowPlaybackNotify(const fc_sxm_tcl_trAudioPropertyTWNowPlaybackStatus&) = 0;
	virtual void vSFlashPlaybackNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_PlaybackStatus&) = 0;
	virtual const fc_sxm_trChannel* trGetChannel(signed short) const = 0;
	virtual signed short u16GetTunedChnID() const = 0;

	virtual void vAbortFlashEventPlayback() = 0;
	virtual bool bIsFlashEventPlayback() const = 0;

	virtual unsigned char bIsProfileChange() const = 0;
	virtual unsigned char u8GetActiveProfileId() const = 0;

	virtual ~Ifc_sxm_tclAudioApp() { };
};


#endif /* FC_SXM_TCL_AUDIO_APP_IF_H_ */
