/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_audio_app.h
* @brief       Application handler declaration for Audio service. 
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AUDIO_APP_H_
#define _FC_SXM_TCL_AUDIO_APP_H_

#include "fc_sxm_audio_fi.h"
#include "fc_sxm_audio_types.h"
#include "fc_sxm_tcl_audio_member.h"
#include "fc_sxm_tcl_base_app.h"
#include "fc_sxm_tcl_audio_app_if.h"
#include "fc_sxm_tcl_personalization_if.h"


#define enSMS_STATE_INIT_SUCCESS    TRUE
#define enSMS_STATE_INIT_FAILURE    FALSE

/* Setting channel list HMI update delay to 3 seconds */
#define FC_SXM_AUDIO_DEFAULT_CHANNEL_LIST_UPDATE_PERIOD    3000
/* Setting advisory delay to 4 seconds */
#define FC_SXM_AUDIO_DEFAULT_ADVISORY_UPDATE_PERIOD        4000
/* Setting high prio advisory delay to 2 seconds */
#define FC_SXM_AUDIO_HIGH_PRIO_ADVISORY_UPDATE_PERIOD      2000
/* Setting loading advisory wait period to 2 seconds */
#define FC_SXM_AUDIO_DEFAULT_LOADING_ADVISORY_WAIT_PERIOD  2000

/* Forward decleration of channel list class */
class fc_sxm_tclChannelList;
/* Forward decleration of advisory class */
class fc_sxm_tclAdvisories;

/*
note: u32Action must exist in every message.
*/




/* MethodStart for set Destination Position from CCA client */
struct fc_sxm_trMsgAudioMStartSetDestinationPostion: public fc_sxm_tclMessage 
{
    /* Service and service ID */
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 3);
    /* Re-addressing info */
    fc_sxm_trAdressing rAdressing;
    /* Method start request */
    midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart oFiMsg;
};

// Self-mesage of diag-reporter when an app has finished printing the report
struct fc_sxm_trMsgEvtAudioSmsModuleSubStatusChanged: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 4);
    //constructor
    fc_sxm_trMsgEvtAudioSmsModuleSubStatusChanged():
        hModule(MODULE_INVALID_OBJECT)
    {};
    MODULE_OBJECT hModule; //module object
};

struct fc_sxm_trMsgAudioSmsEvtAntennaQuality: public fc_sxm_tclMessage 
{
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 5);
    ANTENNA_STATE_ENUM eAntennaState;
};

struct fc_sxm_trMsgAudioSmsEvtSignalState: public fc_sxm_tclMessage 
{
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 6);
    SIGNAL_QUALITY_STRUCT eSignalQuality;
};

struct fc_sxm_trMsgAudioDiagAudioTestStart: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 7);	
    tU16 u16ChannelId;
};
/* Message to hold Clock FI details */
struct fc_sxm_trMsgAudioPropSetClockParams: public fc_sxm_tclMessage
{
	//Currently only Sports App is interested in Clock params
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 8);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_audiofi_tclMsgSetClockParamsSet oFiMsg;
};


// received from Sports App
struct fc_sxm_trMsgAppSportsMetaDataUpdate: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 9);
	tBool bMetaDataUpdate;
};


struct fc_sxm_trMsgAudioDiagSetSXMAntennaDTC: public fc_sxm_tclMessage
{
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 11);
};
#ifdef VARIANT_S_FTR_ENABLE_PERSONALIZATION
struct fc_sxm_trMsgAudioProfileChange: public fc_sxm_tclMessage
{
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_APP + 12);
    tBool bIsGuestUser;
};
#endif


class fc_sxm_tclAudioApp:
    public fc_sxm_tclBaseApp,
    public Ifc_sxm_tclAudioApp,
    public Ifc_sxm_tclPersonalization,
    public fc_sxm_tclSingleton<fc_sxm_tclAudioApp>
{
    private:

        // Singleton class must be friend 
        friend class fc_sxm_tclSingleton<fc_sxm_tclAudioApp>;
        //Audio proxy made friend so that it can access vAllowService()
        friend class fc_sxm_tclAudioProxy;

        //Constructor
        fc_sxm_tclAudioApp();

    public:
        static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Audio;

        //Destructor
        virtual ~fc_sxm_tclAudioApp();

        //Initialize the audio service
        tVoid vInitialize(tVoid);

        //DeInitialize the audio service
        tVoid vDeInitialize(tVoid);

        // Get the decoder object
        DECODER_OBJECT oGetDecoderObject(tVoid) const;

        // interface to system-states
        tVoid vStop() const;
        tVoid vSetDecoder(DECODER_OBJECT hDecoder);

        // Over-ride Ifc_sxm_tclAudioApp::poGetChannelListInstance
        Ifc_sxm_tclChannelList* poGetChannelListInstance() const;

        // Over-ride Ifc_sxm_tclAudioApp::poGetChannelListInstance
        Ifc_sxm_tclCategoryList* poGetCategoryListInstance() const;

        // Over-ride Ifc_sxm_tclAudioApp::poGetPresetsInstance
        Ifc_sxm_tclPresets* poGetPresetsInstance() const;

        // Over-ride Ifc_sxm_tclAudioApp::poGetPlaybackInstance
        Ifc_sxm_tclPlayback* poGetPlaybackInstance() const;


        // Over-ride Ifc_sxm_tclAudioApp::vSetMute
        tVoid vMuteSXMAudio(tBool ) const;
        tBool bGetSXMAudioMuteState() const;

        // Methods to send FI MethodResult and MethodError
        tVoid vSendAudioFiMsg(fc_sxm_trAdressing const& rAdressing, const midw_ext_sxm_audiofi_tclMsgBaseMessage& oMRes);
		tVoid vSendAudioErrorMsg(fc_sxm_trAdressing const  &, tInt);

		tVoid vFavoriteContentAlertInfo(const fc_sxm_tcl_trFavoriteContentAlertInfo& );
	    tVoid vAlertListUpdateStatus(const fc_sxm_tcl_trAlertNoticeListUpdate& );
		tVoid vTWNowServiceStatus(const fc_sxm_tcl_trAudioPropertyTWNowServiceStatus & ) ;
		tVoid vTWNowBulletinStatus(const fc_sxm_tcl_trAudioPropertyTWNowBulletinStatus & ) ;
		tVoid vPostATAlertMsg(const fc_sxm_trMsgAudioATAlerts & );
		tVoid vPostSeekCategoryUpdate(const fc_sxm_trMsgAudioSeekCategoryUpdate &);
		tVoid vSFlashServiceStatus(const fc_sxm_tcl_trAudioPropertySportsFlash_ServiceStatus& );
		tVoid vSFlashGameEventNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_GameEventNotification& );
		tVoid vSFlashFlashEventNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification& );

		tVoid vSFGameAlertMsg (fc_sxm_trMsgSFGameAlert const & );
		tVoid vSFFlashEventAlertMsg (fc_sxm_trMsgSFFlashEventAlert const & );
		tVoid vTWNowEventAlertMsg(fc_sxm_trMsgTWNowEventAlert const &);

		tVoid vTWNowPlaybackNotify(const fc_sxm_tcl_trAudioPropertyTWNowPlaybackStatus& );
		tVoid vSFlashPlaybackNotify(const fc_sxm_tcl_trAudioPropertySportsFlash_PlaybackStatus& );

		const fc_sxm_trChannel* trGetChannel(CHANNEL_ID) const;
		tVoid vAbortFlashEventPlayback();
		bool bIsFlashEventPlayback() const;
		CHANNEL_ID u16GetTunedChnID() const;

		tBool bIsProfileChange() const;
		tU8 u8GetActiveProfileId() const;
		
		tBool bIsSMSCfgError() const {
			return _bIsSMSCfgError;
		}

		tVoid vSetSMSCfgError(tBool bIsSMSCfgError) {
			_bIsSMSCfgError = bIsSMSCfgError;
		}

    private:
        /*
          all dispatch-functionality should be private to make sure that it is only called in the correct context.
        */

        // the dispatch-fn can be private because the thread is friend.
        tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);
    
        /* Process set destination position method start msg from client */
        tVoid vProcess(fc_sxm_trMsgAudioMStartSetDestinationPostion const *prMsg) const;
        //Process to start the audio test trigerred from FC_Diagnosis
        tVoid vProcess(fc_sxm_trMsgAudioDiagAudioTestStart const *prMsg) const;
        tVoid vProcess(fc_sxm_trMsgAudioPropSetClockParams const *prMsg) const;

        tVoid vProcess(fc_sxm_trMsgAppSportsMetaDataUpdate const *prMsg);

        // SMS-Events (sent by fc_sxm_tcl_audio_sms_callbacks)


        // Commands from cca-context (sxmapp_manager)
   
        // ttfis-cmds
        virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
        
        tVoid vAssignBrowseRateConfig(vector<midw_ext_fi_tcl_BrowseRateConfiguration, allocator<midw_ext_fi_tcl_BrowseRateConfiguration> >& vectConfig, const tU8 u8Param) const;
#ifdef VARIANT_S_FTR_ENABLE_PERSONALIZATION
        tVoid vProcess(fc_sxm_trMsgAudioProfileChange const * /* prMsg */ );
        Ifc_sxm_tclProfileManager* poGetProfileManagerInstance() const;
#endif
		tVoid vChangeProfileUpdate(tBool bIsGuestUser);
		tVoid vCopyProfileUpdate();
		tVoid vDeleteProfileUpdate();


    private:

        /* Instances os all the helper classes of sxm audio */
        DECODER_OBJECT  _hDecoder;

        fc_sxm_tclAudioMemberList _oMemberList;
        
        tBool _bIsSMSCfgError;

 protected:
        virtual tVoid vPrintReport();
};

#endif //_FC_SXM_TCL_AUDIO_APP_H_
