/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diagtm_handler.h
* @brief       SXM Diagnosis Testmode handler. Responsible for creation ,Mediator for other
*              Diagnosis classes and also destruction.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_TM_HANDLER_H_
#define _FC_SXM_TCL_DIAG_TM_HANDLER_H_


#include "fc_sxm_audio_fi.h"
#include "fc_sxm_tcl_audio_app.h"
#include "fc_sxm_diag_types.h"

struct fc_sxm_trMsgAudioSmsEvtModuleState;

/*Value of 500ms mentioned in Audio UIRR : Diagnostic_Mode_008*/
/* peha, todo: call like FC_SXM_DIAG_TESTMODEDATA_TIMER_VAL_MS, put to config.h */
#define DIAG_TESTMODEDATA_TIMER_VAL 500

// timer-event to emit collected test-mode data
struct fc_sxm_trMsgCmdEmitTestModeData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_TM + 1);
    //constructor
    fc_sxm_trMsgCmdEmitTestModeData() {};
};

// command to start of stop generation of test-mode data
struct fc_sxm_trMsgDiagMStartTestModeEnable: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_TM + 2);
    //constructor
    fc_sxm_trMsgDiagMStartTestModeEnable(){};

    fc_sxm_trAdressing rAdressing;
    //to store diagtest mode enable msgs
    midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart oFiMsg;
};

// command to start of stop generation of test-mode data
struct fc_sxm_trMsgDiagMFetchUpcValue: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_TM + 3);
    //constructor
    fc_sxm_trMsgDiagMFetchUpcValue(){};

    fc_sxm_trAdressing rAdressing;
    //to store diagUpcvalues
    midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart oFiMsg;
};

struct fc_sxm_trMsgDiagSxmDbReplaced: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio,FC_SXM_AUDIO_ACTION_BASE_DIAG_TM + 4);
    //constructor
    fc_sxm_trMsgDiagSxmDbReplaced() {};
};



class fc_sxm_tclDiagTmHandler:
public fc_sxm_tclDiagMember,
    public fc_sxm_tclSingleton<fc_sxm_tclDiagTmHandler>
{

public:


    /*Destructor*/
    virtual ~fc_sxm_tclDiagTmHandler();

    // Method to send test-mode data on timeout
    tVoid vProcessTimer(fc_sxm_trMsgCmdEmitTestModeData const *prMsg);

    //Method to enable or disable sending of test-mode
    tVoid vProcess(fc_sxm_trMsgDiagMStartTestModeEnable const *prMsg);

    //Method to enable Package Id info collection
    tVoid vProcess(fc_sxm_trMsgDiagMFetchUpcValue const *prMsg) const;

    inline tBool bIsActive() 
    {
        return m_bActive; //return the active state
    }

    inline tVoid vStop()
    {
        vActivate(FALSE); //set the active state to FALSE
    }
    /*Function to update diagnosis related data*/

    tVoid vHandleEngineeringDataCallBack(DECODER_OBJECT hDecoderObject) const;

     /* fetch subscription-info */
    tVoid vProcess(fc_sxm_trMsgEvtAudioSmsModuleSubStatusChanged const *prMsg);  

    /* fetch version-info once the module has gone to ready */
    tVoid vProcess(fc_sxm_trMsgAudioSmsEvtModuleState const *prMsg);

    //This function is used to update the Data base version related info 
    tVoid vUpdateDataBaseVersion();

    /*Method to get the SXM version information */
    /*fc_sxm_tclProtectedData<
         fc_sxm_trDiagSxmVersionInfo>& rfGetSxmVersionInfo(tVoid);*/

    /*Method to get the SXM subsription related status*/
    /*fc_sxm_tclProtectedData<
         fc_sxm_trDiagSxmSubStatus>& rfGetSxmServiceStatus(tVoid);*/


private:      
    /*Constructor*/
    fc_sxm_tclDiagTmHandler();

    /*Method to activate and deactivate the service test mode*/
    tVoid vActivate(tBool bEnable);

    /*Method to update the SXM version and service status on expiry of 
    Test mode timer*/
    tVoid vUpdateSxmVerServiceStatus(tVoid);

    //This function is used to update the SXM version related info got from the module call back
    tVoid vUpdateModuleVersion();

    //This function is used to update SXM Radio ID to the clients
    tVoid vUpdateRadioId() const;

    //Method to populate DB error string on object construction
    tVoid vPopulateDbErrorString();

    //Method to remove DB error string on object destruction
    tVoid vRemoveDbErrorString();

    //Method to check the status of DbVersion read and update the HMI with DB version or system error
    tVoid vCheckNWriteDbVersion(DATASERVICE_REF_DATA_VER u32Version,DATASERVICE_ERROR_CODE_ENUM eStatus,midw_ext_fi_tclString& rffiObj);

    // Singleton class must be friend 
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagTmHandler>;      

    //Timer for updating the Test mode data to HMI
    fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgCmdEmitTestModeData,fc_sxm_tclDiagTmHandler> m_oTestModeTimer;

    //Flag to check whether the timer is active or not
    tBool m_bActive;

     //structure to store Version info
    fc_sxm_tclProtectedData<
        fc_sxm_trDiagSxmVersionInfo> m_DiagVersionInfo;

    //Structure to subscription status
    fc_sxm_tclProtectedData<
        fc_sxm_trDiagSxmSubStatus> m_DiagSubStatus;

    //Vector to store the error strings for DB
    vector<string> m_vecDbErrorStrings;
};

#endif //_FC_SXM_TCL_DIAG_TM_HANDLER_H_
