/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_reporter.cpp
* @brief       Implementation for printing reports of all SXM services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_tcl_timer.h"
#include "fc_sxm_tcl_diaghandler.h"
#include "fc_sxm_tcl_diag_for_each_base.h"
#include "fc_sxm_tcl_diag_reporter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER
#include "trcGenProj/Header/fc_sxm_tcl_diag_reporter.cpp.trc.h"
#endif


// start dia-reporter
fc_sxm_tclDiagReporter::fc_sxm_tclDiagReporter():
    fc_sxm_tclDiagForEach<fc_sxm_tclDiagReporter>(3000)
{
	/*Initialise the diag reporter*/
        ETG_TRACE_USR4(("fc_sxm_tclDiagReporter CTOR"));
}

fc_sxm_tclDiagReporter::~fc_sxm_tclDiagReporter() {
    ETG_TRACE_USR4(("fc_sxm_tclDiagReporter DTOR")); //Destructor
}

tVoid fc_sxm_tclDiagReporter::vProcess(fc_sxm_trMsgCmdDiagPrintReport const *prMsg) {
    (tVoid)prMsg; //To remove Lint warning
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "##################### FC_SXM Report START ########################"));
    bStart(); // start report
   fc_sxm_trMsgCmdDiagForEachTimeout rMsg;
   vProcessTimer(&rMsg);
}


tVoid fc_sxm_tclDiagReporter::vProcess(fc_sxm_trMsgCmdDiagPrintReportDone const *prMsg) {
    (tVoid)prMsg; //To remove lint warning
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "##################### FC_SXM Report END   ########################"));
}


tVoid fc_sxm_tclDiagReporter::vQueryApp(fc_sxm_tclBaseApp* poBaseApp) {
    ETG_TRACE_USR4(("fc_sxm_tclDiagReporter::vQueryApp(%s)", poBaseApp->szGetName()));
    fc_sxm_trMsgCmdAppPrintReport rMsgOut;
    poBaseApp->vPostMsgNew(rMsgOut); //post message
}

    //get timer

tVoid fc_sxm_tclDiagReporter::vOnDone() {
    ETG_TRACE_USR4(("fc_sxm_tclDiagReporter::vOnDone"));
    fc_sxm_trMsgCmdDiagPrintReportDone rMsg;
    fc_sxm_tclAudioApp::instance()->vPostMsgNew(rMsg); //post message
}
