/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_handler_test.cpp
* @brief       SXM Diagnosis handler. Test stub for testing FC_SXM Diagnosis.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_main.h"

#include "fc_sxm_service_sxm_audio.h"
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_audio_fi.h"


#include "fc_sxm_tcl_audio_app.h"

#include "fc_sxm_diag_if.h"

#include "fc_sxm_tcl_diag_handler_test.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER
#include "trcGenProj/Header/fc_sxm_tcl_diag_handler_test.cpp.trc.h"
#endif

/*******************************************************************************
*
* FUNCTION: fc_sxm_tclDiagHandler_test::
*             fc_sxm_tclDiagHandler_test()
*
* DESCRIPTION: Constructor .
*              
*
* PARAMETER: None
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_sxm_tclDiagHandler_test::fc_sxm_tclDiagHandler_test()/*:
    fc_sxm_tclBaseApp("sxmDiagHandler", fc_sxm_enServiceID_Audio)*/
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test constructor"));
}

/*******************************************************************************
*
* FUNCTION: fc_sxm_tclDiagHandler_test::
*             ~fc_sxm_tclDiagHandler_test()
*
* DESCRIPTION: Destructor .
*              
*
* PARAMETER: None
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_sxm_tclDiagHandler_test::~fc_sxm_tclDiagHandler_test()
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test destructor"));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclDiagHandler_test::vTrace()
*
* DESCRIPTION: This method is used for tracing the Antenna state
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tclDiagHandler_test::vTraceRegValues() const
{
     ETG_TRACE_USR1(("fc_sxm_tclDiagHandler_test vTraceRegValues"));

     tU8 u8Serialno[50];

     if(TRUE != bReadVerRegKey(SXM_DIAG_REG_SERIAL_NUM_KEY,(char*)u8Serialno,50))
     {
        ETG_TRACE_USR2(("fc_sxm_tclDiagHandler_test vTraceRegValues serial no read failed"));
     }
     else
     {
        ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTraceRegValues serial no = %s",u8Serialno));
     }

     tU8 u8HwVer[50];
     if(TRUE != bReadVerRegKey(SXM_DIAG_REG_HW_VER_KEY,(char*)u8HwVer,50))
     {
        ETG_TRACE_USR2(("fc_sxm_tclDiagHandler_test vTraceRegValues u8HwVer no read failed"));
     }
     else
     {
        ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTraceRegValues u8HwVer no = %s",u8HwVer));
     }

     tU8 u8SwVer[50];
     if(TRUE != bReadVerRegKey(SXM_DIAG_REG_SW_VER_KEY,(char*)u8SwVer,50))
     {
        ETG_TRACE_USR2(("fc_sxm_tclDiagHandler_test vTraceRegValues u8SwVer no read failed"));
     }
     else
     {
        ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTraceRegValues u8SwVer no = %s",u8SwVer));
     }
}



/************************************************************************************
*          Adding the tracing from Diagnosis property class                         *     
*************************************************************************************/

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trDiagPropertyTestModeData::vTrace()
*
* DESCRIPTION: This method is used for tracing the test mode data on notification
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trDiagPropertyTestModeData::vTrace() const
{
    ETG_TRACE_ERR(("XXXX fc_sxm_tcl_trDiagPropertyTestModeData vTrace"));

    // midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus &rFiData = fc_sxm_tclDiagProperties::instance()->oTestModeData.rAccess().oFiMsg;

    const midw_ext_fi_tcl_SxmDetSignalQuality  &rDetSigQual = oFiMsg.Data.DetSignalQuality;

    /*Detailed qwality value*/
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : Signal Strength     =%s",rDetSigQual.SigQuality.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : Tuner status        =%s",rDetSigQual.TunerStatus.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : EnsALockstatus      =%s",rDetSigQual.ENSALockStatus.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : EnsBLockstatus      =%s",rDetSigQual.ENSBLockStatus.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oBers1              =%s",rDetSigQual.BerS1.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oBers2              =%s",rDetSigQual.BerS2.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oBert               =%s",rDetSigQual.BerT.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oCNS1A              =%s",rDetSigQual.CtoNS1A.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oCNS1B              =%s",rDetSigQual.CtoNS1B.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oCNS2A              =%s",rDetSigQual.CtoNS2A.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oCNS2B              =%s",rDetSigQual.CtoNS2B.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oRSErrsWord         =%s",rDetSigQual.RSErrsWords.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oRSErrsSatSymb      =%s",rDetSigQual.RSErrSatSymb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oRSErrsTerrSymb     =%s",rDetSigQual.RSErrTerrSymb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oTunerCarrFreqOfset =%s",rDetSigQual.TunerCarrFreqOfset.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : RSSI                =%s",rDetSigQual.RSSI.szValue));

    /*Overlay Qwality value*/

    const midw_ext_fi_tcl_SxmDetOvrlSignalQuality &rDetOvrSigQual = oFiMsg.Data.DetOvrlSignalQuality;

    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : oReceiverState      =%s",rDetOvrSigQual.ReceiverState.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERS1A             =%s",rDetOvrSigQual.OBerS1A.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERS1B             =%s",rDetOvrSigQual.OBerS1B.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERS2A             =%s",rDetOvrSigQual.OBerS2A.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERS2B             =%s",rDetOvrSigQual.OBerS2B.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERTerrA           =%s",rDetOvrSigQual.OBerTA.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERTerrB           =%s",rDetOvrSigQual.OBerTB.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERTrbWrdErRt0A    =%s",rDetOvrSigQual.OBERTrbWrdErRt0A.szValue));   
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : OBERTrbWrdErRt0B    =%s",rDetOvrSigQual.OBERTrbWrdErRt0B.szValue));

    /*SXM VersionInfo*/
    const midw_ext_fi_tcl_SxmVersionInfo &rSxmVerInfo = oFiMsg.Data.SxmVersionInfo;

    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : ModuleId      =%s",rSxmVerInfo.ModuleId.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : HwRev         =%s",rSxmVerInfo.HwRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : SwRev         =%s",rSxmVerInfo.SwRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : SxiRev        =%s",rSxmVerInfo.SxiRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : BbRev         =%s",rSxmVerInfo.BbRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : HDecRev       =%s",rSxmVerInfo.HDecRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : RFRev         =%s",rSxmVerInfo.RFRev.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : Capability    =%s",rSxmVerInfo.Capability.szValue));   

    /*SXM Service status*/
    const midw_ext_fi_tcl_SxmDataSubStatus &rSxmServState = oFiMsg.Data.SxmSubscriptionState;

    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : subStatus          =%d",rSxmServState.SubStatus));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : ReasonCode      =%x",rSxmServState.ReasonCode));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsDiagData : SuspendedDate   =%d",rSxmServState.SuspendedDate));   

}


/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trDiagPropertySignalQuality::vTrace()
*
* DESCRIPTION: This method is used for tracing the Signal quality status
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trDiagPropertySignalQuality::vTrace() const
{
     ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsSignalquality  =%d",(tU8)oFiMsg.SignalQualityStatus.enType));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trDiagPropertyAntennaState::vTrace()
*
* DESCRIPTION: This method is used for tracing the Antenna state
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trDiagPropertyAntennaState::vTrace() const
{
     ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test vTestSmsAntenna state  =%d",(tU8)oFiMsg.AntennaStatus.enType));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trDiagSxmRadioId::vTrace()
*
* DESCRIPTION: This method is used for tracing the Radio Id
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trDiagSxmRadioId::vTrace() const
{
     ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Radio ID %s ",oFiMsg.RadioId.szValue));
}


/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trSxmDbVersionStatus::vTrace()
*
* DESCRIPTION: This method is used for tracing the SXM DB Version
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trSxmDbVersionStatus::vTrace() const
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest CGS DB Version : %s ",oFiMsg.Data.CgsDb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Fuel DB Version : %s ",oFiMsg.Data.FuelDb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Movie DB Version : %s ",oFiMsg.Data.MovieDb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest TabWeather DB Version : %s ",oFiMsg.Data.TabWeatherDb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Stock DB Version : %s ",oFiMsg.Data.StockDb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest SafeView DB Version : %s ",oFiMsg.Data.SafeViewdb.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest SMS Version : %s ",oFiMsg.Data.SmsVersion.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Sports Version : %s ",oFiMsg.Data.SportsDB.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Parking Version : %s ",oFiMsg.Data.ParkingDB.szValue));
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler_test::vTest Canadian_fuel Version : %s ",oFiMsg.Data.FuelCanadaDB.szValue));

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trSxmModuleSubStatus::vTrace()
*
* DESCRIPTION: This method is used for tracing the SXM module Subscription status
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trSxmModuleSubStatus::vTrace() const
{
   ETG_TRACE_USR4(("fc_sxm_tcl_trSxmModuleSubStatus Substaus= %d :reason=%d:suspend=%d ",oFiMsg.Data.SubStatus,
                                                                         oFiMsg.Data.ReasonCode,oFiMsg.Data.SuspendedDate));
}


/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tcl_trSxmDownloadProgress::vTrace()
*
* DESCRIPTION: This method is used for tracing the SXM module Subscription status
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tVoid fc_sxm_tcl_trSxmDownloadProgress::vTrace() const
{
   ETG_TRACE_USR4(("fc_sxm_tcl_trSxmDownloadProgres Progress= %d ,Active=%d",oFiMsg.Progress,oFiMsg.bActive));
}


/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclDiagHandler_test::bReadVerRegKey
* (
* char const *pKey,
*  char *pValue,
* tU32 u32Len
*  )
*
* DESCRIPTION: This function is used for testing the registry write 
*
* PARAMETER: char const *pKey,
*           char *pValue,
*          tU32 u32Len
*
* RETURNVALUE: NONE
*
*******************************************************************************/
tBool fc_sxm_tclDiagHandler_test::bReadVerRegKey
(
 char const *pKey,
 char *pValue,
 tU32 u32Len
 ) const
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagHandler::bReadVerRegKey"));

    tBool bRetVal = TRUE;

    fc_sxm_tclRegUtil oReg(SXM_DIAG_REG_VERSIONS_PATH);

     if(TRUE != oReg.bRead(pKey,pValue,u32Len))
    {
        ETG_TRACE_USR2(("bReadVerRegKey: strModuleId Registry read failed"));

        bRetVal = FALSE;
    }

     return bRetVal;

}

