/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_for_each_base.h
* @brief       Declaration of common diagnosis functionalities that has to be 
*              carried out in each of the services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_DIAG_FOR_EACH_BASE_H
#define FC_SXM_TCL_DIAG_FOR_EACH_BASE_H


// Self-mesage of diag-reporter when an app has finished printing the report
struct fc_sxm_trMsgCmdDiagForEachTimeout: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_FOREACH + 0);
    fc_sxm_trMsgCmdDiagForEachTimeout() {};
};


// base-class for all actions that require to query all apps one by one
class fc_sxm_tclDiagForEachBase {
 public:
    virtual ~fc_sxm_tclDiagForEachBase();
    tBool bStart();
    tBool bGetResult() {
        return _bOk && (_enCurServiceId == fc_sxm_enServiceID_All); //returns the result
    }
    tVoid vHandleAppAnswer(fc_sxm_tenServiceID enServiceId, tBool bOk=TRUE);

    tVoid vProcessTimer(fc_sxm_trMsgCmdDiagForEachTimeout const *prMsg);

 protected:
    fc_sxm_tclDiagForEachBase(tU32 u32TimeoutMs=1000);
    tBool bIsActive();


    virtual tVoid vQueryApp(fc_sxm_tclBaseApp* poBaseApp)=0;
    /*function to get the timer*/
    virtual fc_sxm_tclTimerBase *poGetTimer()=0;

    virtual tVoid vOnDone() = 0;

 private:

    tVoid vQueryNextApp();

    fc_sxm_tclSem _oSem;
    map<fc_sxm_tenServiceID, fc_sxm_tenDiagResult> _mapResults;
    //map<fc_sxm_tclBaseApp*, fc_sxm_tenDiagResult>::iterator _iter;
    map<fc_sxm_tenServiceID, fc_sxm_tenDiagResult>::iterator _iter;
    tBool _bOk;
    tU32 _u32TimeoutMs;
    tBool _bFirst;
    fc_sxm_tenServiceID _enCurServiceId;
};

template<class CHILD>
class fc_sxm_tclDiagForEach: public fc_sxm_tclDiagForEachBase {
 public:
    //    using fc_sxm_tclDiagForEachBase::vProcess;

    fc_sxm_tclDiagForEach(tU32 u32Timeout):
        fc_sxm_tclDiagForEachBase(u32Timeout) {
    }
        
        ~fc_sxm_tclDiagForEach() {
            _oSupervisonTimer.vStop();
        }



 protected:
    virtual fc_sxm_tclTimerBase *poGetTimer() {
        return &_oSupervisonTimer;
    }
    fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgCmdDiagForEachTimeout, CHILD> _oSupervisonTimer;

 private:
   // fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgCmdDiagForEachTimeout, CHILD> _oSupervisonTimer;

};


#endif
