/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_ext_mode.h
* @brief       SXM Diagnosis external diagnosis mode(also called CTI mode) handler.
*              SXM uses CTI mode to test X65 chip on the DUT. Mainly used in type approval.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_EXT_MODE_H_
#define _FC_SXM_TCL_DIAG_EXT_MODE_H_


#include "fc_sxm_common.h"
#include "fc_sxm_tcl_states.h"
#include "fc_sxm_diag_types.h"



// command to start or exit external diagnosis mode
struct fc_sxm_trMsgDiagExtMode: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_EXT_MODE+1);
    fc_sxm_trMsgDiagExtMode(){};

    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart oFiMsg;
};

//The external diagnosis mode activity class
class fc_sxm_tclDiagExtModeActivity: public fc_sxm_tclActivityBase {
 public:
    fc_sxm_tclDiagExtModeActivity() //Activity class constructor
    {
        bSetType(fc_sxm_enSystemState_DefsetFactory);
    }
    
    virtual tVoid vRun();
};

//The class to handle the External Diagnosis mode fucntionality
class fc_sxm_tclDiagExtDiagnosisMode:
public fc_sxm_tclDiagMember,
public fc_sxm_tclSingleton<fc_sxm_tclDiagExtDiagnosisMode>
{
 public:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagExtDiagnosisMode>;

    // we get the trigger from HMI for External diagnosis mode
    tVoid vProcess(fc_sxm_trMsgDiagExtMode const *prMsg);
    
    //Handle method result for External diagnosis mode
    tVoid vHandleExtDiagModeResult();

    //Provide the status of external diag mode
    tBool bGetExtDiagModeStatus();

 private:
    fc_sxm_tclDiagExtDiagnosisMode(); //Constructor
    tBool m_bIsExtDiagModeOn;
    fc_sxm_tclDiagExtModeActivity m_oExtDiagModeActivity;
    fc_sxm_trAdressing m_rAdressing;    
};
#endif
