/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_download.h
* @brief       Declarations for handling SMS Firmware download activity.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_DOWNLOAD_H_
#define _FC_SXM_TCL_DIAG_DOWNLOAD_H_


#include "fc_sxm_common.h"
#include "fc_sxm_tcl_states.h"
#include "fc_sxm_diag_types.h"

// todo: put defines to fc_sxm_config.h
#define FC_SXM_DIAG_DL_MAX_WAIT_START_MS (20 * 1000)
#define FC_SXM_DIAG_DL_MAX_WAIT_RESTART_MS (20 * 1000)
#define FC_SXM_DIAG_DL_MAX_WAIT_MS (600 * 1000)
#define FC_SXM_DIAG_DL_WAIT_PRE_RUN_MS (5 * 1000)

typedef enum {
    fc_sxm_enDiagDownloadState_Idle,
    fc_sxm_enDiagDownloadState_Pending, // wait for activity vRun
    fc_sxm_enDiagDownloadState_PreRun, // hack: wait a few seconds to let sms really stop the decoder
    fc_sxm_enDiagDownloadState_Running, // actual download running via sms
    fc_sxm_enDiagDownloadState_WaitRestart // wait for module to start again after download
} fc_sxm_tenDiagDownloadState;

typedef enum {
	fc_sxm_enDiagDownloadResult_Ok,
	fc_sxm_enDiagDownloadResult_Failed,
	fc_sxm_enDiagDownloadResult_FileNotFound,
	fc_sxm_enDiagDownloadResult_InvalidVersion,
	fc_sxm_enDiagDownloadResult_Abort,
    fc_sxm_enDiagDownloadResult_Busy
} fc_sxm_tenDiagDownloadResult;

// indication that a data-service could not recover from an data-base error
struct fc_sxm_trMsgDiagDownload: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DOWNLOAD);
    fc_sxm_trMsgDiagDownload(string oFileName_="", string oSwVersion_="", tBool bForced_=FALSE):
        oFileName(oFileName_),
        oSwVersion(oSwVersion_),
        bForced(bForced_)
    {};
    string oFileName;
    string oSwVersion;
    tBool bForced;

};

struct fc_sxm_trMsgDiagDlSvTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DOWNLOAD + 1);
    fc_sxm_trMsgDiagDlSvTimer(){};
};

struct fc_sxm_trMsgDiagModuleUpdateEvent: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DOWNLOAD + 2);
    fc_sxm_trMsgDiagModuleUpdateEvent(){};
};

// command to Start firmware download .Receive the trigger from FC_Diagnosis through Audio Fi
struct fc_sxm_trMsgDiagDownloadMStart: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DOWNLOAD + 3);
    fc_sxm_trMsgDiagDownloadMStart(){};

    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart oFiMsg;
};


class fc_sxm_tclDiagDownloadActivity: public fc_sxm_tclActivityBase {
 public:
    fc_sxm_tclDiagDownloadActivity()
    {
    	/*set the type to identify the activity*/
        bSetType(fc_sxm_enSystemState_DownLoad);
    }
    
    virtual tVoid vRun();


};



class fc_sxm_tclDiagDownload:
public fc_sxm_tclDiagMember,
public fc_sxm_tclSingleton<fc_sxm_tclDiagDownload>
{
 public:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagDownload>;

    // we get notified that the database of an sms-app is not ok
    //tVoid vProcess(fc_sxm_trMsgDiagDownload const *prMsg);
    tVoid vProcess(fc_sxm_trMsgDiagDownloadMStart const *prMsg);

    /*
      Supervision 
      - during download and 
      - after download to check that modules restarts with correct version 
    */
    tVoid vProcessTimer(fc_sxm_trMsgDiagDlSvTimer const *prMsg);
    

    // new state of sms-module
    tVoid vProcess(fc_sxm_trMsgAudioSmsEvtModuleState const *prMsg);


    // progress-information of download from sms
    tVoid vProcess(fc_sxm_trMsgDiagModuleUpdateEvent const *prMsg);

    // activity has stated, goto state preRun to let sms settle its state (hack)
    tVoid vPreRun();    
    // start the actual download after correct system state is reached 
    tVoid vRun();    

 private:
    fc_sxm_tclDiagDownload();
    // send progress-information to fc_download
    tVoid vSendProgress(tBool bActive,U8 u8Progress) const;
    // send result to diag-lib
    tVoid vSendResult(fc_sxm_tenDiagDownloadResult enResult) const;
    // enter new state and take actions accordingly
    tVoid vSetState(fc_sxm_tenDiagDownloadState enState, fc_sxm_tenDiagDownloadResult enResult=fc_sxm_enDiagDownloadResult_Ok);
    fc_sxm_tclDiagDownloadActivity _oDownloadActivity;
    fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgDiagDlSvTimer, fc_sxm_tclDiagDownload> _oSupervisionTimer;
    fc_sxm_tenDiagDownloadState _enState;
    fc_sxm_trMsgDiagDownload _rRequestMsg;
    fc_sxm_trAdressing m_rAdressing;

};
#endif
