/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_defset.h
* @brief       SXM Diagnosis Default settings handler.
*              Responsible for Handling the Default settings request from FC_Diagnosis and HMI.
*              Default settings include Restoring the Databases to the factory default and 
*              removing all user data.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_DEFSET_H_
#define _FC_SXM_TCL_DIAG_DEFSET_H_


#include "fc_sxm_common.h"
#include "fc_sxm_tcl_states.h"
#include "fc_sxm_diag_types.h"
#include "fc_sxm_tcl_diagtm_handler.h"

// indication that a data-service could not recover from an data-base error
struct fc_sxm_trMsgDiagSmsDbError: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET);
    fc_sxm_trMsgDiagSmsDbError(fc_sxm_tenServiceID enServiceId_=fc_sxm_enServiceID_All):
        enServiceId(enServiceId_)
    {};
    fc_sxm_tenServiceID enServiceId;

};

struct fc_sxm_trMsgDiagDbErrorDetectTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET + 1);
    fc_sxm_trMsgDiagDbErrorDetectTimer(){};

};

//struct fc_sxm_trMsgDiagRestoreSmsDb: public fc_sxm_tclMessage {
//    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET + 2);
//    fc_sxm_trMsgDiagRestoreSmsDb(fc_sxm_tenServiceID enServiceId_=fc_sxm_enServiceID_All):
//        enServiceId(enServiceId_)
//    {};
//
//    fc_sxm_tenServiceID enServiceId;
//};

typedef enum {
    fc_sxm_enDiagDefsetType_Factory,
    fc_sxm_enDiagDefsetType_User,
    fc_sxm_enDiagDefsetType_UserOld,
    fc_sxm_enDiagDefsetType_Invalid
} fc_sxm_tenDiagDefsetType;

typedef enum
    {
       fc_sxm_en_Defset_Idle,
       fc_sxm_en_PreDefset_Active,
       fc_sxm_en_Defset_Pending,
       fc_sxm_en_Defset_Done
    } fc_sxm_tenDefsetState;

struct fc_sxm_trMsgDiagDefset: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET + 3);
    fc_sxm_trMsgDiagDefset(fc_sxm_tenDiagDefsetType enType_=fc_sxm_enDiagDefsetType_Factory,
                            fc_sxm_tenDefsetState enState_ = fc_sxm_en_Defset_Idle):
        enType(enType_),enState(enState_)
    {};
    fc_sxm_tenDiagDefsetType enType;
    fc_sxm_tenDefsetState enState;
};

// command to reset SXM Database
struct fc_sxm_trMsgDiagRestoreSmsDb: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET + 4);
    fc_sxm_trMsgDiagRestoreSmsDb(){};

    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart oFiMsg;
};


class fc_sxm_tclDiagDefsetFactoryActivity: public fc_sxm_tclActivityBase {
 public:
    fc_sxm_tclDiagDefsetFactoryActivity()
    {
    	/*set the type to identify the activity*/
        bSetType(fc_sxm_enSystemState_DefsetFactory);
    }
    
    virtual tVoid vRun();
};

class fc_sxm_tclDiagDefsetUserActivity: public fc_sxm_tclActivityBase {
 public:
    fc_sxm_tclDiagDefsetUserActivity()
    {
    	/*set the type to identify the activity*/
        bSetType(fc_sxm_enSystemState_DefsetFactory);
    }
    
    virtual tVoid vRun();
};

class fc_sxm_tclDiagRestoreSmsDbActivity: public fc_sxm_tclActivityBase {
 public:
    fc_sxm_tclDiagRestoreSmsDbActivity()
    {
        bSetType(fc_sxm_enSystemState_DefsetFactory);
    }
    
    virtual tVoid vRun();
};


class fc_sxm_tclDiagDefset:
public fc_sxm_tclDiagMember,
public fc_sxm_tclSingleton<fc_sxm_tclDiagDefset>
{
 public:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagDefset>;

    ~fc_sxm_tclDiagDefset();

    // we get notified that the database of an sms-app is not ok
    tVoid vProcess(fc_sxm_trMsgDiagSmsDbError const *prMsg);
    /*
      after replacing the complete sms_hb we wait a while,
      if no error is detected until timeout,
      the sms_hb is regarded as ok.
    */
    tVoid vProcessTimer(fc_sxm_trMsgDiagDbErrorDetectTimer const *prMsg) const;
   // tVoid vProcessGenericMsg(fc_sxm_trMsgDiagDbErrorDetectTimer const *prMsg) const;
    
    /*
      we get the command to replace the data-base of one sms-app or
      of the complete sms_hb
    */
    tVoid vProcess(fc_sxm_trMsgDiagRestoreSmsDb const *prMsg);

    /*
      we received the command for a defset
      type user: apps are not stopped but each app is requested to reset user settings
      as selected channel, presets and favorites
      type factory: sms is stopped and the complete sms_hb is replaced.
    */
    tVoid vProcess(fc_sxm_trMsgDiagDefset const *prMsg);

    /*Inform about the DB restore*/
    tVoid vProcess(fc_sxm_trMsgDiagSxmDbReplaced const *prMsg);

    /*To Start the DB reset*/
   tVoid vStartDbReset(tU8 u8Service);   

   /* take actions when sms cannot be started */
   tVoid vHandleSmsInitError(SMSAPI_RETURN_CODE_ENUM eReturnCode);

    // handle result of activity
    tVoid vHandleResult(fc_sxm_tenDiagResult enResult);
    
    //Handle the DBrestore result
    tVoid vHandleDbRestoreResult();

    //Check defset state and send the result
    tVoid vHandleFactoryDefSet(fc_sxm_tenDefsetState enDefsetState=fc_sxm_en_Defset_Idle);


    fc_sxm_tenDiagDefsetType enDiagDefsetType() const
    {
        return _enDefsetType;
    }

 private:
    typedef enum {
        enSmsCfgState_OK,
        enSmsCfgState_Replaced,
        enSmsCfgState_Deleted,
        enSmsCfgState_FAILED
    } tenSmsCfgState;    

    fc_sxm_tclDiagDefset();
    fc_sxm_tclDiagDefsetFactoryActivity _oDefsetFactoryActivity;
    fc_sxm_tclDiagDefsetUserActivity _oDefsetUserActivity;
    fc_sxm_tclDiagRestoreSmsDbActivity _oRestoreSmsDbActivity;
    fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgDiagDbErrorDetectTimer, fc_sxm_tclDiagDefset> _oDbErrorDetectTimer;
    fc_sxm_tenDiagDefsetType _enDefsetType;
    tBool m_bInformHMI;
    tenSmsCfgState _enSmsCfgState;
    fc_sxm_tenDefsetState m_enDefsetState;
    fc_sxm_trAdressing m_rAdressing;
};

class fc_sxm_tclSmsDirRestorer:
    public fc_sxm_tclSingleton<fc_sxm_tclSmsDirRestorer>
{

    friend class fc_sxm_tclSingleton<fc_sxm_tclSmsDirRestorer>;
public:
    fc_sxm_tclSmsDirRestorer() {
    	_bSync=FALSE;
        _oSem.vOpen();
    }
    ~fc_sxm_tclSmsDirRestorer() {
        _oSem.vClose();
    }

    /* if marker exist, some replace-actions has not finished gracefully before shutdown.
       we have to replace the whole sms_hb
    */
    tVoid vStartupCheck();

    /* restore whole sms_hb or a subdirectory.
     bSync: use marker-file and sync the filesystem */
    tBool bRestore(string const &oSubDir="", tBool bSync=TRUE);

    static tBool bMarkerExists() {
        return fc_sxm_bFileExists(oGetMarkerFileName());
    }
    static tBool bSmsCfgFileExists();

    tBool bRestoreSmsCfg(tBool bForced=TRUE);
    tVoid vDeleteSmsCfg();
    tVoid vRestoreSmsHbOnNextRestart();
    tVoid vRestoreDefConfig(string const &oSubDir,string &oSrcDir, string &oDstDir) const;
    tVoid vDoRestoreFactory(string const &oSubDir,string &oSrcDir, string &oDstDir) const;
    tVoid vDoRestoreStatesFile(string const &oSubDir,string &oSrcDir, string &oDstDir) const;
    tVoid vDoRestoreFactoryMixed(string const &oSubDir,string &oSrcDir, string &oDstDir) const;

private:
    fc_sxm_tclSem _oSem;
    tBool _bSync;

    static string oGetMarkerFileName();
    static string oGetMarkerFilePath();

    tVoid vSyncFs() const;
    tVoid vSetMarker() const;
    tVoid vRemoveMarker() const;
    tVoid vSyncFileAndDir(string const &oFileNameAndPath,
                          string const &oFilePath) const;
    tVoid vExecuteCmd(char **argv) const;
    tVoid vParseCmd(char *argPath,char **argV) const;
    tVoid vExecvpCmd(string &cmd) const;
    tVoid vRemove(string &cmd) const;
    tVoid vDoRestoreSpecificDb(string const &oSubDir,
            string &oSrcDir, string &oDstDir) const;
    tVoid vDoRestoreSdkDb(string const &oSubDir) const;
    tVoid vDoRestoreSdkService(string const &oSubDir) const;
    tBool bRemoveDirFiles(string const &oDir) const;
    tVoid vClearChannelArt() const;

};

#endif
