/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diag_types.h
* @brief       Declarations of user defined data types used within Diagnosis. 
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_TYPES_H_
#define _FC_SXM_TCL_DIAG_TYPES_H_

#include "fc_sxm_audio_types.h"
/*
  Possible result of an app
*/
typedef enum {
    fc_sxm_enDiagResult_Pending,
    fc_sxm_enDiagResult_NoAction,
    fc_sxm_enDiagResult_Ok,
    fc_sxm_enDiagResult_Failed
} fc_sxm_tenDiagResult;




class fc_sxm_tclDiagMember {
 public:
    virtual ~fc_sxm_tclDiagMember() {};
};



#define FC_SXM_AUDIO_ACTION_BASE_DIAG_TM           ( FC_SXM_AUDIO_ACTION_BASE_DIAG +90 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_CLEAR_USER   ( FC_SXM_AUDIO_ACTION_BASE_DIAG +80 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_REPORTER     ( FC_SXM_AUDIO_ACTION_BASE_DIAG +70 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_DEFSET       ( FC_SXM_AUDIO_ACTION_BASE_DIAG +60 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_DOWNLOAD     ( FC_SXM_AUDIO_ACTION_BASE_DIAG +50 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_LOG          ( FC_SXM_AUDIO_ACTION_BASE_DIAG +40 )
#define FC_SXM_AUDIO_ACTION_BASE_EXT_MODE          ( FC_SXM_AUDIO_ACTION_BASE_DIAG +30 )
#define FC_SXM_AUDIO_ACTION_BASE_DIAG_FOREACH      ( FC_SXM_AUDIO_ACTION_BASE_DIAG +20 )

#define FC_SXM_DB_VERSIONS_MAX_LEN 10

#define FC_SXM_DIAG_STM_MENU 1
#define FC_SXM_DIAG_SETTING_MENU 2

#define FC_SXM_DIAG_UPC_WORD 18
#define FC_SXM_DIAG_UPC_PACKAGE_ID_LIMIT 12
#define FC_SXM_DIAG_VERSION_MAX 20




#endif
