/************************************************************************
* FILE:         fc_dataservices_defines.h
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION: Component related defines 
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date       | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
*************************************************************************/

/* Trace class  defines */
#define DATASERVICES_COMP TR_COMP_FC_DATASERVICES
#include <vector>
#include <list>		
#include <queue>	
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
using namespace std;
#define TR_CLASS_DATASRVCS_SERVER_COMP            (DATASERVICES_COMP + 0x00)
#define TR_CLASS_DATASRVCS_MSG_HANDLER            (DATASERVICES_COMP + 0x01)
#define TR_CLASS_DATASRVCS_DSM_HANDLER            (DATASERVICES_COMP + 0x02)
#define TR_CLASS_DATASRVCS_DSM						(DATASERVICES_COMP + 0x03)
#define TR_CLASS_DATASRVCS_DSM_DB					(DATASERVICES_COMP + 0x04)
#define TR_CLASS_DATASRVCS_DSM_DAB_SERVICE_MANAGER	(DATASERVICES_COMP + 0x05)
#define TR_CLASS_DATASRVCS_DSM_APP					(DATASERVICES_COMP + 0x06)
#define TR_CLASS_DATASRVCS_DSM_DAB_APP				(DATASERVICES_COMP + 0x07)
#define TR_CLASS_DATASRVCS_DSM_DAB_MOT_APP			(DATASERVICES_COMP + 0x08)
#define TR_CLASS_DATASRVCS_DSM_DAB_BWS				(DATASERVICES_COMP + 0x09)
#define TR_CLASS_DATASRVCS_DSM_DAB_EPG				(DATASERVICES_COMP + 0x0a)
#define TR_CLASS_DATASRVCS_DSM_DAB_MOT				(DATASERVICES_COMP + 0x0b)
#define TR_CLASS_DATASRVCS_DSM_DAB_SLS				(DATASERVICES_COMP + 0x0c)
#define TR_CLASS_DATASRVCS_DSM_DAB_JRLN_APP			(DATASERVICES_COMP + 0x0d)
#define TR_CLASS_DATASRVCS_DSM_DAB_WIZARD			(DATASERVICES_COMP + 0x0e)
#define TR_CLASS_DATASRVCS_TRACE_HANDLER			(DATASERVICES_COMP + 0x0f)

/* Generic defines */
#define ONE						1
#define TWO						2
#define EIGHT					8

/* DSM Related defines */
#define BLOCK_SIZE				1024

#define DSM_TRIGGER_TIMEOUT		2000
#define SEC_TO_MSEC_CONV_FACTOR 1000

#define DEFAULT_OBJECT_WIDTH	128
#define DEFAULT_OBJECT_HEIGHT	128
#define DEFAULT_OBJECT_TYPE		4

#define FILE_NAME_LENGTH		200
#define USERAPP_SLS				1
#define USERAPP_BWS				2
#define USERAPP_EPG				4
#define QUERY_SINGLELOGO		1
#define QUERY_ALLLOGOS			2
#define LOGO_UNRESTRICTED		1
#define LOGO_RECTANGLE			2
#define LOGO_SQUARE				3
#define LOGO_SQUARE_WIDTH			32
#define LOGO_SQUARE_HEIGHT			32
#define LOGO_RECTANGLE_WIDTH		112
#define LOGO_RECTANGLE_HEIGHT		32
#define LOGO_UNRESTRICTED_WIDTH		128
#define LOGO_UNRESTRICTED_HEIGHT	128
#define MAX_NUM_OF_LOGOS 255
#ifndef ENUMS
#define ENUMS
typedef enum {
    SLIDE_STATE_CLEAR = 0x00,
    SLIDE_STATE_SHOW  = 0x01
} Dataservices_tenSlideState;

typedef enum {
    DSM_ACTION_CALL_VHANDLE = 0x00,
    DSM_ACTION_CALL_VHANDLEMECARESPONSE  = 0x01,
	DSM_ACTION_NONE = 0x02
} DSM_tenAction;
typedef enum {
	MESSAGE_INPUT_DSM = 0X00,
	MESSAGE_TIMER_EVENT_DSM  = 0X01,
	MESSAGE_CLOSE_DB  = 0X02,
	MESSAGE_INVALID = 0x03
} tenMessageType;
#define GET_U32_VALUE(pu8) ((tU32)(((tU32)((pu8)[0])<<24) + ((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))

struct ADRMessage{
	tenMessageType enMsgType;
	tU16 u16FktId;
	tU32 u32MsgLength;
	tPU8 pu8MsgData;
	tVoid vSetData(vector<tU8> vectorData){
		enMsgType = MESSAGE_INPUT_DSM;
		tU32 u32Length = (tU32)(vectorData.size());
		pu8MsgData = OSAL_NEW tU8[u32Length];
		if(pu8MsgData != NULL){
			memcpy ( &pu8MsgData[0], &vectorData[0], u32Length );}

	}
	ADRMessage():	
	enMsgType(MESSAGE_INVALID),
		u16FktId(0),
		u32MsgLength(0),
		pu8MsgData(NULL){						 

	}

	ADRMessage( const ADRMessage  &b){
		u16FktId = b.u16FktId;
		u32MsgLength = b.u32MsgLength;
		enMsgType = b.enMsgType;
		pu8MsgData = NULL;
		if(u32MsgLength>0)
		{
			pu8MsgData = OSAL_NEW tU8[u32MsgLength];
			if(pu8MsgData != NULL){
				memcpy(pu8MsgData,b.pu8MsgData,u32MsgLength);}
		}
	}

	ADRMessage operator=( ADRMessage const &b) 
	{
		ADRMessage message;
		message.u16FktId = b.u16FktId;
		message.u32MsgLength = b.u32MsgLength;
		message.enMsgType = b.enMsgType;
		message.pu8MsgData = NULL;
		if(message.u32MsgLength>0)
		{
			message.pu8MsgData = OSAL_NEW tU8[u32MsgLength];
			if(message.pu8MsgData != NULL){
				memcpy(message.pu8MsgData,b.pu8MsgData,message.u32MsgLength);}
		}
		return message;
	}

	~ADRMessage ()
	{			
		if (OSAL_NULL != pu8MsgData) {
			OSAL_DELETE[] pu8MsgData;
			pu8MsgData = OSAL_NULL;
		}
	}

	/*	ADRMessage& operator=(ADRMessage const &b) 
	{		
	if (this == &b)  {
	return *this; 
	}
	u16FktId = b.u16FktId;
	u32MsgLength = b.u32MsgLength;
	pu8MsgData = b.pu8MsgData;
	return *this; 
	}*/

};


template <typename C>
class DAB_Singleton {
public:
	static C* instance ()
	{
		if (!_instance) {
			_instance = OSAL_NEW C;
		}
		return _instance;
	}
	virtual
		~DAB_Singleton ()
	{
		_instance = 0;
	}
private:
	//lint -esym(1704, DAB_Singleton*::DAB_Singleton*) prio3 constructor has private access specification
	DAB_Singleton(const DAB_Singleton<C>&);	
	DAB_Singleton& operator=(const DAB_Singleton<C>&);
	static C* _instance;
protected:
	DAB_Singleton () { }
};
template <typename C> C* DAB_Singleton <C>::_instance = 0;
#endif
