/************************************************************************
* FILE:         fc_dataservices_DSMHandler.h
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION: Handler for sending/receiving messages/commands to/from
*			   DSM
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
* 13.07.2015 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | Added 
* tclDispatcher class
*************************************************************************/
#ifndef _FC_DATASERVICES_DSMHANDLER_H_
#define _FC_DATASERVICES_DSMHANDLER_H_


#include "tclDSM.h"

#include "com/dab/MIDW_EXT_DABTUNER_FIProxy.h"
#include "com/dab/MIDW_EXT_DABTUNER_FI.h"

//#include "fc_dataservices_trace.h"

#include "fc_dataservices_defines.h"

using namespace dsm;
using namespace AaRSLib;
using namespace AaRSLib::MSG;
using namespace AaRSDABLib;
using namespace AaRSDABLib::API;

namespace fc_dataservices { namespace Server {

	class fc_dataservices_DSMHandler;
	
	class tclMyDSMListenerImpl : public tclDSMEventListener
	{

	public:
		tclMyDSMListenerImpl(fc_dataservices_DSMHandler *pDSMHandler){
			m_pDSMHandler =pDSMHandler;
		}		
		
		tU64 u64ElapsedTimeMS();
		tVoid vDSMEvent( tDSMEvent ev, std::string uri );

			fc_dataservices_DSMHandler* m_pDSMHandler;			
	};

	class tclMyDSMTimeProvider : public tclDSMTimeProvider
	{

	public:
		tclMyDSMTimeProvider(fc_dataservices_DSMHandler *pDSMHandler){
			m_pDSMHandler =pDSMHandler;
		}		
		tU64 u64DSMGetUTCmS();
		fc_dataservices_DSMHandler* m_pDSMHandler;
	};

	class tclDSMServiceManagerCommandReceiver : public tclDABServiceManagerCommandReceiver
	{
	public:

		tVoid vSendDSMMeCaCommand( tU8 u8TunerIdx, AaRSLib::MSG::tCommandMessage rMsg);
		tBool bDABClientAvailable;
	};

	class tclDispatcher:
		public DAB_Singleton<tclDispatcher>{
public:
	tVoid vStartDispatcherThread();
	~tclDispatcher();
	
	static tVoid* vDispatcherThread(tVoid *pvArg);
	
	pthread_t       m_hDispatcherThreadId;  
	static tBool	m_DSMBusy;
	static tBool	m_TriggerDSM;

	static pthread_cond_t m_rCondition;

	static pthread_mutex_t m_hMutex;

	static queue<ADRMessage> m_rQueue;	
	
};

	class fc_dataservices_DSMHandler:
		public DAB_Singleton<fc_dataservices_DSMHandler>{
	public:
		fc_dataservices_DSMHandler();
		~fc_dataservices_DSMHandler();			

		tVoid vonAskLogosByUri(std::string sUri);

		tVoid vonAskLogoBySId( tU32 u32ServiceId );

		tVoid vExtractSlide(std::string sUri, 
			Dataservices_tenSlideState enSlideState);

		tVoid vSetImageSize(tU8 u8LogoType);

	
		tVoid vSetDSMAction(DSM_tenAction tenAction){
			m_enAction = tenAction;
		}	

		tVoid vEnableSLS(tBool bEnable);
		tVoid vEnableEPG(tBool bEnable);
		tVoid vEnableBWS(tBool bEnable) const{(tVoid)bEnable;};

		tVoid vStoreLogoToFFS(tU32 u32ServiceId,
			tU32 u32Length,
			tU8 u8QyeryType,
			tVoid* pData);

		tU8 u8GetFileCount();
		tVoid vDeleteLogos();

		tVoid vSendMessagetoDSM(ADRMessage &rMsg);
		
		tU8 u8GetSupportedUserApps(tU32 u32ServiceId);

		tU32 u32GetLogoWidth(){
			return m_u32LogoWidth;}

		tU32 u32GetLogoHeight(){
			return m_u32LogoHeight;}

		tU32 u32GetCurrentSID(){
			return m_u32CurrentSID; }

		tVoid vGetEPG(tU32 u32SID, tU8 U8PrevCount, tU8 U8NextCount);
		tVoid vSetDABClientAvailability(tBool bAvailable){
			m_rCmndRecvr.bDABClientAvailable = bAvailable;
		}
		tVoid vStartDSMTriggerTimer();
		tVoid vStopDSMTriggerTimer();
		tVoid vSetDBstatus(tBool bStatus){bDBOpen=bStatus; }		
		tBool bGetDispatcherStatus(){ return bDispatcherRunning;}
		tVoid vSetDispatcherStatus(tBool val){ bDispatcherRunning = val;}
		static tclDSM* m_pDSM ;
		tVoid vTriggerSlideUpdate(Dataservices_tenSlideState enSlideState);

		tS64 getLocalOffset(){return m_localTimeOffset;}
		tVoid setLocalTimeOffset( tS64 offset){
			m_localTimeOffset = offset;
		}
		tBool m_bSLSEnabled;
		tBool m_bEPGEnabled;
		tBool m_bBWSEnabled;		
		
		vector< ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement> m_LogoList;
		string m_sLinkInfo;	

		tU64 m_u64SystemStartupTime;
		tU64 m_u64AppTime;
		tBool bDBOpen;
		tBool bDispatcherRunning;
	private:		
		OSAL_tTimerHandle m_hDSMTriggerTimer;
		tclDSMServiceManagerCommandReceiver m_rCmndRecvr;
		tclMyDSMTimeProvider *m_ptimeProvider ;
		tclMyDSMListenerImpl *m_plistener ;
	

		//fc_dataservices_trace* m_pTraceHandler;

		static OSAL_tpfCallback vCallbackDSMTriggerTimeOut(tVoid* pArg);

		list<tU16> m_ActiveAppList_SLS;	

		list<tU16> m_ActiveAppList_EPG;	

		static DSM_tenAction m_enAction;    

		tU32 m_u32LogoWidth;
		tU32 m_u32LogoHeight;

		tU8 m_u8UserAppsSupported;
		tU32 m_u32CurrentSID;
		
		tS64 m_localTimeOffset;

	};
}}
#endif
