/************************************************************************
* FILE:         fc_dataservices_DSMHandler.cpp
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION: Handler for sending/receiving messages/commands to/from
*			   DSM
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
*************************************************************************/

#include "fc_dataservices_DSMHandler.h"
#include "fc_dataservices_DABClientHandler.h"
#include "fc_dataservices_DBusStub.h"

#include "time.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DATASRVCS_DSM_HANDLER
#include "trcGenProj/Header/fc_dataservices_DSMHandler.cpp.trc.h"
#endif

#include <glob.h>
#include <dirent.h>
 
namespace fc_dataservices { namespace Server {	

	tclDSM* fc_dataservices::Server::fc_dataservices_DSMHandler::m_pDSM = NULL;
	pthread_cond_t fc_dataservices::Server::tclDispatcher::m_rCondition =PTHREAD_COND_INITIALIZER;
	pthread_mutex_t fc_dataservices::Server::tclDispatcher::m_hMutex=PTHREAD_MUTEX_INITIALIZER;   
	queue<ADRMessage> fc_dataservices::Server::tclDispatcher::m_rQueue;
	tBool	fc_dataservices::Server::tclDispatcher::m_DSMBusy=FALSE;
	tBool	fc_dataservices::Server::tclDispatcher::m_TriggerDSM=FALSE;
    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::fc_dataservices_DSMHandler 
    *
    * DESCRIPTION: Constructor.
    *			   Creates DSM object, sets DSM command receiver and DSM parameters
    *			   Creates DSM trigger timer, opens semaphore
    *
    * PARAMETER: fc_dataservices_MessageHandler*
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    fc_dataservices_DSMHandler::fc_dataservices_DSMHandler():    
    m_hDSMTriggerTimer(OSAL_C_INVALID_HANDLE) ,
    m_rCmndRecvr(),
	m_ptimeProvider(OSAL_NULL),
	m_plistener(OSAL_NULL) {

    	m_ptimeProvider = new tclMyDSMTimeProvider(this);
    	m_plistener = new tclMyDSMListenerImpl(this);
    m_pDSM = new tclDSM(m_ptimeProvider, m_plistener);
   /* m_pTraceHandler = new fc_dataservices_trace();
    if(m_pTraceHandler != OSAL_NULL)
    {
        m_pTraceHandler->vRegisterTraceService(this);
    }*/
    
    m_bSLSEnabled = TRUE;
    m_bEPGEnabled = TRUE;
    m_bBWSEnabled = FALSE;
    m_u64SystemStartupTime = 0;
    m_u64AppTime = 0;
	bDBOpen =FALSE;
    m_u32LogoWidth  = DEFAULT_OBJECT_WIDTH;
    m_u32LogoHeight = DEFAULT_OBJECT_HEIGHT;
    m_u8UserAppsSupported = 0;
    m_u32CurrentSID = 0;	
	m_localTimeOffset = 0;
	bDispatcherRunning = FALSE;
	m_rCmndRecvr.bDABClientAvailable = FALSE;
    if((m_pDSM != OSAL_NULL)&&		
        (m_pDSM->oDAB() != OSAL_NULL)){

            m_pDSM->oDAB()->vSetCommandReceiver(&m_rCmndRecvr);	
            
             time_t  rTime= time(OSAL_NULL);
            m_u64SystemStartupTime =rTime;

            m_pDSM->oDB()->bOpen("/tmp/dsmdb.sqlite3",(6*BLOCK_SIZE*BLOCK_SIZE),false);
			bDBOpen = TRUE;
			m_pDSM->oDAB()->vSetNumTuner(1);
			m_pDSM->oDAB()->vSetDecodingCapability(0,TWO,TWO);

			/*Start of Temporary code to be removed*/
			m_ActiveAppList_EPG.push_back(DAB_SERVICE_MANAGER_UAPPTYPE_EPG);	

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			m_ActiveAppList_SLS.push_back(DAB_SERVICE_MANAGER_UAPPTYPE_SLS);

			/*m_pDSM->oDAB()->vSetDecodingStrategy(0,
				m_ActiveAppList_SLS,
				DAB_SERVICE_MANAGER_STRATEGY__CURRENT_SERVICE_COMPONENT);*/
			m_pDSM->oDAB()->vSetDecodingStrategy(0,
				m_ActiveAppList_SLS,
				DAB_SERVICE_MANAGER_STRATEGY__CURRENT_SERVICE);
#endif

            m_pDSM->oDAB()->vSetDecodingStrategy(0,
                m_ActiveAppList_EPG,
                DAB_SERVICE_MANAGER_STRATEGY__CURRENT_ENSEMBLE);
          
            /*End of Temporary code to be removed*/


		if(OSAL_ERROR  == OSAL_s32TimerCreate((OSAL_tpfCallback)vCallbackDSMTriggerTimeOut, 
				(tPVoid)this,
				&m_hDSMTriggerTimer)){
					ETG_TRACE_FATAL(("fc_dataservices_DSMHandler OSAL_s32TimerCreate (%s) ERROR", "DSMSem"));
					m_hDSMTriggerTimer = OSAL_C_INVALID_HANDLE;	

            }			

            m_pDSM->oDAB()->vHandle();          			
        }
    }

    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::~fc_dataservices_DSMHandler 
    *
    * DESCRIPTION: Destructor.
    *			   deletes DSM object,deletes DSM trigger timer,closes semaphore
    *
    * PARAMETER: fc_dataservices_MessageHandler*
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    fc_dataservices_DSMHandler::~fc_dataservices_DSMHandler(){
		ETG_TRACE_USR4((" ~fc_dataservices_DSMHandler"));		
        if(OSAL_NULL !=m_pDSM)
        {
            OSAL_DELETE m_pDSM;
            m_pDSM=OSAL_NULL;
        }

        if(OSAL_NULL !=m_ptimeProvider)
               {
                   OSAL_DELETE m_ptimeProvider;
                   m_ptimeProvider=OSAL_NULL;
               }
        if(OSAL_NULL !=m_plistener)
               {
                   OSAL_DELETE m_plistener;
                   m_plistener=OSAL_NULL;
               }
        m_LogoList.clear();
        /*if(OSAL_NULL !=m_pTraceHandler)
        {
            OSAL_DELETE m_pTraceHandler;
            m_pTraceHandler=OSAL_NULL;
        }*/
        if(OSAL_C_INVALID_HANDLE != m_hDSMTriggerTimer)
        {
            (tVoid)OSAL_s32TimerDelete(m_hDSMTriggerTimer);
            m_hDSMTriggerTimer=OSAL_C_INVALID_HANDLE;
        }
		ETG_TRACE_USR4((" END ~fc_dataservices_DSMHandler"));
    }	

   

    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::vSendMessagetoDSM 
    *
    * DESCRIPTION: forwards messages to DSM
    *
    * PARAMETER: None
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    
    tVoid fc_dataservices_DSMHandler::vSendMessagetoDSM( ADRMessage &rMsg){
    
         if((rMsg.u16FktId ==0) ||(rMsg.u32MsgLength ==0) ||(rMsg.pu8MsgData ==0 ))
		 {
			 ETG_TRACE_USR4(("vSendMessagetoDSM :Skipping invalid Message"));
			 ETG_TRACE_ERRMEM(("vSendMessagetoDSM :Skipping invalid Message"));
			 return ; 
		 }
            tMessage* pMsg = tMsgDispatcher::fromByteArray(rMsg.u16FktId,
                    rMsg.u32MsgLength,
                    rMsg.pu8MsgData);
		if(pMsg!= NULL){
                m_pDSM->oDAB()->vHandleMeCaResponse(0,*pMsg);
                delete pMsg; 
		}
    
    }
    /******************************************************************************
    *
    * FUNCTION: tclDSMServiceManagerCommandReceiver::vSendDSMMeCaCommand
    *
    * DESCRIPTION: Sends DSM command/request to MessageHandler
    *
    * PARAMETER: u8TunerIdx,AaRSLib::MSG::tCommandMessage 

	*
	* RETURNVALUE: tVoid
	*
	*******************************************************************************/
	tVoid tclDSMServiceManagerCommandReceiver::vSendDSMMeCaCommand( tU8 u8TunerIdx, AaRSLib::MSG::tCommandMessage rMsg) 
	{ 
		ETG_TRACE_USR4(("vSendDSMMeCaCommand  TunerIndex %d  MsgLength %d MsgOpcode %x ",u8TunerIdx,rMsg.size(),rMsg.opcode()));


		vector<tU8> u8VectorData;		

		tU32 u32MsgLength= rMsg.size();

		for(tU32 u32Index=0; u32Index<u32MsgLength;u32Index++)
		{		
			tU8 u8Data=rMsg.get_tU8( u32Index);
			u8VectorData.push_back(u8Data);		
		}

		::com::dab::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg rDSMMsg;
		rDSMMsg.setU16FktID(rMsg.opcode());
		rDSMMsg.setMsgData(u8VectorData);
		/*MECA commands cannot be sent until startup sequence is finished*/
		if(bDABClientAvailable){
		fc_dataservices_DABClientHandler::instance()->vonDSMMessage(rDSMMsg);
		}
	


	}

	/******************************************************************************
	*
	* FUNCTION: tclMyDSMListenerImpl::u64ElapsedTimeMS 
	*
	* DESCRIPTION: Gives elapsed time since Epoch
	*
	* PARAMETER: None

    *
    * RETURNVALUE: tU64 - returns elapsed time since Epoch
    *
    *******************************************************************************/
    tU64 tclMyDSMTimeProvider::u64DSMGetUTCmS()
    {
        time_t  rTime= time(OSAL_NULL);
		
		if(m_pDSMHandler->m_u64AppTime ==0){
            m_pDSMHandler->m_u64AppTime = m_pDSMHandler->m_pDSM->u64GetMaxAppHostTimestamp();
			m_pDSMHandler->m_pDSM->oDAB()->vTriggerAppCompleteEvent();
        }

		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI	 
		tU64 u64Time =rTime;
		#else      
        /*tU64 u64DABAppime = m_pDSMHandler->m_pDSM->u64GetMaxAppHostTimestamp();*/
        tU64 u64Time =(rTime-m_pDSMHandler->m_u64SystemStartupTime)+m_pDSMHandler->m_u64AppTime;
		#endif

         //ETG_TRACE_USR1(("SystemTime=%ld m_u64SystemStartupTime=%ld u64DABAppTime=%ld",(long)rTime ,(long)m_pDSMHandler->m_u64SystemStartupTime, (long)m_pDSMHandler->m_u64AppTime));
         //ETG_TRACE_USR1(("SystemTime=%ld m_u64SystemStartupTime=%ld u64DABAppTime=%ld",(long)rTime ,(long)m_pDSMHandler->m_u64SystemStartupTime, (long)m_pDSMHandler->m_u64AppTime));
          

        u64Time=u64Time*SEC_TO_MSEC_CONV_FACTOR;

       return u64Time;
    }

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vCallbackDSMTriggerTimeOut
	*
	* DESCRIPTION: Timeout function for DSM trigger timer.triggers DSM for 
	*			   every 1 sec
	*
	* PARAMETER:  tVoid*

	*
	* RETURNVALUE: OSAL_tpfCallback
	*
	*******************************************************************************/
	OSAL_tpfCallback fc_dataservices_DSMHandler::vCallbackDSMTriggerTimeOut(tVoid* pArg) 
	{
		(tVoid)pArg;
         ETG_TRACE_USR1(("vCallbackDSMTriggerTimeOut "));
		 tclDispatcher* m_pDispatcher= tclDispatcher::instance();
		 fc_dataservices_DABClientHandler* m_pDABClientHandler = fc_dataservices_DABClientHandler::instance();
        if((m_pDispatcher!= OSAL_NULL)&&(m_pDABClientHandler != NULL)){
            
		ETG_TRACE_USR1(("vCallbackDSMTriggerTimeOut msgInProcess %d ",m_pDABClientHandler->bMsgInProcess ));
			if((m_pDABClientHandler->bMsgInProcess)||(m_pDispatcher->m_DSMBusy)){
				return OSAL_NULL;
			}
   		
		int a = 0;
         a = pthread_mutex_lock (&m_pDispatcher->m_hMutex);	
		 (tVoid)a;
		if((!m_pDABClientHandler->bMsgInProcess)&&(!m_pDispatcher->m_DSMBusy)){			
			m_pDispatcher->m_TriggerDSM = TRUE;
			 ETG_TRACE_USR4((" vCallbackDSMTriggerTimeOut m_TriggerDSM %d",m_pDispatcher->m_TriggerDSM));					 	
			 int rc = pthread_cond_signal (&(m_pDispatcher->m_rCondition));
			 ETG_TRACE_USR4((" Cond signal Result %d",rc ));		
		}
		else{
			ETG_TRACE_USR4((" Skipped Timer message"));		
		}
		 pthread_mutex_unlock (&m_pDispatcher->m_hMutex);
                
        }
        return OSAL_NULL;
    }

	/******************************************************************************
	*
	* FUNCTION: tclMyDSMListenerImpl::vDSMEvent 
	*
	* DESCRIPTION: Gives pplication decoding status
	*
	* PARAMETER: tDSMEvent ev,std::string sUri 

    *
    * RETURNVALUE: tVoid
    *
    *******************************************************************************/
    tVoid tclMyDSMListenerImpl::vDSMEvent( tDSMEvent eEv, std::string sUri )
    {
        (tVoid)sUri;
        /*
        * process DSM event if needed for application
        */	
        
        ETG_TRACE_USR4((" vHandleEvent  %d %s",(tU8)eEv,sUri.c_str()));
        switch(eEv)
        {
        case DSM_EV_APPLICATION_STARTED:
            break;
        case DSM_EV_APPLICATION_STOPPED:
            break;
        case DSM_EV_APPLICATION_CANCELED:
            break;		
		case DSM_EV_APPLICATION_ERROR:
		case DSM_EV_APPLICATION_EPG_OBJECT_DECODED:
		case DSM_EV_APPLICATION_ALLREADY_COMPLETE:
        case DSM_EV_APPLICATION_OBJECT_COMPLETE:		    
            //m_pDSMHandler->vonAskLogoBySId(1,0x01e0d210);
        
            break;
        case DSM_EV_APPLICATION_COMPLETE:
                /*m_pDSMHandler->vonAskLogoBySId(0x01e0d210);
                m_pDSMHandler->vonAskLogoBySId(0x01e0d220);
                m_pDSMHandler->vonAskLogoBySId(0x01e0d230);*/
				if(m_pDSMHandler->bDBOpen){
                m_pDSMHandler->vonAskLogosByUri(sUri);
				}
    
            break;
        case DSM_EV_APPLICATION_SLS_UPDATE:
            if(m_pDSMHandler->m_bSLSEnabled){
                m_pDSMHandler->vExtractSlide(sUri,SLIDE_STATE_SHOW);
            }
            break;
        case DSM_EV_APPLICATION_SLS_CLEAR:
            {
                if(m_pDSMHandler->m_bSLSEnabled){
                m_pDSMHandler->vExtractSlide(sUri,SLIDE_STATE_CLEAR);
            }
            }
            break;
        }
    }

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vonAskLogosByUri 
	*
	* DESCRIPTION: Asks DSM for logos of a uri
	*
	* PARAMETER: std::string

	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vonAskLogosByUri(std::string sUri){

        ETG_TRACE_USR4(("vonAskLogosByUri"));					
        sqlite3_stmt* pContentIdStmt = NULL;
        vector<tU8> resContentId;
        std::string resMimeType = "";
        vector<tU8> resFileBody;
        tU8 M_type = DEFAULT_OBJECT_TYPE;
        tU32 M_width = m_u32LogoWidth;
        tU32 M_height = m_u32LogoHeight;
        if((m_pDSM != OSAL_NULL)&&		
            (m_pDSM->oDAB() != OSAL_NULL)){
                while( TRUE == m_pDSM->oDAB()->bGetMultimediaObjects(resContentId,
                    resMimeType,
                    resFileBody,
                    sUri.c_str(),
                    &pContentIdStmt,
                    &M_type,
                    &M_width,
                    &M_height) )
                {
                    const char* mime = resMimeType.c_str();
                    int n = (int)(resFileBody.size());

					ETG_TRACE_USR4(("resContentId %x %x %x %x %x ",resContentId[0] ,resContentId[1],resContentId[2] ,resContentId[3] ,resContentId[4]  ));
					tU32 u32ECC = (resContentId[1]<<16);
					ETG_TRACE_USR4(("ECC %x ",u32ECC));
					tU32 u32ServiceId =(u32ECC |(resContentId[4]<<8));
					ETG_TRACE_USR4(("ECC +SID %x ",u32ServiceId));
						u32ServiceId |=resContentId[5];					
				
					vStoreLogoToFFS(u32ServiceId,
							(tU32)(resFileBody.size()),
							QUERY_ALLLOGOS,
							&resFileBody[0]);
					

					ETG_TRACE_USR4(("found EPGStationLogo M_type=%d,M_width=%d,M_height=%d,strlen(M_FileBody)=%d,ServiceId =%x,M_MimeType=%s\n",
						M_type,
						M_width,
						M_height,
						n,
						u32ServiceId,
						mime));					
				}

				m_pDSM->oDB()->dbReset(pContentIdStmt);
				vector<tclDABServiceManager::tEPGContentIdDataType> m_DSList;
				#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI				
				m_pDSM->oDAB()->u32GetEPGScheduleInfoContentIds(m_DSList);
				 fc_dataservices_DBusStub::instance()->vUpdateContentid(m_DSList);
				#endif
				fc_dataservices_DABClientHandler::instance()->vUpdateStationLogoList(m_LogoList,m_DSList);
		}

	}	

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vonAskLogoBySId 
	*
	* DESCRIPTION: Asks DSM for logo of a service
	*
	* PARAMETER: u8ServiceType,u32ServiceId

	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vonAskLogoBySId(tU32 u32ServiceId){

            tU32 service_multimedia_object_bytes = 0;
            tU32 multimedia_object_w = m_u32LogoWidth; /* enter prefered width here */
            tU32 multimedia_object_h = m_u32LogoHeight; /* enter prefered height here */
            tU8  multimedia_type = DEFAULT_OBJECT_TYPE;

			if((m_pDSM != OSAL_NULL)&&		
				(m_pDSM->oDAB() != OSAL_NULL)){

					ETG_TRACE_FATAL(("fc_dataservices_DSMHandler vonAskLogoBySId Logo for ServiceId %x",u32ServiceId ));

					char* service_multimedia_object = (char*)m_pDSM->oDAB()->
						bGetMultimediaObject(&service_multimedia_object_bytes,
						0, /* optional r_ensemble */
						1,
						u32ServiceId,
						0xff, /* optional b_scids */
						0, /* optional xpad app type */
						&multimedia_type, /* EPG object type */
						&multimedia_object_w,
						&multimedia_object_h,
						0 /* optional: "image/png" */ );

					if((service_multimedia_object != OSAL_NULL )&&(service_multimedia_object_bytes != 0))
					{
						/*
						* show the image stored in service_multimedia_object
						*/
						ETG_TRACE_USR4(("Image is Available "));

						vStoreLogoToFFS(u32ServiceId,
							service_multimedia_object_bytes,
							QUERY_SINGLELOGO,
							service_multimedia_object);

                       fc_dataservices_DBusStub::instance()->vUpdateStationLogo(u32ServiceId,
                            m_sLinkInfo);
                        
                        sqlite3_free(service_multimedia_object);
                    }
            }
    }

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vStoreLogoToFFS 
	*
	* DESCRIPTION: Stores logo to FFS path
	*
	* PARAMETER: tU32 u32ServiceId,tU32 u32Length,
	*			 tU8 u8QyeryType,tVoid* pData
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vStoreLogoToFFS(tU32 u32ServiceId,
													 tU32 u32Length,
													 tU8 u8QyeryType,
													 tVoid* pData){
		FILE * pFile ;

        tChar sFileName[FILE_NAME_LENGTH];

        if(u8QyeryType == QUERY_ALLLOGOS){
            sprintf(sFileName,"/var/volatile/tmp/dab/0x%x.png",u32ServiceId);
        }
        else
        {
            sprintf(sFileName,"/var/volatile/tmp/dab/0x%x_Main.png",u32ServiceId);
        }
        
        pFile = fopen (sFileName , "wb");
        if (pFile == OSAL_NULL){	
            ETG_TRACE_USR4((" Error opening file"));
        }
        else
        {			
            tU32 u32num =(tU32)(fwrite (pData ,
                sizeof(char), 
                u32Length,
                pFile));
            fclose (pFile); // Coverity 139961

            if(u8QyeryType == QUERY_ALLLOGOS){
                ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement rElement;
                rElement.setU32ServiceID(u32ServiceId);
                rElement.setSLogoLink(sFileName);
                m_LogoList.push_back(rElement);
            }
            else
            {
                m_sLinkInfo = sFileName;
            }

			ETG_TRACE_USR4((" Image Data bytes %d written to file %s",u32num,sFileName));

			//fclose (pFile);
		}
	}

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vExtractSlide 
	*
	* DESCRIPTION: extracts slide by Uri and sends to Clients
	*
	* PARAMETER: std::string sUri, Dataservices_tenSlideState enSlideState
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/

	tVoid fc_dataservices_DSMHandler::vExtractSlide(std::string sUri,
													Dataservices_tenSlideState enSlideState){

		ETG_TRACE_USR1(("vExtractSlide sURi %s",sUri.c_str()));

		std::vector<tU8> file_body;
		if((m_pDSM != OSAL_NULL)&&		
			(m_pDSM->oDAB() != OSAL_NULL)){
				if(enSlideState==SLIDE_STATE_SHOW){
					tChar sApplication_uri[256];
					const tChar *pTransp_id_str;
					tU16 u16transp_id = 0;
					tU16 u16Application_uri_len;
					tS64 s64app_id;		

					pTransp_id_str=strstr(sUri.c_str(),"?transpid=");
					ETG_TRACE_USR1(("pTransp_id_str: %s",pTransp_id_str));

					if(pTransp_id_str!=NULL)
					{
						string s = string(pTransp_id_str+10);
						u16transp_id = (tU16)(stoi(s,NULL,16));
						ETG_TRACE_USR1(("transpid %x",u16transp_id));

						// /*get the transport id from the uri*/
						// if (1==sscanf(pTransp_id_str+10,"%u",&u16transp_id))
						// {
							/*get the uri of the application*/
							u16Application_uri_len=(tU16)(sUri.length()-16);
							strncpy(sApplication_uri,sUri.c_str(),u16Application_uri_len);
							sApplication_uri[u16Application_uri_len]=0;


							ETG_TRACE_USR1(("vExtractSlide sApplication_uri %s",sApplication_uri));
						// }
						// else
						// {
							// ETG_TRACE_USR1(("vExtractSlide TransPid Error"));
							// /*error*/
							// return;
						// }
					}
					else
					{
						/*error*/
						ETG_TRACE_USR1(("vExtractSlide TransPid Not found"));
						return;
					}




					/*get the image from the SQLite*/
					s64app_id = m_pDSM->oDAB()->s64GetAppId(sApplication_uri);

					ETG_TRACE_USR1(("vExtractSlide AppId %x transpid %x",s64app_id,u16transp_id ));

					if (TRUE==m_pDSM->oDAB()->bGetFileBody( s64app_id, u16transp_id, file_body ))
					{
						ETG_TRACE_USR1(("vExtractSlide Slide Image found Size %d ",file_body.size()));

                    }
                }
                m_u8UserAppsSupported = m_u8UserAppsSupported | 1;
            fc_dataservices_DBusStub::instance()->vSendUserAppStatus(m_u32CurrentSID,m_u8UserAppsSupported);
             fc_dataservices_DBusStub::instance()->vUpdateSlide(file_body,enSlideState);
        }
    }
	
	tVoid fc_dataservices_DSMHandler::vTriggerSlideUpdate(Dataservices_tenSlideState enSlideState){
		std::vector<tU8> file_body;
		fc_dataservices_DBusStub::instance()->vUpdateSlide(file_body,enSlideState);
	}

    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::vEnableSLS 
    *
    * DESCRIPTION: enables decoding of SLS in DSM
    *
    * PARAMETER: tbool
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    tVoid fc_dataservices_DSMHandler::vEnableSLS(tBool bEnable){
        m_bSLSEnabled = bEnable;

#ifdef SLS_ACTIVE
		if((m_bSLSEnabled)&&
			(m_pDSM != OSAL_NULL)&&		
			(m_pDSM->oDAB() != OSAL_NULL)){
				m_ActiveAppList_SLS.push_back(DAB_SERVICE_MANAGER_UAPPTYPE_SLS);

				m_pDSM->oDAB()->vSetDecodingStrategy(0,
					m_ActiveAppList_SLS,
					DAB_SERVICE_MANAGER_STRATEGY__CURRENT_SERVICE_COMPONENT);
				m_pDSM->oDAB()->vSetDecodingStrategy(0,
					m_ActiveAppList_SLS,
					DAB_SERVICE_MANAGER_STRATEGY__CURRENT_SERVICE);
		}
#endif
        }

    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::vEnableEPG 
    *
    * DESCRIPTION: enables decoding of epg in DSM
    *
    * PARAMETER: tbool
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    tVoid fc_dataservices_DSMHandler::vEnableEPG(tBool bEnable){
        m_bEPGEnabled = bEnable;
        
        if((m_bEPGEnabled)&&
            (m_pDSM != OSAL_NULL)&&		
            (m_pDSM->oDAB() != OSAL_NULL)){
        m_ActiveAppList_EPG.push_back(DAB_SERVICE_MANAGER_UAPPTYPE_EPG);

		m_pDSM->oDAB()->vSetDecodingStrategy(0,
			m_ActiveAppList_EPG,
			DAB_SERVICE_MANAGER_STRATEGY__CURRENT_ENSEMBLE);
		m_pDSM->oDAB()->vSetDecodingStrategy(0,
			m_ActiveAppList_EPG,
			DAB_SERVICE_MANAGER_STRATEGY__OTHER_ENSEMBLE);
		}

	}

	/******************************************************************************
	*
	* FUNCTION: fc_dataservices_DSMHandler::vSetImageSize 
	*
	* DESCRIPTION: sets image width and height, based  on image type
	*
	* PARAMETER: tU8 
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vSetImageSize(tU8 u8LogoType){

        switch(u8LogoType){
            case LOGO_UNRESTRICTED:
                m_u32LogoWidth  = LOGO_UNRESTRICTED_WIDTH;
                m_u32LogoHeight = LOGO_UNRESTRICTED_HEIGHT;
                break;
            case LOGO_RECTANGLE:
                m_u32LogoWidth  = LOGO_RECTANGLE_WIDTH;
                m_u32LogoHeight = LOGO_RECTANGLE_HEIGHT;
                break;
            case LOGO_SQUARE:
                m_u32LogoWidth  = LOGO_SQUARE_WIDTH;
                m_u32LogoHeight = LOGO_SQUARE_HEIGHT;
                break;
            default:
                m_u32LogoWidth  = LOGO_SQUARE_WIDTH;
                m_u32LogoHeight = LOGO_SQUARE_HEIGHT;
                break;

		}
	}

    tU8 fc_dataservices_DSMHandler::u8GetFileCount(){
        glob_t gl;
        size_t num = 0;
        if(glob("/var/volatile/tmp/dab/*.png", GLOB_NOSORT, NULL, &gl) == 0)
            num = gl.gl_pathc;
        globfree(&gl);
        ETG_TRACE_USR1(("u8GetFileCount NumOfFiles %d ",num));

        return (tU8)num;
    }
    tVoid fc_dataservices_DSMHandler::vDeleteLogos(){
        struct dirent *pFile =NULL;
        DIR *pFolder;
        char sFilepath[FILE_NAME_LENGTH];
        pFolder = opendir("/var/volatile/tmp/dab/");
        while(pFile == readdir(pFolder))
        {
            if(pFile!=NULL)
            {
                sprintf(sFilepath, "%s/%s", "/var/opt/bosch/persistent/dab", pFile->d_name);
            ETG_TRACE_USR4((" vDeleteLogos deleting %s ",sFilepath));
            remove(sFilepath);
            }
        }
		if(pFolder)
		{
			closedir(pFolder);
		}
    }
    /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::u8GetSupportedUserApps 
    *
    * DESCRIPTION: gives supported user apps
    *
    * PARAMETER: tU8 
    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/

    tU8 fc_dataservices_DSMHandler::u8GetSupportedUserApps(tU32 u32ServiceId){		
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
        
        tBool bEPGAvailable = FALSE;
                
        m_u32CurrentSID = u32ServiceId;
        m_u8UserAppsSupported =0;

        /*Check EPG availability*/
        sqlite3_stmt* pStmt = NULL;
        tclDABServiceManager::tEPGContentIdDataType contentid;
        contentid.r_ensemble = 0;
        contentid.b_service_type = 1;
        contentid.r_service = u32ServiceId;
        contentid.b_scids = 0xff;
        contentid.b_xpad_app_type = 0;

		tclDABServiceManager::_tEPGScheduleInfoType_ info;		

        if((m_pDSM != OSAL_NULL)&&		
            (m_pDSM->oDAB() != OSAL_NULL)){

                bEPGAvailable = m_pDSM->oDAB()->bGetNextEPGScheduleInfos( &pStmt,
                    contentid,
                    info);
                    m_pDSM->oDB()->dbReset(pStmt);
                m_u8UserAppsSupported = bEPGAvailable?USERAPP_EPG:0;
            }
#endif
        return m_u8UserAppsSupported;
    
    }
	
	/******************************************************************************
	*
	* FUNCTION: vStartDSMTriggerTimer
	*
	* DESCRIPTION: starts DSM trigger timer
	*
	* PARAMETER: None 
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vStartDSMTriggerTimer(){
			OSAL_s32TimerSetTime(m_hDSMTriggerTimer,DSM_TRIGGER_TIMEOUT,DSM_TRIGGER_TIMEOUT);
	}
	
	/******************************************************************************
	*
	* FUNCTION: vStopDSMTriggerTimer
	*
	* DESCRIPTION: stops DSM trigger timer
	*
	* PARAMETER: None 
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vStopDSMTriggerTimer(){
			OSAL_s32TimerSetTime(m_hDSMTriggerTimer,0,0);
	}

	/******************************************************************************
	*
	* FUNCTION: vGetEPG
	*
	* DESCRIPTION: gives EPG of Particular Service
	*
	* PARAMETER: tU8 
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	tVoid fc_dataservices_DSMHandler::vGetEPG(tU32 u32SID, 
		tU8 u8PrevCount, 
		tU8 u8NextCount){
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			sqlite3_stmt* pStmt = NULL;
			tclDABServiceManager::tEPGContentIdDataType contentid;
			contentid.r_ensemble = 0;
			contentid.b_service_type = 1;
			contentid.r_service = u32SID;
			contentid.b_scids = 0xff;
			contentid.b_xpad_app_type = 0;

			tclDABServiceManager::_tEPGScheduleInfoType_ info;

			/*Extract previous info */
			tU8 u8Count = u8PrevCount;

			while(u8Count--){

                if((m_pDSM != OSAL_NULL)&&		
                    (m_pDSM->oDAB() != OSAL_NULL)&&
                    (TRUE == m_pDSM->oDAB()->bGetPrevEPGScheduleInfos( &pStmt,
                    contentid,
                    info)))
                {
                    ETG_TRACE_USR4((" vGetEPG Previous EPG is present "));
                    //ETG_TRACE_USR4((" vGetEPG Previous EPG : Short Description  %s ",info.sShortDescription.c_str()));					
                }
                else
                {
                    ETG_TRACE_USR4((" vGetEPG Previous EPG is not present "));
                }
            }
              m_pDSM->oDB()->dbReset(pStmt);
           /*Extract current info */
            u8Count = u8NextCount;		

            while(u8Count--){
                if((m_pDSM != OSAL_NULL)&&		
                    (m_pDSM->oDAB() != OSAL_NULL)&&
                    (TRUE == m_pDSM->oDAB()->bGetNextEPGScheduleInfos( &pStmt,
                    contentid,
                    info)))
                {
                    ETG_TRACE_USR4((" vGetEPG Next EPG is present "));
                   // ETG_TRACE_USR4((" vGetEPG Next EPG : Short Description  %s ",info.sShortDescription.c_str()));					
                }
                else
                {
                    ETG_TRACE_USR4((" vGetEPG Next EPG is not present "));
                }
            }
              m_pDSM->oDB()->dbReset(pStmt);
#endif
    }	
	/******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::vStartDispatcherThread 
    *
    * DESCRIPTION: creates dispatcher thread
    *
    * PARAMETER: tVoid*

    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
	tVoid tclDispatcher::vStartDispatcherThread()
	{
		tU8 result = 0;
		
		result = (tU8)(pthread_cond_init (&m_rCondition, NULL));
		ETG_TRACE_USR4((" pthread_cond_init result %d",result ));
		result = (tU8)(pthread_create (&m_hDispatcherThreadId, NULL,&vDispatcherThread, NULL));
		ETG_TRACE_USR4((" pthread_create result %d",result ));

		pthread_setname_np(m_hDispatcherThreadId, "Dispatcher");

         
	}
	
	tclDispatcher::~tclDispatcher(){
		ETG_TRACE_USR4((" ~tclDispatcher"));		
		pthread_cond_destroy(&m_rCondition);
		pthread_mutex_destroy(&m_hMutex);
			ETG_TRACE_USR4(("End ~tclDispatcher"));	
	}

	 /******************************************************************************
    *
    * FUNCTION: fc_dataservices_DSMHandler::vDispatcherThread 
    *
    * DESCRIPTION: Dispatches messages to particular handler
    *
    * PARAMETER: tVoid*

    *
    * RETURNVALUE: None.
    *
    *******************************************************************************/
    tVoid* tclDispatcher::vDispatcherThread(tVoid *pArg){
        (tVoid)pArg;
		void *returnValue = NULL;
      pthread_mutex_lock (&m_hMutex);	  
        while(1){			 
			fc_dataservices_DSMHandler::instance()->vSetDispatcherStatus(TRUE);
			ETG_TRACE_USR1(("AwaitingThread signal "));
			 tU8 result = 0;
            result = (tU8)(pthread_cond_wait (&m_rCondition, &m_hMutex)); 
			ETG_TRACE_USR1(("pthread_cond_wait %d ",result));
			 tBool bDBStatus =  fc_dataservices_DSMHandler::instance()->bDBOpen;
			 ETG_TRACE_USR1(("Thread signal reached DB status %d ",bDBStatus));
		 	m_DSMBusy = TRUE;
			 while(!m_rQueue.empty()){
				 ETG_TRACE_USR4((" sizeof queue %d",m_rQueue.size() ));
				m_DSMBusy = TRUE;
				ADRMessage rMsg(m_rQueue.front());				
				 
				if(bDBStatus){
					 switch(rMsg.enMsgType)
					 {
					 case MESSAGE_INPUT_DSM:
						 
						 fc_dataservices_DSMHandler::instance()->vSendMessagetoDSM(rMsg);
						 break;
					case MESSAGE_CLOSE_DB:
						 bDBStatus = FALSE;
						 fc_dataservices_DSMHandler::instance()->m_pDSM->oDB()->vClose();
						 break;
					 default:
						 break;
					 }
				}
				else
				{
					ETG_TRACE_USR1(("DB Closed "));
				}			
		
							
				
 	        	  m_rQueue.pop();	
				 ETG_TRACE_USR4((" popped Msg FktID sizeof queue %d QueueStatus %d",m_rQueue.size(),m_rQueue.empty() ));
			 }
			
			if(m_TriggerDSM){
			ETG_TRACE_USR4((" Triggerring DSM " ));
				m_TriggerDSM = FALSE;
				fc_dataservices_DSMHandler::instance()->m_pDSM->vHandle();
			}
			
			m_DSMBusy = FALSE;
			if(!bDBStatus)
			{				
				break;
			}
        }	
		ETG_TRACE_USR1(("Exited main while loop"));
    pthread_mutex_unlock (&m_hMutex);	
    return returnValue;
    } 
}}
