/************************************************************************
* FILE:         fc_dataservices_DBusStub.cpp
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION:  CCA, DBus Message Handler Class for 
*				fc_dataservices component
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
*************************************************************************/

#include "fc_dataservices_DBusStub.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "fc_dataservices_defines.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "time.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DATASRVCS_MSG_HANDLER
#include "trcGenProj/Header/fc_dataservices_DBusStub.cpp.trc.h"
#endif

namespace fc_dataservices { namespace Server {
/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::fc_dataservices_DBusStub 
*
* DESCRIPTION: Constructor.
*			   Creates DSM handler.
*			   Sends property Upreg for required messages to DAB
*
* PARAMETER: const ::boost::shared_ptr< asf::core::Proxy >& proxy
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_dataservices_DBusStub::fc_dataservices_DBusStub(): DataServicesStub("CommPort")   {

	ETG_TRACE_USR4((" fc_dataservices_DBusStub:"));

	m_pDSMHandler = fc_dataservices_DSMHandler::instance();
}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::~fc_dataservices_DBusStub()
*
* DESCRIPTION: Destructor.Deletes DSM handler 
*
* PARAMETER: None
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_dataservices_DBusStub::~fc_dataservices_DBusStub() {	 		
	if(OSAL_NULL !=m_pDSMHandler)
	{
		OSAL_DELETE m_pDSMHandler;
		m_pDSMHandler=OSAL_NULL;
	}
}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::onFID_DAB_S_ENABLE_USERAPPRequest
*
* DESCRIPTION: handles select user app request from clients.
*
* PARAMETER: const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPRequest >& 
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::onFID_DAB_S_ENABLE_USERAPPRequest (
	const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPRequest >& request){


		ETG_TRACE_USR4((" Received onFID_DAB_S_ENABLE_USERAPPRequest for APP %d",request->getE8UserApp()));

		tU32 u32UserApp= request->getE8UserApp();
		tBool bEnable = request->getBEnable();

		if((m_pDSMHandler != OSAL_NULL)&&
			(m_pDSMHandler->m_pDSM != OSAL_NULL)&&
			(m_pDSMHandler->m_pDSM->oDAB() != OSAL_NULL)){
				switch(u32UserApp){
				case USERAPP_SLS:
					m_pDSMHandler->vEnableSLS(bEnable);
					break;
				case USERAPP_BWS:
					m_pDSMHandler->vEnableBWS(bEnable);				
					break;
				case USERAPP_EPG:
					m_pDSMHandler->vEnableEPG(bEnable);
					break;
				default:
					m_pDSMHandler->vEnableEPG(bEnable);
					break;
				}
		}
}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::onFID_DAB_S_GET_USERAPP_EPGRequest
*
* DESCRIPTION: handles EPG data request from clients.
*
* PARAMETER: const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGRequest >& 
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::onFID_DAB_S_GET_USERAPP_EPGRequest (
	const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGRequest >& request) {


		ETG_TRACE_USR4((" Received onFID_DAB_S_GET_USERAPP_EPGRequest:"));
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		tU32 u32ServiceId=request->getU32ServiceId();
		
		
		/*FID_DAB_S_GET_USERAPP_EPGRequestRScheduleInfoConfigStruct config;
		config=request->getRScheduleInfoConfig ();*/
		tU32 u32NumOfEntries=255;

		m_pDSMHandler = fc_dataservices_DSMHandler::instance();
		ETG_TRACE_USR4(("EPG Requested for SID %x ",u32ServiceId));

		tS64 Offset=0;

		if(m_pDSMHandler != OSAL_NULL)
		{
			Offset = m_pDSMHandler->getLocalOffset();
			ETG_TRACE_USR4((" fc_dataservices_ClockClientHandler offset %u ",Offset));
	    }
			
		sqlite3_stmt* pStmt = NULL;
		tclDABServiceManager::tEPGContentIdDataType contentid = rGetContentId(u32ServiceId);
	
		
		ETG_TRACE_USR4(("rGetContentId SID %x eid %x stype %d scids %d xpadtype %d",contentid.r_service,contentid.r_ensemble,contentid.b_service_type,contentid.b_scids,contentid.b_xpad_app_type));

		tclDABServiceManager::_tEPGScheduleInfoType_ info;

		FID_DAB_S_GET_USERAPP_EPGResponseEPGServiceInfoStruct ServiceInfo;		
		vector< FID_DAB_S_GET_USERAPP_EPGResponseGroupInfoStruct > groupInfo;
		FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoStruct SchdeduleInfo;
		vector< FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct > ProgramInfoVector;
		
		 time_t  rTime= time(OSAL_NULL)+Offset;
		  ETG_TRACE_USR1(("SystemTime=%ld",(long)rTime ));

		if((m_pDSMHandler != OSAL_NULL)&&
			(m_pDSMHandler->m_pDSM != OSAL_NULL)&&
			(m_pDSMHandler->m_pDSM->oDAB() != OSAL_NULL)){
				tU8 numberOfprevEntries =3;
				FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct ProgramInfo1;
				FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct ProgramInfo2;
				FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct ProgramInfo3;
				while((numberOfprevEntries--)&&
					 (TRUE == m_pDSMHandler->m_pDSM->oDAB()->bGetPrevEPGScheduleInfos( &pStmt,
					contentid,
					info))){
					ETG_TRACE_USR4(("Getting previous schedule info %d" ,numberOfprevEntries));
						FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct ProgramInfo;
						ProgramInfo.setElem1(u32ServiceId);
						ProgramInfo.setElem2(info.sLongName);
						ProgramInfo.setElem3(info.sMediumName);
						//ProgramInfo.setElem4(info.sShortDescription);
						time_t rawtime = info.u64StartTime + Offset;
						ETG_TRACE_USR4(("Time %ld" ,info.u64StartTime+Offset));
						struct tm *parsedTime;
						parsedTime = localtime(&rawtime);
						FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Elem6Struct EPGprogramtime;
						FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Elem6Elem1Struct ScopeTime;
						ScopeTime.setElem1((tU8)(parsedTime->tm_mday));
						ScopeTime.setElem2((tU8)(parsedTime->tm_mon+1));
						ScopeTime.setElem3((tU16)(parsedTime->tm_year+1900));
						ScopeTime.setElem4((tU8)(parsedTime->tm_hour));
						ScopeTime.setElem5((tU8)(parsedTime->tm_min));
						EPGprogramtime.setElem1(ScopeTime);
						ProgramInfo.setElem6(EPGprogramtime);
						ETG_TRACE_USR4(("Time  Year %d Month %d Day %d hour %d Mintues %d ",parsedTime->tm_year,parsedTime->tm_mon,parsedTime->tm_mday,parsedTime->tm_hour,parsedTime->tm_min));

						ETG_TRACE_USR4(("sMediumName %s",info.sMediumName.c_str()));
						ETG_TRACE_USR4((" sLongName %s",info.sLongName.c_str()));
						if(numberOfprevEntries==2){
						ProgramInfo3 = ProgramInfo;
						}
						else if(numberOfprevEntries ==1)
						{
						ProgramInfo2 = ProgramInfo;
						}
						else{
						ProgramInfo1 = ProgramInfo;
						}
						//ETG_TRACE_USR4(("Short Description %s",info.sShortDescription.c_str()));						
				}
				tU8 u8Program = 0XFF;
				if(ProgramInfo1.getElem1 ()!=0)
				{
					ProgramInfoVector.push_back(ProgramInfo1);
					u8Program = 2;
				}
				if(ProgramInfo2.getElem1 ()!=0)
				{
					ProgramInfoVector.push_back(ProgramInfo2);
					u8Program = (u8Program!=2)?1:u8Program;
				}
				if(ProgramInfo3.getElem1 ()!=0)
				{
					ProgramInfoVector.push_back(ProgramInfo3);
					u8Program = ((u8Program==2)||(u8Program==1))?u8Program:0;
				}
				u8Program= (u8Program==0xFF)?0:u8Program;
				SchdeduleInfo.setElem5(u8Program);
				/* call dbReset for avoiding issue with busy reused statements */
				m_pDSMHandler->m_pDSM->oDB()->dbReset(pStmt);
				ETG_TRACE_USR4(("u8Program = %d", u8Program));
				ETG_TRACE_USR4(("Getting next schedule info"));
				sqlite3_stmt* pStmt1 = NULL;
				tU64 u64StartTime =0;
				while((u32NumOfEntries--)&&
					(TRUE == m_pDSMHandler->m_pDSM->oDAB()->bGetNextEPGScheduleInfos( &pStmt1,
					contentid,
					info)) )
				{
					ETG_TRACE_USR4(("Next Entry %d",u32NumOfEntries));
					FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Struct ProgramInfo;
					ProgramInfo.setElem1(u32ServiceId);
					ProgramInfo.setElem2(info.sLongName);
					ProgramInfo.setElem3(info.sMediumName);
					//ProgramInfo.setElem4(info.sShortDescription);
					time_t rawtime = info.u64StartTime +Offset;
					if(u64StartTime==0){
						u64StartTime = info.u64StartTime +86400;
					}
					ETG_TRACE_USR4(("Start Time %ld CurrnetEntry Time %ld" ,u64StartTime, info.u64StartTime+Offset));
					if(info.u64StartTime > u64StartTime){
						break;
					}
					struct tm *parsedTime;
					parsedTime = localtime(&rawtime);
					FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Elem6Struct EPGprogramtime;
					FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoElem4Elem6Elem1Struct ScopeTime;
						ScopeTime.setElem1((tU8)(parsedTime->tm_mday));
						ScopeTime.setElem2((tU8)(parsedTime->tm_mon+1));
						ScopeTime.setElem3((tU16)(parsedTime->tm_year+1900));
						ScopeTime.setElem4((tU8)(parsedTime->tm_hour));
						ScopeTime.setElem5((tU8)(parsedTime->tm_min));
					EPGprogramtime.setElem1(ScopeTime);
					ProgramInfo.setElem6(EPGprogramtime);
					ETG_TRACE_USR4(("Time  Year %d Month %d Day %d hour %d Mintues %d ",parsedTime->tm_year,parsedTime->tm_mon,parsedTime->tm_mday,parsedTime->tm_hour,parsedTime->tm_min));

					ETG_TRACE_USR4(("sMediumName %s",info.sMediumName.c_str()));
					ETG_TRACE_USR4((" sLongName %s",info.sLongName.c_str()));
//					ETG_TRACE_USR4(("Short Description %s",info.sShortDescription.c_str()));

					ProgramInfoVector.push_back(ProgramInfo);
				}
				/* call dbReset for avoiding issue with busy reused statements */
				m_pDSMHandler->m_pDSM->oDB()->dbReset(pStmt1);
		}
		else
		{
			ETG_TRACE_USR4(("NULLLLLLLLLLLLLLLLL"));
		}
		SchdeduleInfo.setElem4(ProgramInfoVector);

		sendFID_DAB_S_GET_USERAPP_EPGResponse (0, 1, ServiceInfo, SchdeduleInfo, groupInfo);
#endif
}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::onFID_DAB_GET_LOGOLISTRequest
*
* DESCRIPTION: handles Logo list request from clients.
*
* PARAMETER: const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTRequest >& 
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::onFID_DAB_GET_LOGOLISTRequest (
	const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTRequest >& request) {
		(tVoid)request;

		ETG_TRACE_USR4((" Received onFID_DAB_GET_LOGOLISTRequest"));		

		tU8 u8LogoType = (tU8)(request->getU8LogoType());			

		if((m_pDSMHandler != OSAL_NULL)&&
			(m_pDSMHandler->m_pDSM != OSAL_NULL)&&		
			(m_pDSMHandler->m_pDSM->oDAB() != OSAL_NULL)){

				m_pDSMHandler->vSetImageSize(u8LogoType);

				m_pDSMHandler->m_pDSM->oDAB()->vTriggerAppCompleteEvent();
		}

}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::onFID_DAB_GET_LOGORequest
*
* DESCRIPTION: handles Logo list request from clients.
*
* PARAMETER: const ::boost::shared_ptr< FID_DAB_GET_LOGORequest >& 
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::onFID_DAB_GET_LOGORequest (
	const ::boost::shared_ptr< FID_DAB_GET_LOGORequest >& request){

		tU32 u32ServiceId = request->getU32ServiceId();
		tU8 u8LogoType = (tU8)(request->getU8LogoType());	

		if((m_pDSMHandler != OSAL_NULL)){

			m_pDSMHandler->vSetImageSize(u8LogoType);

			m_pDSMHandler->vonAskLogoBySId(u32ServiceId);
		}

}	

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::vUpdateStationLogoList
*
* DESCRIPTION: Sends logo list to CCA clients and DBUS clients
*
* PARAMETER: ::vector< ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement> 
*			 rLogoData	 
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_dataservices_DBusStub::vUpdateStationLogoList(vector< ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement> rLogoData){

	tU32 u32NumberOfLogos= (tU32)(rLogoData.size());
	vector< FID_G_LOGOLISTSignalLogoListStruct > logoList;
	for(tU32 u32Index=0; u32Index<u32NumberOfLogos;u32Index++)
	{		
		FID_G_LOGOLISTSignalLogoListStruct rLogoElement;
		FID_G_LOGOLISTSignalLogoListElem2Struct rLogoLink;
		tU32 u32ServiceId=rLogoData[u32Index].getU32ServiceID ();
		rLogoElement.setElem1(u32ServiceId);
		string sLink = rLogoData[u32Index].getSLogoLink();
		rLogoLink.setElem1(sLink);
		rLogoElement.setElem2(rLogoLink);

		logoList.push_back(rLogoElement);
	}
	sendFID_G_LOGOLISTSignal(logoList);		
}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::vUpdateStationLogo
*
* DESCRIPTION: Sends logo  to CCA clients and DBUS clients
*
* PARAMETER: tU32 u32ServiceId,string sLogoLink	 
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_dataservices_DBusStub::vUpdateStationLogo(tU32 u32ServiceId,string sLogoLink){

	ETG_TRACE_USR4((" vUpdateStationLogo u32ServiceId %x ",u32ServiceId));

	FID_G_LOGOSignalLogoStruct rLogoElement;
	rLogoElement.setElem1(u32ServiceId);
	FID_G_LOGOSignalLogoElem2Struct rLogoLink;
	rLogoLink.setElem1(sLogoLink);
	rLogoElement.setElem2(rLogoLink);

	sendFID_G_LOGOSignal(rLogoElement);		

}

/******************************************************************************
*
* FUNCTION: fc_dataservices_DBusStub::vUpdateStationLogo
*
* DESCRIPTION: Sends slide  to DBUS clients
*
* PARAMETER: tU32 u32ServiceId,string sLogoLink	 
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::vUpdateSlide(vector<tU8> u8VectorData ,
	Dataservices_tenSlideState enSlideState){

		ETG_TRACE_USR4((" vUpdateSlide SlideSize %d",u8VectorData.size()));

		FID_G_SLIDESignalSlideStruct rSlide;
		rSlide.setElem1((tU32)enSlideState);
		if(enSlideState==SLIDE_STATE_SHOW){
			rSlide.setElem2(u8VectorData);
		}

		sendFID_G_SLIDESignal(rSlide);

}	

/******************************************************************************
*
* FUNCTION: vSendUserAppStatus
*
* DESCRIPTION: sends userapps supported by current sid
*
* PARAMETER: u32SID,  u8Status
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_dataservices_DBusStub::vSendUserAppStatus(tU32 u32SID,tU8 u8Status){

	ETG_TRACE_USR4((" onFID_DAB_G_CHANNEL_INFOStatus SID %x userappstatus %d ",u32SID, u8Status));
	sendFID_G_USERAPP_STATUSSignal(u32SID,u8Status);
}

tVoid fc_dataservices_DBusStub::vUpdateContentid(vector<tclDABServiceManager::tEPGContentIdDataType> m_CtIDList){
	m_DSList = m_CtIDList;
}
tclDABServiceManager::tEPGContentIdDataType fc_dataservices_DBusStub::rGetContentId(tU32 u32Sid){
	tclDABServiceManager::tEPGContentIdDataType var;
	for(tU32 it=0 ;it<m_DSList.size() ;it++){
		ETG_TRACE_USR4(("rGetContentId SID %x ",m_DSList[it].r_service));
		if(m_DSList[it].r_service == u32Sid)
		{
			return m_DSList[it];
		}
	}
	return var;
}
}}
