/************************************************************************
* FILE:         fc_dataservices_DABClientHandler.h
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION:  CCA, DBus Message Handler Class for 
*				fc_dataservices component
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
* 13.07.2015 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | changed name
* to fc_dataservicesDABClientHandler and moved out DBus Handling to
* fc_dataservice_DBusStub
*************************************************************************/
#ifndef _FC_DATASERVICES_DABCLIENTHANDLER_H_
#define _FC_DATASERVICES_DABCLIENTHANDLER_H_

#include "com/dab/MIDW_EXT_DABTUNER_FIProxy.h"
#include "com/dab/MIDW_EXT_DABTUNER_FI.h"
#include <algorithm>
#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"

#include "fc_dataservices_defines.h"
#include "fc_dataservices_DSMHandler.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <vector>

using namespace std;

#include "asf/core/Timer.h"

using namespace std;
using namespace ::asf::core;
namespace fc_dataservices { namespace Server {		
class fc_dataservices_DABClientHandler :public DAB_Singleton<fc_dataservices_DABClientHandler>,
		public ServiceAvailableIF,
		private ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ADR_MSGCallbackIF,
		private ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DSM_MSGCallbackIF,
		private ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DATASERVICES_DATACallbackIF,
		private ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOCallbackIF,
		private ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_LOCAL_OFFSETCallbackIF,
		public TimerCallbackIF
	{
	public:
		fc_dataservices_DABClientHandler();
		~fc_dataservices_DABClientHandler();

		 // ServiceAvailableIF implementation
		virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);
		virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);
	
		/*-----------------CCA FI Call back Functions-----------*/

		virtual tVoid onFID_DAB_G_ADR_MSGError(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ADR_MSGError >& error);

		virtual tVoid onFID_DAB_G_ADR_MSGStatus(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ADR_MSGStatus >& status);

		virtual tVoid onFID_DAB_S_DSM_MSGError(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DSM_MSGError >& error) ;

		virtual tVoid onFID_DAB_S_DSM_MSGResult(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DSM_MSGResult >& result) ;

		virtual tVoid onFID_DAB_S_DATASERVICES_DATAError(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy, 
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DATASERVICES_DATAError >& error) {
				(tVoid)error;
			(tVoid)proxy;
		};

		virtual tVoid onFID_DAB_S_DATASERVICES_DATAResult(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DATASERVICES_DATAResult >& result) {
		(tVoid)result;
			(tVoid)proxy;};

		virtual tVoid onFID_DAB_G_CHANNEL_INFOError(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOError >& error) {
				(tVoid)error;
			(tVoid)proxy;
		}
		virtual tVoid onFID_DAB_G_CHANNEL_INFOStatus(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
			const boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status) ;
			
		virtual void onFID_DAB_G_LOCAL_OFFSETError(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy,
		const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_LOCAL_OFFSETError >& error){
			(tVoid)error;
			(tVoid)proxy;
		}

		virtual void onFID_DAB_G_LOCAL_OFFSETStatus(const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& proxy, 
		const ::boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::FID_DAB_G_LOCAL_OFFSETStatus >& status);
			
		virtual void onExpired(Timer& SLSTriggerTimer, ::boost::shared_ptr<TimerPayload> data);

		tVoid vonDSMMessage( ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_ADRMsg rMsg);	
		tVoid vUpdateStationLogoList(const vector< ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement> &rLogoData, const vector<tclDABServiceManager::tEPGContentIdDataType> &contentIDList);					
		
		tVoid vCloseDataBase();
		
		tVoid vFreeObjects();	

		tBool bMsgInProcess ;	
		

	private:
		boost::shared_ptr< ::com::dab::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > m_pDABFI;	

		fc_dataservices_DSMHandler* m_pDSMHandler;

		tclDispatcher* m_pDispatcher;

		tBool bDABFMlinkingStatus;	

		Timer SLSTriggerTimer;		
	
};
}}
#endif


