/************************************************************************
* FILE:         ServerComponent.h
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION:  Main Classs for fc_dataservices component
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
* 13.07.2015 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | changed name
* to DataservicesComponent and moved out creation of CCA proxy to 
* fc_dataservices_DABClientHandler
*************************************************************************/
#include "asf/core/BaseComponent.h"
#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "fc_dataservices_DABClientHandler.h"
#include "fc_dataservices_DBusStub.h"

namespace fc_dataservices { namespace Server {		

	using namespace ::org::bosch::cm::lcm::lcmbaseappcomponent;

class DataservicesComponent : public BaseComponent,
		// LCM interface
		private LcmApplicationControlIF
	{
	public:
		DataservicesComponent();

		~DataservicesComponent();

		//ServiceAvailableIF
		virtual tVoid onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange) ;

		virtual tVoid onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);

		// LCM Interface implementation
		virtual _NsmErrorStatus_e OnAppModeChange(_Nsm_Shutdown_Type_e newAppMode, _Nsm_Shutdown_Type_e oldAppMode);
		virtual bool   OnAppWatchdog();
		virtual tVoid   OnLcmRegistered();

		// TimerCallbackIF implementation
		virtual tVoid onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> payload);

		// handling persistency
		virtual tVoid onLoadPersistency();
		virtual tVoid onSavePersistency();
		
		bool  bFileExists(string path);
		
		tVoid vCreateFile(string path);

		tVoid vCopyDatabase();
		
		tBool bAreDABDataServicesEnabled();
	private:		

		LcmBaseAppComponent m_LcmAppComponent;	
	
		DECLARE_CLASS_LOGGER();
	};
}}


