/******************************************************************************
 *
 * FILE: tclDSMApp.cpp
 * PROJECT: AaRS
 * SW-COMPONENT: Data Service Manager
 *
 * DESCRIPTION: This file contains the DSM class interface specification
 *
 * AUTHOR: CM-AI/ECB2-Scholz
 *
 * COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
 * HISTORY:
 * Date | Rev. | Author | Modification
 * ----------------------------------------------------------------------------
 * 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
 *
 *****************************************************************************/
#include <stdarg.h>  // for va_start, etc
#include <memory>    // for std::unique_ptr
#include "tclDSM.h"

using namespace dsm;

#ifdef CONFIG_DSM__SLS_OBJECT_SIZE_LIMIT
      tU32 tclDSMDABSLSApp::_u32_object_size_limit = CONFIG_DSM__SLS_OBJECT_SIZE_LIMIT;
#endif
#ifdef CONFIG_DSM__SLS_APP_SIZE_LIMIT
      tU32 tclDSMDABSLSApp::_u32_app_size_limit = CONFIG_DSM__SLS_APP_SIZE_LIMIT;
#endif

#ifdef CONFIG_DSM__ENABLE_DAB_SLS

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABSLSApp::tclDSMDABSLSApp(tclDSM* dsm, tU8 u8TunerIndex,AaRSDABLib::API::DDM::tR_SELECT_URI msg)
    : tclDSMDABMOTApp(dsm,u8TunerIndex,msg.r_uri())
{
    //memset((void*)&prepared_statements,0,sizeof(prepared_statements));

#ifdef CONFIG_DSM__KEEP_ONLY_SLS_FROM_CURRENT_SERVICE
    DeleteAllSLS_except_current();
#endif

    vInitMOTDirectory();

    tclDSMDABMOTApp::vHandleMsgR_SELECT_URI(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABSLSApp::~tclDSMDABSLSApp()
{
    if( _dsm->oDB()->pHandle() != NULL )
    {
        /*
        if( prepared_statements.pStmt_bTryDecodeEPGObject_01 != NULL )
        {
            _dsm->oDB()->dbReset( prepared_statements.pStmt_bTryDecodeEPGObject_01);
            prepared_statements.pStmt_bTryDecodeEPGObject_01 = NULL;
        }
        */
    }
}

#ifdef CONFIG_DSM__KEEP_ONLY_SLS_FROM_CURRENT_SERVICE
/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABSLSApp::DeleteAllSLS_except_current()
{
    /* delete all old SLS objects (except the current SLS objects) */
    SQLITE_API int rc;
    sqlite3_stmt* pStmt = NULL;

    tS64 a = s64GetA(); //the current application

    rc = _dsm->oDB()->dbPrepare(
                             "DELETE FROM dab_data_application WHERE o!=? AND w_user_app_type=2",
                             -1,
                             &pStmt,
                             NULL);
    if( pStmt != NULL )
    {
        _dsm->oDB()->tclDB::dbBindInt64(pStmt, 1, a);
        while(1)
        {
            rc = _dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _dsm->oDB()->dbReset(pStmt);
    }
}
#endif

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
#ifdef CONFIG_DSM_ENABLE_MOT_DIRECTORY_PARAM_FILTER
tBool tclDSMDABSLSApp::bDirectoryParamFilter( tU8 u8ContentType, tU16 u16ContentSubType, tU8 u8ParamId)
{
    (void)u8ContentType;
    (void)u16ContentSubType;
    (void)u8ParamId;
    return TRUE;
}
#endif /* CONFIG_DSM_ENABLE_MOT_DIRECTORY_PARAM_FILTER */

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
void tclDSMDABSLSApp::vHandle()
{
    tclDSMDABMOTApp::vHandle(); /* call parent implementation */

        /* do something ...
         */
}


/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABSLSApp::vInitializeTables(tclDSM* dsm)
{
    (void)dsm;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
bool tclDSMDABSLSApp::bTryHandleSLSObject(tU16 u16_transport_id)
{
    SQLITE_API int rc;
    sqlite3_stmt* pStmt = NULL;
    //tS64 s64_app_time = s64GetApplicationTime();

    /*todo think about calling the sls handler to speed up display*/

    /* delete all old objects (except the current object)
     * where trigger time is equal trigger time now eg. paramid=5 and datafield=0
     * if the current object is complete (header and body)
     */

    rc = _dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT  p2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT  p2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        s64GetA());

        _dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16_transport_id);

        while(1)
        {
            rc = _dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _dsm->oDB()->dbReset(pStmt);
    }

    /* limit the number of slides per applicaton to 12
     * remove the slides with the highest distance to the trigger time*/

    rc = _dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND transpid NOT IN "
                "(SELECT transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 ORDER BY (abs(P2.datafield-?3)) LIMIT 12) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND transpid NOT IN "
                "(SELECT transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 ORDER BY (abs(P2.datafield-?3)) LIMIT 12) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        s64GetA());

        _dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16_transport_id);

        _dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        3,
                                        s64GetApplicationTime());
        while(1)
        {
            rc = _dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _dsm->oDB()->dbReset(pStmt);
    }

    return TRUE;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABSLSApp::vHandleMsgR_DATACHANNEL_FRAME(AaRSDABLib::API::DC::tR_DATACHANNEL_FRAME msg)
{
    tclDSMDABMOTApp::vHandleMsgR_DATACHANNEL_FRAME(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABSLSApp::vHandleMsgR_TIMESTAMP(AaRSDABLib::API::DDM::tR_TIMESTAMP msg)
{
    tclDSMDABMOTApp::vHandleMsgR_TIMESTAMP(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABSLSApp::vHandleMsgR_SELECT_URI(AaRSDABLib::API::DDM::tR_SELECT_URI msg)
{
    tclDSMDABMOTApp::vHandleMsgR_SELECT_URI(msg);
}

#endif /* CONFIG_DSM__ENABLE_DAB_SLS */

/******************************************************************************
 * EOF
 *****************************************************************************/

