/******************************************************************************
 *
 * FILE: tclDSMApp.cpp
 * PROJECT: AaRS
 * SW-COMPONENT: Data Service Manager
 *
 * DESCRIPTION: This file contains the DSM class interface specification
 *
 * AUTHOR: CM-AI/ECB2-Scholz
 *
 * COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
 * HISTORY:
 * Date | Rev. | Author | Modification
 * ----------------------------------------------------------------------------
 * 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
 *
 *****************************************************************************/
#include <stdarg.h>  // for va_start, etc
#include <memory>    // for std::unique_ptr
#include "tclDSM.h"
#define ETG_S_IMPORT_INTERFACE_GENERIC

#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DATASRVCS_DSM_DAB_MOT_APP
#include "trcGenProj/Header/tclDABSLSHandler.cpp.trc.h"
#endif 

using namespace AaRSDABLib;
using namespace AaRSDABLib::API;
using namespace dsm;
using namespace AaRSDABLib;
using namespace AaRSDABLib::API;

#define INVALID_SID         0
#define INVALID_SCIDS    0xff
#define INVALID_TRANSPORTID 0xffffffff

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDABServiceManager::tclDABSLSHandler::tclDABSLSHandler(tclDABServiceManager* parent)
{
    _parent      = parent;
    _s64app_id   = DSM_INVALID_APPID;
    _u16sid      = INVALID_SID;
    _u16scids    = INVALID_SCIDS;
    _u32transpid = INVALID_TRANSPORTID;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDABServiceManager::tclDABSLSHandler::vCheckforExpireandDelete(tU16 u16current_transpid,tS64 s64AppTimeOffset)
{
    SQLITE_API int rc;
    sqlite3_stmt* pStmt = NULL;
    tS64 s64_app_time = (_parent->_dsm->u64ElapsedTimeMS()/1000)-(s64AppTimeOffset);

    /* delete all old objects (except the current object)
     * where trigger time is equal trigger time now eg. paramid=5 and datafield=0
     * if the current object is complete (header and body)
     */

    rc = _parent->_dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT  P2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT  P2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        _s64app_id);

        _parent->_dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16current_transpid);

        while(1)
        {
            rc = _parent->_dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _parent->_dsm->oDB()->dbReset(pStmt);
    }

    /* delete all old objects where trigger time is expired more than 10 minutes*/
    /* eg. paramid=5 and (datafield+10min) < current time*/

    rc = _parent->_dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT P2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND ((P2.datafield+(10*60))<?3)) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND transpid IN "
                "(SELECT P2.transpid FROM dab_mot_directory_param AS P2 WHERE P2.a=?1 AND P2.paramid=5 AND ((P2.datafield+(10*60))<?3)) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        _s64app_id);

        _parent->_dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16current_transpid);

        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        3,
                                        s64_app_time);
        while(1)
        {
            rc = _parent->_dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _parent->_dsm->oDB()->dbReset(pStmt);
    }
    return;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDABServiceManager::tclDABSLSHandler::vCheckforExpireandCompleteandDelete(tU16 u16current_transpid,tS64 s64AppTimeOffset)
{
    SQLITE_API int rc;
    sqlite3_stmt* pStmt = NULL;
    tS64 s64_app_time = (_parent->_dsm->u64ElapsedTimeMS()/1000)-(s64AppTimeOffset);

    /* delete all old objects (except the current object)
     * where trigger time is equal trigger time now eg. paramid=5 and datafield=0
     * if the current object is complete (header and body)
     */

    rc = _parent->_dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND "
                "transpid IN (SELECT  P2.transpid FROM dab_mot_directory_param AS P2 "
                "             WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1) AND "
                "transpid in (SELECT M3.transpid FROM dab_mot_object AS M3, dab_mot_object AS M4 "
                "             WHERE M3.transpid=M4.transpid AND M3.dgtype=3 AND M4.dgtype=4 AND M3.complete=1 AND M4.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND "
                "transpid IN (SELECT  P2.transpid FROM dab_mot_directory_param AS P2 "
                "             WHERE P2.a=?1 AND P2.paramid=5 AND P2.datafield=0) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2) AND "
                "transpid in (SELECT M3.transpid FROM dab_mot_object_complete AS M3, dab_mot_object_complete AS M4 "
                "             WHERE M3.transpid=M4.transpid AND M3.dgtype=3 AND M4.dgtype=4)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        _s64app_id);

        _parent->_dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16current_transpid);

        while(1)
        {
            rc = _parent->_dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _parent->_dsm->oDB()->dbReset(pStmt);
    }

    /* delete all old objects where trigger time is expired more than 10 minutes*/
    /* eg. paramid=5 and (datafield+10min) < current time*/

    rc = _parent->_dsm->oDB()->dbPrepare(
            #ifdef CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
                "DELETE FROM dab_mot_object WHERE a=?1 AND transpid!=?2 AND "
                "transpid IN (SELECT P2.transpid FROM dab_mot_directory_param AS P2 "
                "             WHERE P2.a=?1 AND P2.paramid=5 AND ((P2.datafield+(10*60))<?3)) AND "
                "(SELECT 1 FROM dab_mot_object AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2 AND M1.complete=1) AND "
                "(SELECT 1 FROM dab_mot_object AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2 AND M2.complete=1) AND "
                "transpid in (SELECT M3.transpid FROM dab_mot_object AS M3, dab_mot_object AS M4 "
                "             WHERE M3.transpid=M4.transpid AND M3.dgtype=3 AND M4.dgtype=4 AND M3.complete=1 AND M4.complete=1)",
            #else
                "DELETE FROM dab_datagroup_mot WHERE a=?1 AND transpid!=?2 AND "
                "transpid IN (SELECT P2.transpid FROM dab_mot_directory_param AS P2 "
                "             WHERE P2.a=?1 AND P2.paramid=5 AND ((P2.datafield+(10*60))<?3)) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M1 WHERE M1.a=?1 AND M1.dgtype=3 AND M1.transpid=?2) AND "
                "(SELECT 1 FROM dab_mot_object_complete AS M2 WHERE M2.a=?1 AND M2.dgtype=4 AND M2.transpid=?2) AND "
                "transpid in (SELECT M3.transpid FROM dab_mot_object_complete AS M3, dab_mot_object_complete AS M4 "
                "             WHERE M3.transpid=M4.transpid AND M3.dgtype=3 AND M4.dgtype=4)",
            #endif
                -1,
                &pStmt,
                NULL);

    if( pStmt != NULL )
    {
        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        1,
                                        _s64app_id);

        _parent->_dsm->oDB()->tclDB::dbBindInt(pStmt,
                                      2,
                                      u16current_transpid);

        _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                        3,
                                        s64_app_time);
        while(1)
        {
            rc = _parent->_dsm->oDB()->dbStep(pStmt);
            if( rc == SQLITE_DONE )
            {
                break;
            }
            else if( tclDB::dbOnStepError(rc) )
            {
                break;
            }
        }
        _parent->_dsm->oDB()->dbReset(pStmt);
    }
    return;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDABServiceManager::tclDABSLSHandler::vHandle()
{
    tU16 u16RecentTransportId = 0;
    tS64 s64AppTimeOffset = 0;
    tS64 s64HostTimestamp = 0;
    tS64 s64DABTimestamp = 0;

    char recent_uri[512]="\0";

    if (_s64app_id == DSM_INVALID_APPID)
    {
        if ((_u16sid!=INVALID_SID)&&(_u16scids!=INVALID_SCIDS))
        {
            char uri_test[512];

            /*first check for the PAD*/
            sprintf(uri_test,"/dab/component%%psid=0x%4x%%scids=%d%%",_u16sid,_u16scids);

            /*search for the new SLS in the DSM SQLite*/
            SQLITE_API int rc;
            sqlite3_stmt* pStmt = NULL;

            rc = _parent->_dsm->oDB()->dbPrepare(
                                     "SELECT o, uri,host_timestamp, dab_timestamp "
                                     "FROM dab_data_application "
                                     "WHERE w_user_app_type=2 AND uri LIKE ? LIMIT 1",
                                     -1,
                                     &pStmt,
                                     NULL);
            if( pStmt != NULL )
            {
                _parent->_dsm->oDB()->tclDB::dbBindText(pStmt,
                                  1,
                                  uri_test,
                                  (int)strlen(uri_test),
                                  NULL);
                while(1)
                {
                    rc = _parent->_dsm->oDB()->dbStep(pStmt);
                    if( rc == SQLITE_DONE )
                    {
                        _parent->_dsm->oDB()->dbReset(pStmt);
                        break;
                    }
                    else if( rc == SQLITE_ROW )
                    {
                        if( tclDB::dbColumnCount(pStmt) == 4 )
                        {
                            const char* uri = (const char*)tclDB::dbColumnText( pStmt, 1 );
                            _s64app_id = tclDB::dbColumnInt64( pStmt, 0 );
                            s64HostTimestamp = tclDB::dbColumnInt64( pStmt, 2 );
                            s64DABTimestamp  = tclDB::dbColumnInt64( pStmt, 3 );
                            s64AppTimeOffset = s64HostTimestamp-s64DABTimestamp;

                            if( uri != NULL && (strlen(uri) < 512))
                            {
                                strncpy(recent_uri,uri,sizeof(recent_uri)-1);
                            }
                            _parent->_dsm->oDB()->dbReset(pStmt);
                            break;
                        }
                    }
                    else if( tclDB::dbOnStepError(rc) )
                    {
                        _parent->_dsm->oDB()->dbReset(pStmt);
                        break;
                    }
                }
            }
            //ETG_TRACE_USR1((".tclDABSLSHandler.vHandle() 1.  a=%d host_time=%ld dab_time=%ld %p uri=%s",_s64app_id,s64HostTimestamp,s64DABTimestamp, (void*)this, recent_uri));

            /*if still no app id look for a packet mode slideshow*/
            if (_s64app_id == DSM_INVALID_APPID)
            {
                /*check for the packet mode slideshow*/
                sprintf(uri_test,"/dab/component%%psid=0x%4x%%",_u16sid);

                /*search for the new SLS in the DSM SQLite*/
                SQLITE_API int rc;
                sqlite3_stmt* pStmt = NULL;

                rc = _parent->_dsm->oDB()->dbPrepare(
                                         "SELECT o, uri,host_timestamp, dab_timestamp "
                                         "FROM dab_data_application "
                                         "WHERE w_user_app_type=2 AND uri LIKE ? LIMIT 1",
                                         -1,
                                         &pStmt,
                                         NULL);
                if( pStmt != NULL )
                {
                    _parent->_dsm->oDB()->tclDB::dbBindText(pStmt,
                                      1,
                                      uri_test,
                                      (int)strlen(uri_test),
                                      NULL);
                    while(1)
                    {
                        rc = _parent->_dsm->oDB()->dbStep(pStmt);
                        if( rc == SQLITE_DONE )
                        {
                            _parent->_dsm->oDB()->dbReset(pStmt);
                            break;
                        }
                        else if( rc == SQLITE_ROW )
                        {
                            if( tclDB::dbColumnCount(pStmt) == 4 )
                            {
                                const char* uri = (const char*)tclDB::dbColumnText( pStmt, 1 );
                                _s64app_id = tclDB::dbColumnInt64( pStmt, 0 );
                                s64HostTimestamp = tclDB::dbColumnInt64( pStmt, 2 );
                                s64DABTimestamp  = tclDB::dbColumnInt64( pStmt, 3 );
                                s64AppTimeOffset = s64HostTimestamp-s64DABTimestamp;

                                if( uri != NULL && (strlen(uri) < 512))
                                {
                                    strncpy(recent_uri,uri,sizeof(recent_uri)-1);
                                }
                                _parent->_dsm->oDB()->dbReset(pStmt);
                                break;
                            }
                        }
                        else if( tclDB::dbOnStepError(rc) )
                        {
                            _parent->_dsm->oDB()->dbReset(pStmt);
                            break;
                        }
                    }
                }
            }
            //ETG_TRACE_USR1((".tclDABSLSHandler.vHandle() 2. a=%d host_time=%ld dab_time=%ld %p uri=%s",_s64app_id,s64HostTimestamp,s64DABTimestamp, (void*)this, recent_uri));
        }
#if 0
        /*
         * shz2hi: code disable because:
         * - After adding this code, an abort issue in the target was observed with this code in the callstack
         * - When the current scids and sid is invalid, tC_AUDIO_GET_PSID and tC_AUDIO_GET_SCIDI is send with a hight frequency.
         */
        else
        {
            /*send meca get psid, get scidi*/
            if ((_u16sid==INVALID_SID)&&(_u16scids==INVALID_SCIDS)){
                _parent->vSendDSMMeCaCommand(
                            0,
                            RDM::tC_AUDIO_GET_PSID());
            }
            else if(_u16scids==INVALID_SCIDS){
                _parent->vSendDSMMeCaCommand(
                            0,
                            RDM::tC_AUDIO_GET_SCIDI());
            }
        }
#endif
	}
    else
    {
        /*search for the new SLS in the DSM SQLite*/
        SQLITE_API int rc;
        sqlite3_stmt* pStmt = NULL;
        rc = _parent->_dsm->oDB()->dbPrepare(
                    "SELECT uri, host_timestamp, dab_timestamp FROM dab_data_application WHERE o=? LIMIT 1",
                    -1,
                    &pStmt,
                    NULL);
        if( pStmt != NULL )
        {
            _parent->_dsm->oDB()->tclDB::dbBindInt64(pStmt,
                                                     1,
                                                     _s64app_id);
            while(1)
            {
                rc = _parent->_dsm->oDB()->dbStep(pStmt);
                if( rc == SQLITE_DONE )
                {
                    _parent->_dsm->oDB()->dbReset(pStmt);
                    _s64app_id   = DSM_INVALID_APPID;
                    break;
                }
                else if( rc == SQLITE_ROW )
                {
                    if( tclDB::dbColumnCount(pStmt) == 3 )
                    {
                        const char* uri = (const char*)tclDB::dbColumnText( pStmt, 0 );

                        s64HostTimestamp = tclDB::dbColumnInt64( pStmt, 1 );
                        s64DABTimestamp  = tclDB::dbColumnInt64( pStmt, 2 );
                        s64AppTimeOffset = s64HostTimestamp-s64DABTimestamp;

                        if( uri != NULL && (strlen(uri) < 512))
                        {
                            strncpy(recent_uri,uri,sizeof(recent_uri)-1);
                        }

                        _parent->_dsm->oDB()->dbReset(pStmt);
                        break;
                    }
                }
                else if( tclDB::dbOnStepError(rc) )
                {
                    _parent->_dsm->oDB()->dbReset(pStmt);
                    break;
                }
            }            
        }
        //ETG_TRACE_USR1((".tclDABSLSHandler.vHandle() 3. a=%d host_time=%ld dab_time=%ld %p uri=%s",_s64app_id,s64HostTimestamp,s64DABTimestamp, (void*)this, recent_uri));
    }

    if (_s64app_id != DSM_INVALID_APPID)
    {
        /*check for the recent transpid*/
        if (_parent->bGetRecentTranspId( _s64app_id, u16RecentTransportId, s64AppTimeOffset ))
        {
            if (_u32transpid != (tU32)u16RecentTransportId)
            {
                char s[512];

                _u32transpid = (tU32)u16RecentTransportId;
                sprintf(s,"%s?transpid=0x%04x",recent_uri,_u32transpid);

                _parent->_dsm->vBroadCastEvent( DSM_EV_APPLICATION_SLS_UPDATE, std::string(s) );

                /*inform used*/
                _parent->_dsm->oDAB()->vInformUsed( _s64app_id );
                vCheckforExpireandDelete(u16RecentTransportId, s64AppTimeOffset); //delete either header or body
            }
            else
            {
                /*we have a no new tranport id, but we have to check if we can delete expired and complete objects*/
                vCheckforExpireandCompleteandDelete(u16RecentTransportId, s64AppTimeOffset);
            }
        }
        //ETG_TRACE_USR1((".tclDABSLSHandler.vHandle() 4. a=%d host_time=%ld dab_time=%ld %p, uri=%s",_s64app_id,s64HostTimestamp,s64DABTimestamp, (void*)this,recent_uri));

    }
    //ETG_TRACE_USR1((".tclDABSLSHandler.vHandle() 5. a=%d host_time=%ld dab_time=%ld %p, uri=%s",_s64app_id,s64HostTimestamp,s64DABTimestamp, (void*)this,recent_uri));
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDABServiceManager::tclDABSLSHandler::vHandleMeCaResponse( tU8 u8TunerIdx, AaRSLib::MSG::tResponseMessage message)
{
    (void)u8TunerIdx;
#if 0
    if( message.opcode() == RDM::tR_GET_RDM_STATUS::OP_CODE )
    {
        RDM::tR_GET_RDM_STATUS m(message);
        if (m.b_rdm_events_AUDIO_SERVICE_COMPONENT__CHANGED&m.b_rdm_events_dab())
        {
            /*curr audio comp changed*/
            //_parent->_dsm->vBroadCastEvent(DSM_EV_APPLICATION_SLS_CLEAR,"");

            /*
            _s64app_id   = DSM_INVALID_APPID;
            _u16sid      = INVALID_SID;
            _u16scids    = INVALID_SCIDS;
            _u32transpid = INVALID_TRANSPORTID;
            */
        }
    }
    else 
#endif        
    if( message.opcode() == RDM::tR_AUDIO_GET_PSID::OP_CODE )
    {
        RDM::tR_AUDIO_GET_PSID m(message);
        if (_u16sid != (tU16)(m.r_audio_service()&0xffff))
        {
            _parent->_dsm->vBroadCastEvent(DSM_EV_APPLICATION_SLS_CLEAR,"");
            _s64app_id   = DSM_INVALID_APPID;
            _u32transpid = INVALID_TRANSPORTID;
           _u16sid = (tU16)(m.r_audio_service()&0xffff);
        }
    }
    else if( message.opcode() == RDM::tR_AUDIO_GET_SCIDI::OP_CODE )
    {
        RDM::tR_AUDIO_GET_SCIDI m(message);
        _u16scids = (m.w_scidi()>>8) &0xf;
    }
}

/******************************************************************************
 * EOF
 *****************************************************************************/
