/******************************************************************************
*
* FILE: tclDSM.h
* PROJECT: AaRS
* SW-COMPONENT: Data Service Manager
*
* DESCRIPTION: This file contains the DSM ccompile time configuration
*
* AUTHOR: CM-AI/ECB2-Scholz
*
* COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
* HISTORY:
* Date | Rev. | Author | Modification
* ----------------------------------------------------------------------------
* 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
*
*****************************************************************************/

#ifndef _TCLDSM_CONFIG_RNAAIVI_HEADER_
#define _TCLDSM_CONFIG_RNAAIVI_HEADER_

#if defined(ENABLE_GTEST) || defined(DSM_USE_PC_TYPES)
#include "pc_types.h"
#else
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define AARSLIBCONFIG_DONT_DECLARE_OSAL_TYPES 
#include "../Server/fc_dataservices_defines.h"
#endif

#ifdef ENABLE_GTEST
#include "gtest/gtest.h"
#endif

#define DSM_DEBUG_PRINTLN printf
#define IS_SQLITE_ERROR(rc) (((rc > SQLITE_OK)&&(rc < 100))&&(rc != SQLITE_BUSY))

#define DSM_EPG_FATAL_DECODING_ERROR()
#define DSM_MOT_DIRECTORY_FATAL_DECODING_ERROR()
#define DSM_DEBUG_SQLITE3_ERROR()

#if defined(ENABLE_GTEST)
#define DSM_CONFIG_ENABLE_PERF_TRACE
#ifdef DSM_CONFIG_ENABLE_PERF_TRACE
extern "C" {
void gtest_dsm_trace_perf(const char* source,unsigned long cnt,unsigned long timestamp,unsigned long time,unsigned long timemax,unsigned long timesum);
}
#define DSM_TRACE_PERF(_source_,_cnt_,_timestamp_,_time_,_timemax_,_timesum_) \
    gtest_dsm_trace_perf(_source_,_cnt_,_timestamp_,_time_,_timemax_,_timesum_);
#define DSM_PERF_ENTRY() \
    static tU64 dsm_perf_cnt = 0; \
    static tU64 dsm_perf_t_sum = 0; \
    static tU64 dsm_perf_t_max = 0; \
    tU64 dsm_perf_t_start = _dsm->u64ElapsedTimeMS();

#define DSM_PERF_EXIT(_name_) \
{ \
    tU64 perf_t = _dsm->u64ElapsedTimeMS()-dsm_perf_t_start; \
    dsm_perf_cnt++; \
    if( perf_t > dsm_perf_t_max ) dsm_perf_t_max = perf_t; \
    dsm_perf_t_sum += perf_t; \
    DSM_TRACE_PERF((const char*)(_name_), dsm_perf_cnt,dsm_perf_t_start,perf_t,dsm_perf_t_max,dsm_perf_t_sum); \
}
#endif
#else
#define DSM_PERF_ENTRY()
#define DSM_PERF_EXIT(_name_)
#endif

#define SQLITE_USER_VERSION_MAJOR 0x0021    /* increase for major incompatible change */
#define SQLITE_USER_VERSION_MINOR 0x0001    /* increase for minor, but backwards compatibe change */
#define SQLITE_USER_VERSION ((((SQLITE_USER_VERSION_MAJOR)&0xffff)<<16)|(((SQLITE_USER_VERSION_MINOR)&0xffff)<<0))

#define ENABLE_CLEAR_EPG_DG_SEGM_WHEN_DECODED
#define ENABLE_CLEAR_MOTDIR_DG_SEGM_WHEN_DECODED
#define ENABLE_DELETE_MOTDIR_PARAM_WHEN_OBJECT_SEGM_IS_CLEARED

#define CONFIG_USE_SQLITE_PAGE_SIZE 4096 /* 512, 1024, 2048, 4096, ... */

#define DEFAULT_DSM_FILE_LIMIT (12*1024*1024)

#undef ENABLE_DSM_LOG_TABLE

#undef CONFIG_DSM_ENABLE_EXPLAIN_SQL

#define ENABLE_SQLITE3_LOG
#ifndef SQLITE_OMIT_TRACE
#undef ENABLE_SQLITE3_TRACE
#undef ENABLE_SQLITE3_PROFILE
#endif /* SQLITE_OMIT_TRACE */

#define CONFIG_USE_SQLITE3_SYNCHRONOUS_OFF /* enable this only when sqlite file is running in RAM */
/*
 * With synchronous OFF (0), SQLite continues without syncing as soon as it has handed data off
 * to the operating system. If the application running SQLite crashes, the data will be safe,
 * but the database might become corrupted if the operating system crashes or the computer
 * loses power before that data has been written to the disk surface. On the other hand,
 * commits can be orders of magnitude faster with synchronous OFF.
 */
//#define CONFIG_USE_SQLITE3_SYNCHRONOUS_NORMAL
/*
 * When synchronous is NORMAL (1), the SQLite database engine will still sync at the most critical moments,
 * but less often than in FULL mode. There is a very small (though non-zero) chance that a power failure at
 * just the wrong time could corrupt the database in NORMAL mode. But in practice,
 * you are more likely to suffer a catastrophic disk failure or some other unrecoverable hardware fault.
 * Many applications choose NORMAL when in WAL mode.
 */

/*
 * enable/disable support for radio systems ...
 */
#define CONFIG_DSM__ENABLE_DAB
#undef  CONFIG_DSM__ENABLE_DRM

#ifdef CONFIG_DSM__ENABLE_DAB
#define CONFIG_DSM__MAX_NUM_DAB_TUNER 1
#define CONFIG_DSM__ENABLE_DAB_WIZARD
/*
 * enable/disable support for DAB data service standards ...
 */
#define CONFIG_DSM__ENABLE_DAB_EPG
#undef CONFIG_DSM__ENABLE_DAB_BWS
#define CONFIG_DSM__ENABLE_DAB_SLS
//#define CONFIG_DSM__ENABLE_DAB_JOURNALINE

#endif /* CONFIG_DSM__ENABLE_DAB */

#define CONFIG_DSM_ENABLE_USE_dab_mot_object_TABLE
#undef CONFIG_DSM_ENABLE_USE_dab_mot_object_complete_TABLE
#define CONFIG_DSM_ENABLE_LACY_v_dab_mot_application_COMPLETE_FLAG
#undef CONFIG_DSM_ENABLE_USE_dab_datagroup_mot_age_received_TABLE  /* this keeps keeps the age_received columns in a seperate table */
#define CONFIG_DSM_ENABLE_CHECK_dab_datagroup_mot_BEFORE_INSERT     /* this options skips avoidable transaction for allready complete MOT objects */
#define CONFIG_DSM_ENABLE_USE_INCREMENTAL_VACUUM_ON_INIT            /* use an icremental vacuum on init instead of a normal vacuum, this avoids write access */
#undef ENABLE_DSM_DB_FORCE_IN_MEMORY                                /* keep the sqlite in ram. Import from given file on init and export on calling vClose */
//#ifndef ENABLE_DSM_DB_FORCE_IN_MEMORY
#define ENABLE_SQLITE_WAL
#undef CONFIG_DSM_ENABLE_CYCLIC_WAL_CHECKPOINT_1s                   /* enable cyclic calling 1Hz incremental_vacuum + sqlite3_wal_checkpoint_v2 */
#define CONFIG_DSM_ENABLE_CYCLIC_WAL_CHECKPOINT_60s                 /* enable cyclic calling 1/60Hz incremental_vacuum + sqlite3_wal_checkpoint_v2 */
#undef CONFIG_DSM_ENABLE_USE_MOT_OBJECT_COMPLETE_CACHE              /* no measureable effect */
#define CONFIG_DSM_ENABLE_USE_dab_mot_object_complete_IN_bTryDecodeMOTDirectory /* performance optimiziations, use dab_mot_object_complete table (if available) for directory processing (-20% for vHandleMsgR_DATACHANNEL_FRAME) */

#undef CONFIG_DSM_ENABLE_USE_LOCKING_MODE_EXCLUSIVE                 /* NOT FUNCTIONAL YET: It enabled, only one sqlite3 instance must accesss to file. see https://sqlite.org/tempfiles.html#Shared-Memory Files && https://sqlite.org/pragma.html#pragma_locking_mode */
#define CONFIG_DSM_ENABLE_bTryDecodeEPGObjectIfNessesary_OPTIMIZIATION /* avoids second re-assemble of EPG objects ~20% */
#define CONFIG_DSM_ENABLE_SKIP_DATAGROUP_eua                        /* don't datagroup store eua */
#define CONFIG_DSM_ENABLE_SKIP_DATAGROUP_extfield                   /* don't datagroup store extfield */

#undef CONFIG_DSM__ENABLE_dab_data_application__size_COLUMN			/* negative performance impact */
#undef CONFIG_DSM_ENABLE_DAB_EPG_ADDR_COLUMN                        /* dsm_epg table, display binary xml addr an p_addr column (enable for EPG debugging) */

#define CONFIG_DSM_ENABLE_MOT_DIRECTORY_PARAM_FILTER                /* application type specific filter for MOT directory parameter */

#ifndef ENABLE_DSM_DB_FORCE_IN_MEMORY
#define CONFIG_USE_NUM_PAGES_FOR_PAGECACHE  128
#define CONFIG_USE_SCRATCH_SIZE             4096
#define CONFIG_USE_SCRATCH_NUMBER           16
#endif
#define CONFIG_USE_LOOKASIDE_SIZE           64
#define CONFIG_USE_LOOKASIDE_NUMBER         2048

#define CONFIG_DSM__ENABLE_dab_epg_schedule_scope

//#define CONFIG_DSM_DATACHANNEL_FRAME_DAB_PERF_LIMIT 10            /* NOT FUNCTIONAL YET: max performance used by single application in % */
#ifdef CONFIG_DSM_DATACHANNEL_FRAME_DAB_PERF_LIMIT
#define CONFIG_DSM_DATACHANNEL_FRAME_DAB_PERF_LIMIT_MAX_DC_PERIOD 5000  /* limit for time period between two DC messages */
#define CONFIG_DSM_DATACHANNEL_FRAME_DAB_PERF_LIMIT_LPF_CONSTANT   0.1  /* constant for low pass filter */
#endif /* CONFIG_DSM_DATACHANNEL_FRAME_DAB_PERF_LIMIT */

#ifdef CONFIG_DSM__ENABLE_DAB_EPG
#ifndef CONFIG_DSM__EPG_APP_SIZE_LIMIT
#define CONFIG_DSM__EPG_APP_SIZE_LIMIT      (2048*1024)
#endif
#ifndef CONFIG_DSM__EPG_OBJECT_SIZE_LIMIT
#define CONFIG_DSM__EPG_OBJECT_SIZE_LIMIT   (20*1024)
#define CONFIG_DSM__EPG_ENABLE_BURST_BYTE_LIMIT
#endif

#define CONFIG_DSM__EPG_PARSER_DEPTH 8                              /* max EPG parser depth/recursion level */

/* if enabled, related EPG tags wont be inserted into dab_epg table
 */
//#define CONFIG_DSM__ENABLE_DAB_EPG_ALL
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_STATIONLOGOS
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE /* defaultcontentID + time + mediumName + longName + mediumName + shortDescription */

/* EPG schedule time window
 */
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW
#ifdef CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW_HOURS_PAST    (1*60*60)     /* schedule decode window in past */
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW_HOURS_FUTURE  (3*24*60*60)  /* schedule decode window in future */
#define CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW_HOURS_REFRESH (1*24*60*60)  /* schedule re-decode trigger timeout */
#endif /* CONFIG_DSM__ENABLE_DAB_EPG_BASIC_SCHEDULE_TIMEWINDOW */

#define CONFIG_DSM__IGNORE_COMPRESSED_MOT_DIRECTORIES

#define CONFIG_DSM__ENABLE_DAB_EPG_IGNORE__COMPRESSEDOBJECTS
#ifdef CONFIG_DSM__ENABLE_DAB_EPG_IGNORE__COMPRESSEDOBJECTS
#define CONFIG_DSM__ENABLE_DAB_EPG_IGNORE_AND_CLEAR_SEGM__COMPRESSEDOBJECTS
#endif /* CONFIG_DSM__ENABLE_DAB_EPG_IGNORE__COMPRESSEDOBJECTS */

#undef CONFIG_DSM__ENABLE_DAB_EPG_IN_HEADER_MODE                                         /* out of spec EPG mode, should be disabled by default */

#endif

#ifdef CONFIG_DSM__ENABLE_DAB_SLS

#ifndef CONFIG_DSM__SLS_APP_SIZE_LIMIT
#define CONFIG_DSM__SLS_APP_SIZE_LIMIT      (1024*1024)
#endif

#ifndef CONFIG_DSM__SLS_OBJECT_SIZE_LIMIT
#define CONFIG_DSM__SLS_OBJECT_SIZE_LIMIT   (100*1024)
#endif

#define CONFIG_DSM__KEEP_ONLY_SLS_FROM_CURRENT_SERVICE

#endif //CONFIG_DSM__ENABLE_DAB_SLS

#define CONFIG_DAB_MOT_APP__HEADER_MODE_APP_COMPLETE_TIMEOUT  (5*60)
#define CONFIG_DAB_MOT_APP__MAX_DG_AGE_MINUTES                30 /* Warning: allign value with constants in code */

#endif /* _TCLDSM_CONFIG_RNAAIVI_HEADER_ */
 /******************************************************************************
  * EOF
  *****************************************************************************/

