/************************************************************************
 * FILE:        fc_dabtuner_typeinfo.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_typeinfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DAB_TYPE_INFO_H
#define DAB_TYPE_INFO_H

#ifdef DAB_USE_TYPE_INFO
class DAB_TypeInfo {  

 private:  
    std::type_info const* _pStdInfo;  
    
 public:  
    virtual ~DAB_TypeInfo() {};
    
	DAB_TypeInfo( std::type_info const& stdInfo ):_pStdInfo( &stdInfo ){}
    char const* name() const { return _pStdInfo->name(); }  
    bool operator!=( DAB_TypeInfo const& other ) const  {  
        return !!(*_pStdInfo != *other._pStdInfo);      // "!!" for MSVC non-std ops.  
    }  
        
    bool operator<( DAB_TypeInfo const& other ) const {  
        return !!_pStdInfo->before( *other._pStdInfo ); // "!!" for MSVC non-std ops.  
    }  

    bool operator<=( DAB_TypeInfo const& other ) const {  
        return !other._pStdInfo->before( *_pStdInfo );  
    }  

    bool operator==( DAB_TypeInfo const& other ) const {  
        return !!(*_pStdInfo == *other._pStdInfo);      // "!!" for MSVC non-std ops.  
    }  

    bool operator>=( DAB_TypeInfo const& other ) const {  
        return !_pStdInfo->before( *other._pStdInfo );  
    }  

    bool operator>( DAB_TypeInfo const& other ) const {  
        return !!other._pStdInfo->before( *_pStdInfo ); // "!!" for MSVC non-std ops.  
    }  

};

#endif  

#endif
