/************************************************************************
 * FILE:        fc_dabtuner_timer.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_timer
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_timer.hpp"
#include "fc_dabtuner_dispatcher.hpp"

using namespace DAB;

tVoid DAB_tclTimerMgr::vExecuteTimer(DAB_tTimerHandle hHandle) {
    DAB_tclTimer *poTmr = poGetTimer(hHandle);
    if (OSAL_NULL != poTmr) {
        poTmr->vExecute();
    }
};

tVoid DAB_tclTimer::poSetTmrMgr() {
    DAB_ASSERT_RETURN(_poCaller);
#if 0
    DAB_ASSERT_RETURN(_poCaller->poGetTarget());
    DAB_ASSERT_RETURN(_poCaller->poGetTarget()->poGetDispatcher());
#endif
    _poTmrMgr=_poCaller->poGetTarget()->poGetDispatcher()->poGetTmrMgr();
    DAB_ASSERT_RETURN(_poTmrMgr)
}

tVoid DAB::DAB_vTmrMgrCallbackFn(tVoid *pvArg) {
    DAB_tclTimer *pTmr=(DAB_tclTimer *)pvArg;
    if (!pTmr->bValid()) {
        return;
    }
    pTmr->vPush2Q();
};
