/************************************************************************
 * FILE:        fc_dabtuner_singleton.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_singleton
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DAB_SINGLETON_H
#define DAB_SINGLETON_H

#include "fc_dabtuner_assert.h"


template <typename C>
class DAB_Singleton {
 public:
    static C* instance ()
    {
        if (!_instance) {
            _instance = OSAL_NEW C;
        }
        return _instance;
    }
    virtual
    ~DAB_Singleton ()
    {
       _instance = 0;
    }
 private:
    //lint -esym(1704, DAB_Singleton*::DAB_Singleton*) prio3 constructor has private access specification
    DAB_Singleton(const DAB_Singleton<C>&);	
    DAB_Singleton& operator=(const DAB_Singleton<C>&);
    static C* _instance;
 protected:
    DAB_Singleton () { }
 };

 template <typename C> C* DAB_Singleton <C>::_instance = 0;


#endif
