/************************************************************************
 * FILE:        fc_dabtuner_serialize.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_serialize
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_SERIALIZE_H
#define FC_DABTUNER_SERIALIZE_H

#include "fc_dabtuner_stl.h"

namespace DAB {
    class DAB_Parser {
        tU32 _u32Index;
        tU8 _u8VerMaj;
        tU8 _u8VerMin;
        tU8 _u8VerMajParsed;
        tU8 _u8VerMinParsed;
        tU32 _u32BinDateLen;
        tU8 const *_au8BinData;

    public:  
        DAB_Parser(tU8 u8VerMaj=0, tU8 u8VerMin=0);

        tBool bHasError() const {
            return _au8BinData==NULL;
        }

        tVoid vSetError() {
            _au8BinData=NULL;
        }

        tU8 u8GetVerMin() const {
            return _u8VerMinParsed;
        }

        tBool bRead(tPCU8 pcu8Buf,  tU32 u32Length);

        tVoid vParse(bool &rBoolVal);
#if 0
        tVoid vParse(tBool &rBoolVal);
#endif
        tVoid vParse(tU8 &ru8Val);
        tVoid vParse(tU16 &ru16Val);
        tVoid vParse(tU32 &ru32Val);
        tVoid vParseCString(tChar *pStr, tU8 u8MaxLen);
        tU8   u8ParseBytes(tU8 *pu8Bytes, tU8 u8MaxNumBytes);

        tVoid vParse(string &oString);

        template<class CONT>
        tVoid vParseContainer(CONT &rContainer) {
            rContainer.clear();

            tU32 u32Size;
            vParse(u32Size);
            if (bHasError()) {
                return;
            }
            typename CONT::value_type rVal;
            for (tU32 i=0; i<u32Size;i++) {
                vParse(rVal);
                if (bHasError()) {
                    return;
                }
                rContainer.push_back(rVal);
            }
        }

        template<class SET>
        tVoid vParseSet(SET &rSet) {
            rSet.clear();

            tU32 u32Size;
            vParse(u32Size);
            if (bHasError()) {
                return;
            }
            typename SET::value_type rVal;
            for (tU32 i=0; i<u32Size;i++) {
                vParse(rVal);
                if (bHasError()) {
                    return;
                }
                rSet.insert(rVal);
            }
        }

        template<class MAP>
        tVoid vParseMap(MAP &rContainer) {
            rContainer.clear();
            tU32 u32Size;
            vParse(u32Size);
            if (bHasError()) {
                return;
            }
            typename MAP::key_type rKey;
            typename MAP::mapped_type rVal;
            for (tU32 i=0; i<u32Size;i++) {
                vParse(rKey);
                vParse(rVal);
                if (bHasError()) {
                    return;
                }
                rContainer[rKey]=rVal;
            }
        }

        template<class ENUM>
        tVoid vParseEnum(ENUM &enEnumElem) {
            tU16 u16EnumVal;
            vParse(u16EnumVal);
            if (bHasError()) {
                return;
            }
            enEnumElem=(ENUM)u16EnumVal;
        }

        // for all other types the object has to provide its own parse-fn
        template<class CLASS>
        tVoid vParse(CLASS &rClass) {
            rClass.vParse(*this);
        }

  
    };

    class DAB_Serializer {
        vector<tU8> _au8BinData;
        tU8 _u8VerMaj;
        tU8 _u8VerMin;
    
    public:
        DAB_Serializer(tU8 u8VerMaj=0, tU8 u8VerMin=0);
        
        const tU8* pu8GetData() {
            return &_au8BinData[0];
        }

        tU32 u32GetLen() const {
            return (tU32)_au8BinData.size();
        }

        

        tVoid vSerialize(bool bValue);
#if 0
        tVoid vSerialize(tBool bValue);
#endif

        tVoid vSerialize(tU8 u8Value);



        tVoid vSerialize(tU16 u16Value);


        tVoid vSerialize(tU32 u32Value);
        tVoid vSerializeCString(tChar const *pStr);
        tVoid vSerializeBytes(tU8 const *pu8Bytes, tU8 u8NumBytes);
        tVoid vSerialize(string &oString);

        template<class CONT>
        tVoid vSerializeContainer(CONT const &rContainer) {
            tU32 u32Size=(tU32)rContainer.size();
            vSerialize(u32Size);
            for(typename CONT::iterator iter =rContainer.begin(); iter != rContainer.end(); ++iter) {
                vSerialize(*iter);
            }
        }

        template<class SET>
        tVoid vSerializeSet(SET const &rSet) {
            tU32 u32Size=(tU32)rSet.size();
            vSerialize(u32Size);
            for(typename SET::iterator iter =rSet.begin(); iter != rSet.end(); ++iter) {
                vSerialize(*iter);
            }
        }

        template<class MAP>
        tVoid vSerializeMap(MAP const &rContainer) {
            tU32 u32Size=(tU32)rContainer.size();
            vSerialize(u32Size);
            for(typename MAP::const_iterator iter =rContainer.begin(); iter != rContainer.end(); ++iter) {
                vSerialize(iter->first);
                vSerialize(iter->second);
            }
        }

        template<class ENUM>
        tVoid vSerializeEnum(ENUM enEnumElem) {
            tU16 u16EnumVal=(tU16)enEnumElem;
            vSerialize(u16EnumVal);
        }


        // for all other types the object has to provide its own serialize-fn
        template<class CLASS>
        tVoid vSerialize(CLASS const &rClass) {
            rClass.vSerialize(*this);
        }


    };

} // namespace DAB

#endif
