/************************************************************************
 * FILE:        fc_dabtuner_property.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_property
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_PROPERTY_H
#define FC_DABTUNER_PROPERTY_H

#include "fc_dabtuner_assert.h"
#include "fc_dabtuner_dispatcher.hpp"



// propMessage has to be derived from DAB_Message
template <class propType>
struct DAB_tclProperty
{

 public:
    DAB_tclProperty() {
    }
    DAB_tclProperty(propType const &propVal) {
        _propVal = propVal;
    }
    tVoid vInit(propType const &propVal) {
        _propVal= propVal;
    }
    tVoid vSet(propType const &propVal) {
        if (propVal != _propVal) {
            _propVal= propVal;
            DAB::DAB_poDefaultDispatcher->vNotify(DAB::DAB_poDefaultDispatcher, &_propVal);
        }
    }

    propType const &oGet(tVoid) const {
        return _propVal;
    }

    
 private:
    propType _propVal;
};


#if 0
template <class T>
class DAB_tclProperty {
  T data;
public:

  // access with function call syntax
  DAB_tclProperty() : data() { }
  T operator()() const {
    return data;
  }
  T operator()(T const & value) {
    data = value;
    return data;
  }

  // access with get()/set() syntax
  T get() const {
    return data;
  }
  tBool eq(T const & value) const {
      return (value==data);
  }
  T set(T const & value) {
    data = value;
    return data;
  }


  // access with '=' sign
  // in an industrial-strength library,
  // specializations for appropriate types
  // might choose to add combined operators
  // like +=, etc.
  operator T() const {
    return data;
  }
  T &operator=(T const & value) {
    data = value;
    return data;
  }
  typedef T value_type;
            // might be useful for template
            // deductions

};

// a read-only property calling a
// user-defined getter
template <typename T, typename Object,
          T (Object::*real_getter)()>
class DAB_tclROProperty {
  Object * my_object;
public:
  //  DAB_tclROProperty() : my_object(0) {}
  DAB_tclROProperty(Object * me = 0)
               : my_object(me) {}

  // this function must be called by the
  // containing class, normally in a
  // constructor, to initialize the
  // DAB_tclROProperty so it knows where its
  // real implementation code can be
  // found.
  // obj is usually the containing
  // class, but need not be; it could be a
  // special implementation object.
  tVoid operator()(Object * obj) {
    my_object = obj;
  }

  // function call syntax
  T operator()() const {
    return (my_object->*real_getter)();
  }

  // get/set syntax
  T get() const {
    return (my_object->*real_getter)();
  }
  tVoid set(T const & value);
            // reserved but not implemented,
            // per C++/CLI

  // use on rhs of '='
  operator T() const {
    return (my_object->*real_getter)();
  }

  typedef T value_type;
            // might be useful for template
            // deductions
};

// a write-only property calling a
// user-defined setter
template <class T, class Object,
          T (Object::*real_setter)(T const &)>
class DAB_tclWOProperty {
  Object * my_object;
public:
  DAB_tclWOProperty() : my_object(0) {}
  DAB_tclWOProperty(Object * me = 0)
               : my_object(me) {}

  // this function must be called by the
  // containing class, normally in a
  // constructor, to initialize the
  // DAB_tclWOProperty so it knows where its real
  // implementation code can be found
  tVoid operator()(Object * obj) {
    my_object = obj;
  }
  // function call syntax
  T operator()(T const & value) {
    return (my_object->*real_setter)(value);
  }
  // get/set syntax
  T get() const;
            // reserved but not implemented,
            // per C++/CLI
  T set(T const & value) {
    return (my_object->*real_setter)(value);
  }

  // access with '=' sign
  T operator=(T const & value) {
    return (my_object->*real_setter)(value);
  }

  typedef T value_type;
            // might be useful for template
            // deductions
};

// a read-write property which invokes
// user-defined functions
template <class T,
          class Object,
          T (Object::*real_getter)(),
          T (Object::*real_setter)(T const &)>
class DAB_tclRWProperty {
  Object * my_object;
public:
  DAB_tclRWProperty() : my_object(0) {}
  DAB_tclRWProperty(Object * me = 0)
               : my_object(me) {}

  // this function must be called by the
  // containing class, normally in a
  // constructor, to initialize the
  // DAB_tclROProperty so it knows where its
  // real implementation code can be
  // found
  tVoid operator()(Object * obj) {
    my_object = obj;
  }

  // function call syntax
  T operator()() const {
    return (my_object->*real_getter)();
  }
  T operator()(T const & value) {
    return (my_object->*real_setter)(value);
  }

  // get/set syntax
  T get() const {
    return (my_object->*real_getter)();
  }
  T set(T const & value) {
    return (my_object->*real_setter)(value);
  }
  // access with '=' sign
  operator T() const {
    return (my_object->*real_getter)();
  }
  T operator=(T const & value) {
    return (my_object->*real_setter)(value);
  }

  typedef T value_type;
            // might be useful for template
            // deductions
};

#endif

#endif
