/************************************************************************
 * FILE:        fc_dabtuner_profiler.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_profiler
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DAB_PROFILER_HPP
#define DAB_PROFILER_HPP
#include "fc_dabtuner_assert.h"


namespace DAB {
    class  DAB_Profiler {
    public:
        DAB_Profiler(tChar const *pcUsrMsg_=OSAL_NULL, tU32 u32UsrVal_=0):
            rMyThread(0),
            rStartTime(0),
            pcUsrMsg(pcUsrMsg_),
            u32UsrVal(0)
            {
                vStart(u32UsrVal_);
            }


        tVoid vStart(tU32 u32UsrVal_=0);
        tU32 u32GetMs();

    private:
            OSAL_tMSecond rGetTime() {
            	(void)OSAL_s32ThreadControlBlock(rMyThread, &rCtrBlock);
                return  rCtrBlock.runningTime;
            
            }

            OSAL_tThreadID rMyThread;
            OSAL_tMSecond rStartTime;
            OSAL_trThreadControlBlock rCtrBlock;
            tChar const *pcUsrMsg;
            tU32 u32UsrVal;
    };
}
#endif
