/************************************************************************
 * FILE:        fc_dabtuner_profiler.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_profiler
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_profiler.h"
#include "fc_dabtuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_PROF 
#include "trcGenProj/Header/fc_dabtuner_profiler.cpp.trc.h"
#endif

namespace DAB {

    tVoid DAB_Profiler::vStart(tU32 u32UsrVal_) {
        rMyThread=OSAL_ThreadWhoAmI();
        
        OSAL_s32ThreadControlBlock(rMyThread, &rCtrBlock);
        rStartTime=rGetTime();
        u32UsrVal=u32UsrVal_;
        if (OSAL_NULL != pcUsrMsg) {
            ETG_TRACE_USR1(("START: %20s (0x%08x)",
                            pcUsrMsg, u32UsrVal));                    
        }
    }

    tU32 DAB_Profiler::u32GetMs() {
        OSAL_tMSecond rElapsedTime=rGetTime()-rStartTime;
        if (OSAL_NULL != pcUsrMsg) {
            ETG_TRACE_USR1(("END: %20s (0x%08x) took %d ms",
                            pcUsrMsg, u32UsrVal, rElapsedTime)); }
        return rElapsedTime;
    }



}

