/************************************************************************
 * FILE:        fc_dabtuner_gpio.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_gpio
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_GPIO_H 
#define FC_DABTUNER_GPIO_H
#include "fc_dabtuner_config.h"

class DAB_tclGpio {
public:
    DAB_tclGpio(OSAL_tGPIODevID devId, char const *sMsg = "Unknown");
    ~DAB_tclGpio();
    tBool bOpen();
    tBool bSet(tBool bHigh);
    tBool bSetDir(tBool bOut);
    tVoid vClose();

private:
    tBool bCreateDevGpio();
    static tBool _bDevGpioCreated;

    OSAL_tIODescriptor _hGpio;
    OSAL_trGPIOData  _rGpio;
    tBool _bOutput;
    char const *_sMsg;
    tS32 _s32ErrorCode;
};

#endif
