/************************************************************************
 * FILE:        fc_dabtuner_event.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_event
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_EVENT_HPP
#define FC_DABTUNER_EVENT_HPP



//#include "fc_dabtuner_dispatcher.hpp"
#include "fc_dabtuner_config.h"
#include "fc_dabtuner_messageHandler.h"
#include "fc_dabtuner_trace.h"
#include "fc_dabtuner_profiler.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_DISP
#include "trcGenProj/Header/fc_dabtuner_event.hpp.trc.h"
#endif

namespace DAB {

class DAB_tclEventMgr;
class DAB_tclEvent {
	friend class DAB_tclEventMgr;

public:
    DAB_tclEvent(tVoid) {
        poCaller = OSAL_NULL;
        pMsg = OSAL_NULL;
        u32Mask = 0;
        poEvtMgr=OSAL_NULL;
    }
    tBool bRegistered() const {
        return u32Mask != 0;
    }
private:
    DAB_MsgCallerBase *poCaller;
    DAB_Message *pMsg;
    tU32 u32Mask;
    DAB_tclEventMgr *poEvtMgr;

public:
    tVoid vPost(tVoid) const;
    tVoid vDeregister();
    tVoid vSetEvtMgr();

};



class DAB_tclEventMgr {
	friend class DAB_tclEvent;

public:

    DAB_tclEventMgr(OSAL_tEventHandle hEvent, tU32 u32AvailMask) {
        _hEvent = hEvent;

        for (tU32 u32EvtMask = 1; u32EvtMask!=0;u32EvtMask<<=1) {
            if (u32AvailMask & u32EvtMask) {
                _qFreeMasks.push_back(u32EvtMask);
            }
        }
    }

    ~DAB_tclEventMgr(tVoid) {
        vClose();
    }
    tVoid vClose(tVoid) {
        _qFreeMasks.clear();
        map<tU32,DAB_tclEvent>::iterator iter;
        while (!_mEvents.empty()) {
            iter = _mEvents.begin();
            OSAL_DELETE iter->second.pMsg;
            _mEvents.erase(iter);
        }

    }

    template<class D, class M>
    DAB_tclEvent oRegister(const M* pUsrMsg) {
        return oRegister_(DAB_poGetMsgCaller<D,M>(), pUsrMsg);
    }
    template<class M>
    DAB_tclEvent oRegister_(DAB_MsgCallerBase *poCaller, const M* pUsrMsg) {
        DAB_tclEvent oEvt;
        if (OSAL_NULL==poCaller) {
            return oEvt;
        }

        if (_qFreeMasks.empty()) {
            ETG_TRACE_FATAL(("DAB_tclEvent::oRegister: No Free Events left"));
            return oEvt;
        }
        DAB_Message *pMsg = OSAL_NEW M;
        oEvt= DAB_tclEvent();
        if (OSAL_NULL !=pUsrMsg) {
            *pMsg=*pUsrMsg;
        }
        oEvt.pMsg = pMsg;
        oEvt.poCaller = poCaller;
        oEvt.u32Mask = _qFreeMasks.front();
        oEvt.vSetEvtMgr();
        _qFreeMasks.pop_front();
        _mEvents[oEvt.u32Mask]=oEvt;
        ETG_TRACE_USR4(("DAB_tclEvent::oRegister: receiver=%s msg follows:",
                        poCaller->poGetTarget()->pcGetName()));
        if (OSAL_NULL != pMsg) {
            pMsg->vTrace();
        }

        return oEvt;
    }

    tVoid vDeregister(DAB_tclEvent &roEvt) {
        ETG_TRACE_USR4(("DAB_tclEvent::vDeregister: receiver=%s msg follows:",
                        roEvt.poCaller->poGetTarget()->pcGetName()));
        if (OSAL_NULL != roEvt.pMsg) {
            roEvt.pMsg->vTrace();
        }
        if (_mEvents.count(roEvt.u32Mask)) {
            tU32 u32Mask=roEvt.u32Mask;
            roEvt.u32Mask=0;
            _mEvents.erase(u32Mask);
            OSAL_DELETE _mEvents[u32Mask].pMsg;
            _qFreeMasks.push_back(u32Mask);
        }
        roEvt = DAB_tclEvent();
    }

    tVoid vProcess(tU32 u32Mask) {
        ETG_TRACE_USR4(("DAB_tclEventMgr:vProcess START"));
        static DAB_Profiler rProfiler("EventMgr");

        map<tU32,DAB_tclEvent>::iterator iter;
        //lint -save -esym(1702, operator!=) both member and non-member ops
        for (iter= _mEvents.begin();iter!=_mEvents.end();++iter) {
        //lint -restore
            DAB_tclEvent &roEvt = iter->second;
            if (roEvt.u32Mask & u32Mask) {
                rProfiler.vStart(roEvt.u32Mask);
                roEvt.poCaller->vCall(roEvt.pMsg);
                rProfiler.u32GetMs();
            }
        }
        ETG_TRACE_USR4(("DAB_tclEventMgr:vProcess END"));
    }

private:
    static tVoid vPost(DAB_tclEvent const *poEvt) {
        DAB_ASSERT_RETURN(OSAL_NULL != poEvt);
        if (!poEvt->bRegistered()) {
            return;
        }
        DAB_ASSERT_RETURN(OSAL_NULL != poEvt->poEvtMgr);
        tS32 s32OsalRet = OSAL_s32EventPost(poEvt->poEvtMgr->_hEvent, 
                                       poEvt->u32Mask,
                                       OSAL_EN_EVENTMASK_OR);
        DAB_ASSERT_RETURN(OSAL_OK == s32OsalRet);
        
    }


    OSAL_tEventHandle _hEvent;
    deque<tU32> _qFreeMasks;
    map<tU32,DAB_tclEvent> _mEvents;
};

}
#endif
