/************************************************************************
 * FILE:        fc_dabtuner_assert.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_assert
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DAB_ASSERT_H
#define DAB_ASSERT_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" 

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"
//#define DAB_MAX_MSG_SIZE 1000

#include "../srv/fc_dabtuner_config.h"

#define DAB_NOT_USED(parm) (tVoid)(parm)

#define DABDRV_GET_U32(pu8) ((tU32)(((tU32)((pu8)[0])<<24) + ((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))
#define DABDRV_GET_U24(pu8) ((tU32)(((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))
#define DABDRV_GET_U16(pu8) ((tU16)(((tU16)((pu8)[0])<<8) + (tU16)((pu8)[1] & 0x00ff)))

#define DAB_GET_BOOL(a) ((a)!=0 ? TRUE:FALSE)

//lint -emacro(572, DABDRV_SET_U32) prio2: Excessive shift
//lint -emacro(778, DABDRV_SET_U32) prio2: Constant expression evaluates to 0 in operation '>>'
#define DABDRV_SET_U32(pu8, u32)   \
    (pu8)[0]=(tU8)(((tU32)(u32)>>24)& 0xFF);       \
    (pu8)[1]=(tU8)(((tU32)(u32)>>16)& 0xFF);  \
    (pu8)[2]=(tU8)(((tU32)(u32)>>8) & 0xFF);  \
    (pu8)[3]=(tU8)(((tU32)(u32))    & 0xFF);

//lint -emacro(572, DABDRV_SET_U16) prio2: Excessive shift
//lint -emacro(778, DABDRV_SET_U16) prio2: Constant expression evaluates to 0 in operation '>>'
#define DABDRV_SET_U16(pu8, u16)   \
    (pu8)[0]=(tU8)(((tU16)(u16)>>8) & 0xFF);         \
    (pu8)[1]=(tU8)(((tU16)(u16))    & 0xFF);


#define DAB_BOOL_FROM_BIT(val, mask) (((val)&(mask))!=0)

#define DAB_SET_BIT_FROM_TO(val, valBitPos, target, targetBitPos) \
    if ((val) & (1<<(valBitPos))) {                               \
        target &= ~(1<<(targetBitPos));                                \
    } else {                                              \
        target |= (1<<(targetBitPos));                         \
    }

#define DAB_SET_BIT_U8(bSet, target, targetBitPos) \
    if (!bSet) {                                          \
        target = (tU8)(target & ~((tU8)1<<(targetBitPos)));                   \
    } else {                                              \
        target = (tU8)(target | ((tU8)1<<(targetBitPos)));                          \
    }

#define DAB_SET_BIT_U16(bSet, target, targetBitPos) \
    if (!bSet) {                                          \
        target = (tU16)(target & ~((tU16)1<<(targetBitPos)));                   \
    } else {                                              \
        target = (tU16)(target | ((tU16)1<<(targetBitPos)));                          \
    }



#define DAB_ASSERT_RETURN(expr)                 \
    if (!(expr)) {                              \
        NORMAL_M_ASSERT_ALWAYS();               \
        return;                                 \
    }

#define DAB_ASSERT_RETURN_VAL(expr, retval)     \
    if (!(expr)) {                              \
        NORMAL_M_ASSERT_ALWAYS();               \
        return (retval);                        \
    }

#define DAB_RET_1_IF_NEQ(var) \
if (var != b.var) { \
    return TRUE; \
}

#define DAB_RET_0_IF_NEQ(var) \
if (var != b.var) { \
    return FALSE; \
}

#define DAB_RET_1_IF_LWR(var) \
if (var < b.var) { \
    return TRUE; \
}


#define DAB_FOREACH(contType, iterName, contName)                 \
    for (contType::iterator                                      \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)

#define DAB_FOREACH_MAP(firstType, secondType, iterName, contName)          \
    for (map<firstType, secondType>::iterator                               \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)

#define DAB_FOREACH_MAP_CONST(firstType, secondType, iterName, contName)          \
    for (map<firstType, secondType>::const_iterator                               \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)
#define DAB_FOREACH_MMAP(firstType, secondType, iterName, contName)          \
    for (multimap<firstType, secondType>::iterator                               \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)
#define DAB_FOREACH_MMAP_CONST(firstType, secondType, iterName, contName)          \
    for (multimap<firstType, secondType>::const_iterator                               \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)

#define DAB_FOREACH_CONST(contType, iterName, contName)                 \
    for (contType::const_iterator                                      \
     iterName = contName.begin(); iterName != contName.end(); ++iterName)

#define DAB_IF_FIND(contType, iterName, contName, val)                      \
    contType::iterator iterName = find(contName.begin(),contName.end(),val); \
    if  (iterName != contName.end())


#define DAB_IF_FIND_MAP(firstType, secondType, iterName, contName, val)     \
    map<firstType, secondType>::iterator iterName = contName.find(val); \
    if  (iterName != contName.end())

#define DAB_IF_FIND_MAP_CONST(firstType, secondType, iterName, contName, val)     \
    map<firstType, secondType>::const_iterator iterName = contName.find(val); \
    if  (iterName != contName.end())
#define DAB_IF_FIND_SET(keyType, iterName, contName, val)     \
    set<keyType>::iterator iterName = contName.find(val); \
    if  (iterName != contName.end())


#endif
